-- Claas E302_Cutter
-- powered by hz888

E302_Cutter = {};

function E302_Cutter.prerequisitesPresent(specializations)
    return true;
end;

function E302_Cutter:load(xmlFile)

    self.groundReferenceThreshold = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.groundReferenceNode#threshold"), 0.2);
    self.groundReferenceNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.groundReferenceNode#index"));
    if self.groundReferenceNode == nil then
        self.groundReferenceNode = self.components[1].node;
    end;

    local mowerSound = getXMLString(xmlFile, "vehicle.mowerSound#file");
    if mowerSound ~= nil and mowerSound ~= "" then
        mowerSound = Utils.getFilename(mowerSound, self.baseDirectory); 
        self.mowerSound = createSample("mowerSound");
        self.mowerSoundEnabled = false;
        loadSample(self.mowerSound, mowerSound, false);
        self.mowerSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#pitchOffset"), 1);
        self.mowerSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.mowerSound#volume"), 1);
    end;

    local numCuttingAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.cuttingAreas#count"), 0);
    for i=1, numCuttingAreas do
        local areanamei = string.format("vehicle.cuttingAreas.cuttingArea%d", i);
        self.cuttingAreas[i].foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMinLimit"), 0);
        self.cuttingAreas[i].foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, areanamei .. "#foldMaxLimit"), 1);
    end;

    local numWindrowerDropAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.windrowerDropAreas#count"), 0);
    if numWindrowerDropAreas ~= 1 or numWindrowerDropAreas ~= table.getn(self.cuttingAreas) then
        print("Warning: number of cutting areas and drop areas should be equal");
    end;
    self.windrowerDropAreas = {}
    for i=1, numWindrowerDropAreas do
        self.windrowerDropAreas[i] = {};
        local areanamei = string.format("vehicle.windrowerDropAreas.windrowerDropArea%d", i);
        self.windrowerDropAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.windrowerDropAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.windrowerDropAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;

    self.isTurnedOn = false;
    self.wasToFast = false;
    self.forog = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog#index"));
    self.forog2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.forog2#index"));
end;

function E302_Cutter:delete()

    if self.mowerSound ~= nil then
        delete(self.mowerSound);
    end;

end;

function E302_Cutter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function E302_Cutter:keyEvent(unicode, sym, modifier, isDown)
end;

function E302_Cutter:update(dt)

    self.wasToFast = false;
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
            self.isTurnedOn = not self.isTurnedOn;
        end;
    end;

    if self:getIsActive() then

        if self.isTurnedOn then
            local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
            if not toFast then
                local x,y,z = getWorldTranslation(self.groundReferenceNode);
                local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
                if terrainHeight+self.groundReferenceThreshold >= y then
                    local foldAnimTime = self.foldAnimTime;
                    local numDropAreas = table.getn(self.windrowerDropAreas);
                    local numAreas = table.getn(self.cuttingAreas);
                    local sum = 0;
                    local fruitType = FruitUtil.FRUITTYPE_GRASS;
                    local fruitTypeFix = false;
                    for k, cuttingArea in pairs(self.cuttingAreas) do
                        if foldAnimTime == nil or (foldAnimTime <= cuttingArea.foldMaxLimit and foldAnimTime >= cuttingArea.foldMinLimit) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                            Utils.updateMeadowArea(x, z, x1, z1, x2, z2);
                        end;
                    end;
                    for i=1, numAreas do
                        local cuttingArea = self.cuttingAreas[i];
                        if foldAnimTime == nil or (foldAnimTime <= cuttingArea.foldMaxLimit and foldAnimTime >= cuttingArea.foldMinLimit) then
                            local x,y,z = getWorldTranslation(cuttingArea.start);
                            local x1,y1,z1 = getWorldTranslation(cuttingArea.width);
                            local x2,y2,z2 = getWorldTranslation(cuttingArea.height);

                            local ratio = g_currentMission.windrowCutLongRatio;

                            if not fruitTypeFix then
                                fruitType = FruitUtil.FRUITTYPE_GRASS;
                            end;

                            local area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
                            area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            if area == 0 and not fruitTypeFix then
                                fruitType = FruitUtil.FRUITTYPE_DRYGRASS;
                                area = Utils.updateFruitCutLongArea(fruitType, x, z, x1, z1, x2, z2, 0)/ratio;
                                area = area + Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, 0);
                            end;

                            if area > 0 then
                                fruitTypeFix = true;
                            end;

                            if numDropAreas >= numAreas then
                                if area > 0 then
                                    local dropArea = self.windrowerDropAreas[i];
                                    local x,y,z = getWorldTranslation(dropArea.start);
                                    local x1,y1,z1 = getWorldTranslation(dropArea.width);
                                    local x2,y2,z2 = getWorldTranslation(dropArea.height);
                                    local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
                                    area = area + old;
                                    local value = area / total;
                                    if value < 1 and value > 0.08 then
                                        value = 1;
                                    else
                                        value = math.floor(value + 0.6); -- round, biased to the bigger value
                                    end;
                                    if value >= 1 then
                                        value = math.min(value, g_currentMission.maxWindrowValue);
                                        Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true, false);
                                    end;
                                end;
                            else
                                sum = sum + area;
                            end;
                        end;
                    end;
                    if sum > 0 and numDropAreas > 0 then
                        local dropArea = self.windrowerDropAreas[1];
                        local x,y,z = getWorldTranslation(dropArea.start);
                        local x1,y1,z1 = getWorldTranslation(dropArea.width);
                        local x2,y2,z2 = getWorldTranslation(dropArea.height);
                        local old, total = Utils.getFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2);
                        sum = sum + old;
                        local value = math.floor(sum / total + 0.7); -- round, biased to the bigger value
                        if value >= 1 then
                            value = math.min(value, g_currentMission.maxWindrowValue);
                            Utils.updateFruitWindrowArea(fruitType, x, z, x1, z1, x2, z2, value, true, false);
                        end;
                    end;
                end;
            end;

            if not self.mowerSoundEnabled and self:getIsActiveForSound() then
                setSamplePitch(self.mowerSound, self.mowerSoundPitchOffset);
                playSample(self.mowerSound, 0, self.mowerSoundVolume, 0);
                self.mowerSoundEnabled = true;
            end;

            self.wasToFast = toFast;

        else
            if self.mowerSoundEnabled then
                stopSample(self.mowerSound);
                self.mowerSoundEnabled = false;
            end;
        end;
    if self.isTurnedOn and self.forog ~= nil then
		rotate(self.forog, -dt*0.005, 0, 0);
    end;
    if self.isTurnedOn and self.forog2 ~= nil then
		rotate(self.forog2, -dt*0.005, 0, 0);
    end;
        self.wasToFast = toFast;
      end;

end;

function E302_Cutter:draw()

    if self.isTurnedOn then
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
    else
        g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA);
    end;

    if self.wasToFast then
        g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2", InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL2)), 0.07+0.022, 0.019+0.029);
    end;

end;

function E302_Cutter:onDetach()

    if self.deactivateOnDetach then
        E302_Cutter.onDeactivate(self);
    else
        E302_Cutter.onDeactivateSounds(self)
    end;

end;

function E302_Cutter:onLeave()

    if self.deactivateOnLeave then
        E302_Cutter.onDeactivate(self);
    else
        E302_Cutter.onDeactivateSounds(self)
    end;

end;

function E302_Cutter:onDeactivate()

    E302_Cutter.onDeactivateSounds(self)
    self.isTurnedOn = false;

end;

function E302_Cutter:onDeactivateSounds()

    if self.mowerSoundEnabled then
        stopSample(self.mowerSound);
        self.mowerSoundEnabled = false;
    end;

end;