--
-- Suedkehdingen
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Suedkehdingen = {}

local Suedkehdingen_mt = Class(Suedkehdingen, Mission00);

function Suedkehdingen:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = Suedkehdingen_mt;
    end;
    local self = Suedkehdingen:superClass():new(baseDirectory, mt);
    return self;
end;

function Suedkehdingen:delete()
    Suedkehdingen:superClass().delete(self);
end;

function Suedkehdingen:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    Suedkehdingen:superClass().load(self);
end
function Suedkehdingen:loadFinished()
    Suedkehdingen:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function Suedkehdingen:mouseEvent(posX, posY, isDown, isUp, button)
    Suedkehdingen:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Suedkehdingen:keyEvent(unicode, sym, modifier, isDown)
    Suedkehdingen:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function Suedkehdingen:update(dt)
    Suedkehdingen:superClass().update(self, dt);
end;

function Suedkehdingen:draw()
    Suedkehdingen:superClass().draw(self);
end;
