--
-- LS11 Ready by Blackburner 18.05.2011
--

RauSpridomat = {};

function RauSpridomat.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function RauSpridomat:load(xmlFile)
	self.connectCollisions = SpecializationUtil.callSpecializationsFunction("connectCollisions");
	self.anim = SpecializationUtil.callSpecializationsFunction("anim");
	self.Go = {}; 
	self.Done = {};
	self.charId = {};
	self.clipIndex = {};
	self.CheckDone = {};
	self.moveColli = {}; 
    self.animParts = {};
	self.collisionArm = {};
	self.startpoint = {};
	self.loopCheck = {};
	self.Speed = {};
	local count = getXMLInt(xmlFile, "vehicle.animParts#count");
	local part = self.animParts;
    for i=1, count do
		part[i] = {};
        local partname = string.format("vehicle.animParts.part".."%d", i);
	    local nameR = getXMLString(xmlFile, partname.."#name");
		self.charId[nameR] = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#rootNode"));
		self.clipIndex[nameR] = getXMLString(xmlFile, partname.."#animationClip");
		self.CheckDone[nameR] = false;
		self.moveColli[nameR] = getXMLString(xmlFile, partname.."#moveColli");
		self.startpoint[nameR] = Utils.getNoNil(getXMLFloat(xmlFile, partname.."#startpoint"),0.0);
		if self.moveColli[nameR] ~= nil then
			local Collision = {};
			Collision.collision = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collision"));
			Collision.collisionAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.."#collsionAttacher"));
			Collision.armAttacher = Utils.indexToObject(self.components, getXMLString(xmlFile, partname.. "#armAttacher"));
			Collision.index = 0;
			self.collisionArm[nameR] = Collision;
			self:connectCollisions(nameR);
		end; 
		local charId = getAnimCharacterSet(self.charId[nameR]);
		local clipIndex = getAnimClipIndex(charId, self.clipIndex[nameR]); 
		assignAnimTrackClip(charId , 0, clipIndex);
		setAnimTrackTime(charId, 0, self.startpoint[nameR]);
		enableAnimTrack(charId, 0);
		disableAnimTrack(charId, 0);
		self.loopCheck[nameR] = false;
		self.Speed[nameR] = Utils.getNoNil(getXMLFloat(xmlFile, partname.."#speed"),1.0);
	end;

	self.rauUp = false;
	self.rauDown = false;
	self.folding = false;
	self.saveAILM = self.aiLeftMarker;
	self.rootNode = self.components[1].node;
end;

function RauSpridomat:delete()
end;

function RauSpridomat:onDetach()
end;

function RauSpridomat:anim(varName, loopCheck)
	if self.moveColli[varName] ~= nil then
		local Collision = self.collisionArm[varName];
		setJointFrame(Collision.index, 0, Collision.armAttacher);
	end;
	local loopCheck = self.loopCheck[varName];
	local speed = Utils.getNoNil(self.Speed[varName],1);
	local offset = 10;  
	local charId = getAnimCharacterSet(self.charId[varName]);
	local clipIndex = getAnimClipIndex(charId, self.clipIndex[varName]);
	if self.Done[varName] ~= false then
		if self.Go[varName] == true then
			assignAnimTrackClip(charId , 0, clipIndex);
			setAnimTrackLoopState(charId, 0, loopCheck);
			setAnimTrackSpeedScale(charId, 0, speed);
			enableAnimTrack(charId, 0);
			if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck == false then
				self.Done[varName] = false;	
				self.CheckDone[varName] = self.Go[varName];	
			end;
			if getAnimTrackTime(charId, 0) >= getAnimClipDuration(charId, clipIndex) and loopCheck then
				local setTime = getAnimClipDuration(charId, clipIndex) - getAnimClipDuration(charId, clipIndex);
				setAnimTrackTime(charId, 0, setTime);
			end;
		elseif self.Go[varName] == false then
			if loopCheck == true then
				self.Done[varName] = false;	
			else
				assignAnimTrackClip(charId , 0, clipIndex);
				setAnimTrackLoopState(charId, 0, loopCheck);
				setAnimTrackSpeedScale(charId, 0, -speed);
				enableAnimTrack(charId, 0);
				if getAnimTrackTime(charId, 0) <= 0 then
					self.Done[varName] = false;	
					self.CheckDone[varName] = self.Go[varName];
				end;
			end;
		elseif self.Go[varName] ~= nil then
			assignAnimTrackClip(charId , 0, clipIndex);
			setAnimTrackLoopState(charId, 0, loopCheck);
			if self.Go[varName] < 0.0 then
				self.Go[varName] = 0.0;
			elseif self.Go[varName] > getAnimClipDuration(charId, clipIndex) then
				self.Go[varName] = getAnimClipDuration(charId, clipIndex);
			end;
			if getAnimTrackTime(charId, 0) >= self.Go[varName] then
				setAnimTrackSpeedScale(charId, 0, -speed);
			else
				setAnimTrackSpeedScale(charId, 0, speed);
			end;
			enableAnimTrack(charId, 0);
			if getAnimTrackTime(charId, 0) <= self.Go[varName] + offset and getAnimTrackTime(charId, 0) >= self.Go[varName] - offset then
				self.Done[varName] = false;	
				self.CheckDone[varName] = self.Go[varName];
			end;
		end;
	end;
	if self.Done[varName] == false then
		disableAnimTrack(charId, 0);
	end;
end; 

function RauSpridomat:connectCollisions(varName)
	local Collision = self.collisionArm[varName];
	local constr = JointConstructor:new();
	constr:setActors(self.rootNode, Collision.collision);
	constr:setJointTransforms(Collision.armAttacher, Collision.collisionAttacher);
	for i=1, 3 do		            
		constr:setRotationLimit(i-1, 0, 0, 0);
		constr:setTranslationLimit(i-1, true, 0, 0);
	end;
	Collision.index = constr:finalize();
end;

function RauSpridomat:draw()

	if self.attacherVehicle ~= nil then
		if self.CheckDone.foldLeft then
			g_currentMission:addHelpButtonText(g_i18n:getText("RAU_1"), InputBinding.IMPLEMENT_EXTRA2);  --auf klappen
		elseif not self.CheckDone.foldLeft then
			--if self.fillLevel ~= 0 then
				--if self.isTurnedOn then
					--g_currentMission:addHelpButtonText(g_i18n:getText("RAU_6"), InputBinding.IMPLEMENT_EXTRA); -- aus
				--else
					--g_currentMission:addHelpButtonText(g_i18n:getText("RAU_5"), InputBinding.IMPLEMENT_EXTRA); -- an
				--end;
			--end;
			g_currentMission:addHelpButtonText(g_i18n:getText("RAU_2"), InputBinding.IMPLEMENT_EXTRA2); --zu klappen
			g_currentMission:addHelpButtonText(g_i18n:getText("RAU_3"), InputBinding.RAU_UP); -- heben
			g_currentMission:addHelpButtonText(g_i18n:getText("RAU_4"), InputBinding.RAU_DOWN); -- senken
		end;
	end;
		
end;

function RauSpridomat:update(dt)

	if self.CheckDone.foldLeft then
		self.aiLeftMarker = nil;
	else
		self.aiLeftMarker = self.saveAILM;
	end;

	if self:getIsActiveForInput() then
		--if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			--self.isTurnedOn = not self.isTurnedOn;
		--end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self.Speed.foldRight = 0.6;
			self.Speed.foldLeft = 0.45;
			self.Go.foldRight = not self.Go.foldRight; 
			self.Done.foldRight = true;
			self.Go.foldLeft = not self.Go.foldLeft; 
			self.Done.foldLeft = true;
		end;
		if InputBinding.isPressed(InputBinding.RAU_UP) then
			self.rauUp = true;
		else
			self.rauUp = false;
		end;
		if InputBinding.isPressed(InputBinding.RAU_DOWN) then
			self.rauDown = true;
		else
			self.rauDown = false;
		end;
	end;
	self:anim("middleTrans", false);
	self:anim("foldRight", false);
	self:anim("foldLeft", false);
	local joint1 = self.componentJoints[1];
	setJointFrame(joint1.jointIndex, 0,joint1.jointNode);
	local joint2 = self.componentJoints[2];
	setJointFrame(joint2.jointIndex, 0,joint2.jointNode);
	local joint3 = self.componentJoints[3];
	setJointFrame(joint3.jointIndex, 0,joint3.jointNode);
	local joint4 = self.componentJoints[4];
	setJointFrame(joint4.jointIndex, 0,joint4.jointNode);
	if self.attacherVehicle and not self.CheckDone.foldRight then
		if self.rauDown then
			self.Go.middleTrans = false;
			self.Done.middleTrans = true;
		elseif self.rauUp then
			self.Go.middleTrans = true;
			self.Done.middleTrans = true;
		else
			self.Done.middleTrans = false;
		end;
	end;
end;

function RauSpridomat:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RauSpridomat:keyEvent(unicode, sym, modifier, isDown)
end; 

function RauSpridomat:getSaveAttributesAndNodes(nodeIdent)
	if not self.CheckDone.foldRight then
		transportMode = "false";
	else
		transportMode = "true";
	end; 
	local attributes = 'transport="'..transportMode..'"';
	return attributes, nil;
end;

function RauSpridomat:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
 local transportMode = getXMLString(xmlFile, key.."#transport");
	if transportMode == "true" then
		self.Go.foldRight = true; 
		self.Done.foldRight = true;
		self.Go.foldLeft = true; 
		self.Done.foldLeft = true;
		self.Speed.foldRight = 50;
		self.Speed.foldLeft = 50;
	end; 
    return BaseMission.VEHICLE_LOAD_OK;
end;