﻿--
-- fuellstand
--
-- @author  Schnuller
-- @date  23/06/09
--
-- Copyright (C) Schnuller

fuellstand = {};

function fuellstand.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function fuellstand:load(xmlFile)
	self.combineName = getXMLString(xmlFile, "vehicle.name");
	X, Y, Z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.FuellstandsAnzeigenPosition#Position"));
end;

function fuellstand:keyEvent(unicode, sym, modifier, isDown)
end;

function fuellstand:update(dt)
	local prozent = self.grainTankFillLevel/self.grainTankCapacity*100;	
	if prozent > 0 then
		renderText(X, Y, Z,""..string.format("Bunker %s: %.0f (%d%%)", self.combineName, self.grainTankFillLevel, prozent).."");
	end;
end;

function fuellstand:draw()
end;

function fuellstand:onEnter()
end;

function fuellstand:onLeave()
end;

function fuellstand:delete()
end;

function fuellstand:mouseEvent(posX, posY, isDown, isUp, button)
end;