-- Parallelfahrskript specialization by rafftnix
-- author: rafftnix
-- Special Thanks goes to sven777b
-- History: 
--          v1.0: initial Version (November 2011)
--
-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

Parallelfahrskript = {};

function Parallelfahrskript.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function Parallelfahrskript:load(xmlFile)
	self.Aimarkerleft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index"));
	local x, y, z = getTranslation(self.Aimarkerleft);
	self.AimarkerleftBackup = x;
	self.Aimarkerright = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker#index"));
	local x, y, z = getTranslation(self.Aimarkerright);
	self.AimarkerrightBackup = x;
	self.Helferanzahl = 1;
	self.HUDisActive = true;
end;

function Parallelfahrskript:delete()
end;

function Parallelfahrskript:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Parallelfahrskript:keyEvent(unicode, sym, modifier, isDown)
end;

function Parallelfahrskript:update(dt)
	if self.Aimarkerleft ~= nil then
		if self:getIsActiveForInput() then
			if self.HUDisActive then
				if InputBinding.hasEvent(InputBinding.PARALLELFAHRSKRIPTS_WENIGERHELFER) and self.Helferanzahl >= 2 then
					self.Helferanzahl = self.Helferanzahl - 1;
					local xl, yl, zl = getTranslation(self.Aimarkerleft);
					local xr, yr, zr = getTranslation(self.Aimarkerright);
					local rechnen1 = self.AimarkerleftBackup * self.Helferanzahl;
					local rechnen2 = self.AimarkerrightBackup * self.Helferanzahl;
					setTranslation(self.Aimarkerleft, rechnen1, yl, zl);
					setTranslation(self.Aimarkerright, rechnen2, yr, zr);
				end;
				if InputBinding.hasEvent(InputBinding.PARALLELFAHRSKRIPTS_MEHRHELFER) and self.Helferanzahl <= 9 then
					self.Helferanzahl = self.Helferanzahl + 1;
					local xl, yl, zl = getTranslation(self.Aimarkerleft);
					local xr, yr, zr = getTranslation(self.Aimarkerright);
					local rechnen1 = self.AimarkerleftBackup * self.Helferanzahl;
					local rechnen2 = self.AimarkerrightBackup * self.Helferanzahl;
					setTranslation(self.Aimarkerleft, rechnen1, yl, zl);
					setTranslation(self.Aimarkerright, rechnen2, yr, zr);
				end;
			end;
			if InputBinding.hasEvent(InputBinding.PARALLELFAHRSKRIPTS_HUD) then
				self.HUDisActive = not self.HUDisActive;
			end;		
		end;	
	end;	
end;

function Parallelfahrskript:draw()
	if self.Aimarkerleft ~= nil then
		if self.HUDisActive then
			renderText(0.0270, 0.220, 0.025, "Helferanzahl");
			renderText(0.1700, 0.220, 0.025, tostring(self.Helferanzahl));
			renderText(0.0270, 0.180, 0.025, "Mehr Helfer:");
			renderText(0.1700, 0.180, 0.025, "Taste Numpad 6");
			renderText(0.0270, 0.140, 0.025, "Weniger Helfer:");
			renderText(0.1700, 0.140, 0.025, "Taste Numpad 4");
			renderText(0.0270, 0.100, 0.025, "HUD aus:");
			renderText(0.1700, 0.100, 0.025, "Taste Numpad 0");
		else
			g_currentMission:addHelpButtonText("Parallelfahrskript HUD anschalten", InputBinding.PARALLELFAHRSKRIPTS_HUD);
		end;
	end;
end;