-- Helferrichtung specialization by rafftnix
-- author: rafftnix
-- History: 
--          v1.0: initial Version (November 2011)
--
-- nderungen am Skript nur mit meiner Zustimmung!
-- Modification only with my permission!

HelferRichtung = {};

function HelferRichtung.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function HelferRichtung:load(xmlFile)
	local ueberlappung = 0.975;
	if self.aiTurnThreshWidthScale ~= nil then
		self.aiTurnThreshWidthScale = ueberlappung;
	end;
	if self.aiTurnWidthScale ~= nil then
		self.aiTurnWidthScale = ueberlappung;
	end;
end;

function HelferRichtung:delete()
end;

function HelferRichtung:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HelferRichtung:keyEvent(unicode, sym, modifier, isDown)
end;

function HelferRichtung:update(dt)		
	if self:getIsActiveForInput() then
		if self.isAITractorActivated or self.isAIThreshing then
			if InputBinding.hasEvent(InputBinding.HELFERRICHTUNG_NEU) then
				if self.isAIThreshing then
					g_DrescherHelferRichtungX = self.aiThreshingDirectionX;
					g_DrescherHelferRichtungZ = self.aiThreshingDirectionZ;
				elseif self.isAITractorActivated then
					g_TraktorHelferRichtungX = self.aiTractorDirectionX;
					g_TraktorHelferRichtungZ = self.aiTractorDirectionZ;
				end;
			end; 
			if InputBinding.hasEvent(InputBinding.HELFERRICHTUNG_EINSETZEN) then
				if self.isAIThreshing and g_DrescherHelferRichtungX ~= nil then	
					self.aiThreshingDirectionX = g_DrescherHelferRichtungX;
					self.aiThreshingDirectionZ = g_DrescherHelferRichtungZ;	
				end;
				if self.isAITractorActivated and g_TraktorHelferRichtungX ~= nil then
					self.aiTractorDirectionX = g_TraktorHelferRichtungX;
					self.aiTractorDirectionZ = g_TraktorHelferRichtungZ;
				end;	
			end;	
		end;
	end;
end;

function HelferRichtung:draw()
	if self.isAITractorActivated or self.isAIThreshing then
		if self.isAIThreshing and g_DrescherHelferRichtungX ~= nil then
			g_currentMission:addHelpButtonText("Helferrichtung einsetzen", InputBinding.HELFERRICHTUNG_EINSETZEN);
		elseif self.isAITractorActivated and g_TraktorHelferRichtungX ~= nil then
			g_currentMission:addHelpButtonText("Helferrichtung einsetzen", InputBinding.HELFERRICHTUNG_EINSETZEN);
		end;
		g_currentMission:addHelpButtonText("Helferrichtung kopieren", InputBinding.HELFERRICHTUNG_NEU);
	end;
end;