--
-- pesticideTrailer
-- Specialization for pesticideTrailer
--
-- @author Felix "Outlaw" Sorge
-- @date  20/05/09
-- @web www.ls-modsource.de - www.ls-mods.de
--
-- Copyright (C) Outlaw, All Rights Reserved.
--


pesticideTrailer = {};

function pesticideTrailer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function pesticideTrailer:load(xmlFile)
	self.setTurnedOn = SpecializationUtil.callSpecializationsFunction("setTurnedOn");
	self.fertilizerInRange = SpecializationUtil.callSpecializationsFunction("fertilizerInRange");
	self.manureInArmRange = SpecializationUtil.callSpecializationsFunction("manureInArmRange");
	self.literPerSecond = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.literPerSecond#value"), 1);
	
	self.chargeTypes = {};
	self.fillTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
	local chargeTypes = getXMLString(xmlFile, "vehicle.chargeTypes#chargeTypes");
    if chargeTypes ~= nil then
		self.chargefillNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chargeTypes#fillNode"));
		self.chargefillNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.chargeTypes#fillNode2"));
        local types = Utils.splitString(" ", chargeTypes);
        for k,v in pairs(types) do
            local desc = Fillable.fillTypeNameToInt[v];
            if desc ~= nil then
                self.chargeTypes[desc] = true;
            end;
        end;
    end;	
	local workSound = getXMLString(xmlFile, "vehicle.workSound#file");
    if workSound ~= nil and workSound ~= "" then
        workSound = Utils.getFilename(workSound, self.baseDirectory); 
        self.workSound = createSample("workSound");
        self.workSoundEnabled = false;
        loadSample(self.workSound, workSound, false);
    end;

	
	self.keyType = InputBinding.getKeyNamesOfDigitalAction;
	self.keyName = "Taste";	
	if g_settingsJoystickEnabled then 
		self.keySet = not self.keySet;
	end; 	
end;

function pesticideTrailer:update(dt)
	for chargeTypes,v in pairs(self.chargeTypes) do	
		if chargeTypes == self.currentFillType then
			if self.fillLevel ~= 0 then
				self:fertilizerInRange(dt);
				--self:manureInArmRange(dt);
			end; 
		elseif self.fillLevel == 0 then
			if self.turnOn then
				self.turnOn = not self.turnOn; 
			end; 
			if self.turnOn1 then
				self.turnOn1 = not self.turnOn1; 
			end; 
			if self.workSoundEnabled then
				stopSample(self.workSound);
				self.workSoundEnabled = false;
			end;
			self:setFillLevel(0, FruitUtil.FRUITTYPE_UNKNOWN); 				
		end; 	
	end; 	

end;

function pesticideTrailer:fertilizerInRange(dt)
	self.inRange = false; 
    local nearestDistance = 5.0;
	local px, py, pz = getWorldTranslation(self.chargefillNode);
	for i=1, table.getn(g_currentMission.attachables) do
		local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance  then
			local attachable = g_currentMission.attachables[i];			
			for fruitType,v in pairs(attachable.fillTypes) do
				if fruitType == self.currentFillType and attachable.rootNode ~= self.rootNode and attachable.setFillLevel ~= nil then
					if attachable.fillLevel == attachable.capacity  or self.filllevel == 0 then
						self.turnOn = false; 
						if self.workSoundEnabled then
							stopSample(self.workSound);
							self.workSoundEnabled = false;
						end;
					elseif attachable.fillLevel ~= attachable.capacity  and self.fillLevel ~= 0  then
						if self.turnOn then
								g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.pesticideTrailer_ON).. ": " ..g_i18n:getText("pesticideTrailer_2")); 
							if InputBinding.hasEvent(InputBinding.pesticideTrailer_ON) then
								self:setTurnedOn((not self.turnOn), self.turnOn1); 								
								if self.workSoundEnabled then
									stopSample(self.workSound);
									self.workSoundEnabled = false;
								end;
							end;
						else
							g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.pesticideTrailer_ON).. ": " ..g_i18n:getText("pesticideTrailer_1")); 
							if InputBinding.hasEvent(InputBinding.pesticideTrailer_ON)  then
								self:setTurnedOn((not self.turnOn), self.turnOn1); 
								if not self.workSoundEnabled then
								     playSample(self.workSound, 0, 1, 0);
									self.workSoundEnabled = true;   
								end; 
			
							end;
						end;
						if self.turnOn then
							self.inRange = true; 
							local deltaLevel = self.literPerSecond*dt/1000.0;
							deltaLevel = math.min(deltaLevel, attachable.capacity - attachable.fillLevel);
							self.fillLevel = self.fillLevel-deltaLevel;
							self:setFillLevel(self.fillLevel, self.currentFillType);
							attachable:setFillLevel(attachable.fillLevel + deltaLevel, self.currentFillType);	
						end; 	
					end; 
				end;
			end;
		end;
    end;
	if not self.inRange and self.turnOn and self.workSoundEnabled then
		if self.workSoundEnabled then
			self.turnOn = not self.turnOn; 
			stopSample(self.workSound);
			self.workSoundEnabled = false;
		end;
	end;
end;
function pesticideTrailer:manureInArmRange(dt)
	self.arminRange = false; 
    local nearestDistance = 0.3;
	local px, py, pz = getWorldTranslation(self.chargefillNode2);
	for i=1, table.getn(g_currentMission.attachables) do
		if g_currentMission.attachables[i].fillArmNode ~= nil and  g_currentMission.attachables[i].allowFillWithArm then
			local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].fillArmNode);
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
			if distance < nearestDistance then
				local attachable = g_currentMission.attachables[i];	
				for fruitType,v in pairs(attachable.fillTypes) do
					if fruitType == self.currentFillType and attachable.rootNode ~= self.rootNode and attachable.setFillLevel ~= nil then
						if attachable.fillLevel == attachable.capacity  or self.filllevel == 0 then
							self.turnOn1 = false; 
							if self.workSoundEnabled then
								stopSample(self.workSound);
								self.workSoundEnabled = false;
							end;
						elseif attachable.fillLevel ~= attachable.capacity  and self.fillLevel ~= 0 then
							if self.turnOn1 then
								g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.pesticideTrailer_ON).. ": " ..g_i18n:getText("pesticideTrailer_2")); 
								if InputBinding.hasEvent(InputBinding.pesticideTrailer_ON) then
									self:setTurnedOn(self.turnOn, not self.turnOn1); 
									if self.workSoundEnabled then
										stopSample(self.workSound);
										self.workSoundEnabled = false;
									end;
								end;
							else
								g_currentMission:addExtraPrintText(self.keyName.. " " ..self.keyType(InputBinding.pesticideTrailer_ON).. ": " ..g_i18n:getText("pesticideTrailer_1")); 
								if InputBinding.hasEvent(InputBinding.pesticideTrailer_ON)  then
									self:setTurnedOn(self.turnOn, not self.turnOn1); 
									if not self.workSoundEnabled then
										playSample(self.workSound, 0, 1, 0);
										self.workSoundEnabled = true;   
									end; 
								end;
							end;
							if self.turnOn1 then
								self.arminRange = true; 
								local deltaLevel = self.literPerSecond*dt/1000.0;
								deltaLevel = math.min(deltaLevel, attachable.capacity - attachable.fillLevel);
								self.fillLevel = self.fillLevel-deltaLevel;
								self:setFillLevel(self.fillLevel, self.currentFillType);
								attachable:setFillLevel(attachable.fillLevel + deltaLevel, self.currentFillType);	
							end; 	
						end; 
					end;
				end;
			end;
		end;
	end;
	if not self.arminRange and self.turnOn1 and self.workSoundEnabled then
		if self.workSoundEnabled then
			self.turnOn1 = not self.turnOn1; 
			stopSample(self.workSound);
			self.workSoundEnabled = false;
		end;
	end;
end;

function pesticideTrailer:delete()
end;

function pesticideTrailer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function pesticideTrailer:keyEvent(unicode, sym, modifier, isDown)
end;

function pesticideTrailer:draw()
end;

function pesticideTrailer:onAttach()
end; 	

function pesticideTrailer:onDetach()
end;

function pesticideTrailer:setTurnedOn(turned_on, turned_on1, noEventSend)
  if noEventSend ~= true then
		pesticideTrailerEvent.sendEvent(self, turned_on, turned_on1);
	end;
	self.turnOn = turned_on
	self.turnOn1 = turned_on1
end


pesticideTrailerEvent = {};
pesticideTrailerEvent_mt = Class(pesticideTrailerEvent, Event);

InitEventClass(pesticideTrailerEvent, "pesticideTrailerEvent");

function pesticideTrailerEvent:emptyNew() 
    local self = Event:new(pesticideTrailerEvent_mt );
    self.className="pesticideTrailerEvent";
    return self;
end;

function pesticideTrailerEvent:new(vehicle, turned_on, turned_on1)
    self.vehicle = vehicle;
    self.turnOn = turned_on
	self.turnOn1 = turned_on1
    return self;
end;

function pesticideTrailerEvent:readStream(streamId, connection) 
    local id = streamReadInt32(streamId);	
	self.vehicle = networkGetObject(id);
    self.turnOn = streamReadBool(streamId);
	self.turnOn1 = streamReadBool(streamId);
    self:run(connection); 
end;

function pesticideTrailerEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
    streamWriteBool(streamId, self.turnOn );     
	streamWriteBool(streamId, self.turnOn1 );    
end;

function pesticideTrailerEvent:run(connection)  
    self.vehicle:setTurnedOn(self.turnOn, self.turnOn1, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(pesticideTrailerEvent:new(self.vehicle, self.turnOn, self.turnOn1), nil, connection, self.object);
	end;
end;

function pesticideTrailerEvent.sendEvent(vehicle, turned_on, turned_on1, noEventSend) 
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then 
			g_server:broadcastEvent(pesticideTrailerEvent:new(vehicle, turned_on, turned_on1), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(pesticideTrailerEvent:new(vehicle, turned_on, turned_on1));			
		end;
	end;
end;