--
-- AIUpdate
-- Speichert den Kurs der Helfer
--
-- @author  Micha381
-- @date  05/06/09

function AITractor:draw()
    if not g_currentMission.disableTractorAI then
        if self.aiLeftMarker ~= nil and self.aiRightMarker ~= nil and self.aiBackMarker ~= nil then
            if self.isAITractorActivated then
                g_currentMission:addHelpButtonText(g_i18n:getText("DismissEmployee"), InputBinding.TOGGLE_AI);
            else
                g_currentMission:addHelpButtonText(g_i18n:getText("HireEmployee"), InputBinding.TOGGLE_AI);
				if self.aiTractorDirectionX and self.aiTractorDirectionZ then
				g_currentMission:addHelpButtonText(g_i18n:getText("AIcourse"), InputBinding.AI_COURSE)
				if InputBinding.hasEvent(InputBinding.AI_COURSE) then
				    self.aiTractorDirectionX = nil;self.aiTractorDirectionZ = nil
				end
            end;end
        end;
    end;
end;

function AICombine:draw()

    if not g_currentMission.disableCombineAI then
        if self.numAttachedCutters > 0 then
            if self.isAIThreshing then
                g_currentMission:addHelpButtonText(g_i18n:getText("DismissEmployee"), InputBinding.TOGGLE_AI);
            else
                g_currentMission:addHelpButtonText(g_i18n:getText("HireEmployee"), InputBinding.TOGGLE_AI);
				if self.aiThreshingDirectionX and self.aiThreshingDirectionZ then
				g_currentMission:addHelpButtonText(g_i18n:getText("AIcourse"), InputBinding.AI_COURSE)
				if InputBinding.hasEvent(InputBinding.AI_COURSE) then
				    self.aiThreshingDirectionX = nil;self.aiThreshingDirectionZ = nil
				end
            end;end
        end;
    end;
end;

function AITractor:getSaveAttributesAndNodes(nodeIdent)
local attributes
if self.aiTractorDirectionX and self.aiTractorDirectionZ then
attributes = 'lastDirection="'..self.aiTractorDirectionX..' 0 '..self.aiTractorDirectionZ..'" '
end
return attributes
end;

function AICombine:getSaveAttributesAndNodes(nodeIdent)
local attributes
if self.aiThreshingDirectionX and self.aiThreshingDirectionZ then
attributes = 'lastDirection="'..self.aiThreshingDirectionX..' 0 '..self.aiThreshingDirectionZ..'" '
end
return attributes
end;

function AITractor:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#lastDirection"));
  if x and z then
  self.aiTractorDirectionX = x
  self.aiTractorDirectionZ = z
  end
return BaseMission.VEHICLE_LOAD_OK
 end

function AICombine:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, key.."#lastDirection"));
if x and z then
self.aiThreshingDirectionX = x
self.aiThreshingDirectionZ = z
end;
return BaseMission.VEHICLE_LOAD_OK
end

function AITractor:startAITractor()
    self:hire();
    if not self.isAITractorActivated then

        self.isAITractorActivated = true;
        self.turnTimer = self.turnTimeoutLong;
        self.turnStage = 0;

        local x,y,z = localDirectionToWorld(self.aiTractorDirectionNode, 0, 0, 1);
		local length = Utils.vector2Length(x,z);
		local dX = x/length
		local dZ = z/length
		local x,y,z = getWorldTranslation(self.aiTractorDirectionNode);
		self.aiTractorTargetX = x;
        self.aiTractorTargetZ = z;
		if self.aiTractorDirectionX and self.aiTractorDirectionZ then
		  local angle = math.deg(math.atan2(self.aiTractorDirectionX,self.aiTractorDirectionZ))
		  local Angle = math.deg(math.atan2(dX,dZ))
		  local res = math.abs(angle-Angle)
		  if res > 90.0001 then
		   self.aiTractorDirectionX = self.aiTractorDirectionX*-1
		   self.aiTractorDirectionZ = self.aiTractorDirectionZ*-1
		  end
        else
		  self.aiTractorDirectionX = dX
          self.aiTractorDirectionZ = dZ
		
		
        end
		
        self.numCollidingVehicles = 0;
        if self.aiTrafficCollisionTrigger ~= nil then
            addTrigger(self.aiTrafficCollisionTrigger, "onTrafficCollisionTrigger", self);
        end;

        AITractor.updateToolsInfo(self);
        for k,implement in pairs(self.attachedImplements) do
            if implement.object.needsLowering and implement.object.aiNeedsLowering then
                local jointDesc = self.attacherJoints[implement.jointDescIndex];
                jointDesc.moveDown = true;
            end;
            implement.object:aiTurnOn();
            AITractor.addToolTrigger(self, implement.object);
        end;

        self.checkSpeedLimit = false;

        setVisibility(self.aiMotorSound, true);

    end;
end;


function AICombine:startAIThreshing()
    self:hire();
    if not self.isAIThreshing then
        self.isAIThreshing = true;
        self.turnTimer = self.turnTimeoutLong;
        self.turnStage = 0;

        local x,y,z = localDirectionToWorld(self.aiTreshingDirectionNode, 0, 0, 1);
        local length = Utils.vector2Length(x,z);
        local dX = x/length;
        local dZ = z/length;

        local x,y,z = getWorldTranslation(self.aiTreshingDirectionNode);
        self.aiThreshingTargetX = x;
        self.aiThreshingTargetZ = z;
		 
		if self.aiThreshingDirectionX and self.aiThreshingDirectionZ then
		  local angle = math.deg(math.atan2(self.aiThreshingDirectionX,self.aiThreshingDirectionZ))
		  local Angle = math.deg(math.atan2(dX,dZ))
		  local res = math.abs(angle-Angle)
		  if res > 90.0001 then
		   self.aiThreshingDirectionX = self.aiThreshingDirectionX*-1
		   self.aiThreshingDirectionZ = self.aiThreshingDirectionZ*-1
		end
        else
		self.aiThreshingDirectionX = dX
        self.aiThreshingDirectionZ = dZ
		
end
		
		
		
		

        self.speedDisplayScale = 0.5;

        self.waitingForDischarge = false;

        if not self.isThreshing then
            self:startThreshing();
        end;

        if self.aiTrailerTrigger ~= nil then
            addTrigger(self.aiTrailerTrigger, "onTrailerTrigger", self);
        end;

        self.numCollidingVehicles = 0;
        if self.aiTrafficCollisionTrigger ~= nil then
            addTrigger(self.aiTrafficCollisionTrigger, "onTrafficCollisionTrigger", self);
        end;
        for cutter,implement in pairs(self.attachedCutters) do
            AICombine.addCutterTrigger(self, cutter);
        end;
        self.isTrailerInRange = false;

        self.checkSpeedLimit = false;

        setVisibility(self.aiMotorSound, true);
        setVisibility(self.aiThreshingSound, true);

        self.waitingForWeather = false;

    end;
end;

function Hirable:load(xmlFile)

    self.hire = SpecializationUtil.callSpecializationsFunction("hire");
    self.dismiss = SpecializationUtil.callSpecializationsFunction("dismiss");

    self.pricePerMS = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pricePerHour"), 500)/60/60/1000;
	self.aiUseFuel = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.ai_fuelUsage"),50)
    self.isHired = false;
end;

function Hirable:update(dt)
    if self.isHired then
        self.forceIsActive = true;
        self.stopMotorOnLeave = false;
        self.steeringEnabled = false;
        self.deactivateOnLeave = false;

        g_currentMission.missionStats.money = g_currentMission.missionStats.money - dt*self.pricePerMS;
		
		if self.aiUseFuel > 0 then
		local usagePerMS = self.aiUseFuel/60/60/1000
		    local fuelUsed = dt*usagePerMS;
            self:setFuelFillLevel(self.fuelFillLevel-fuelUsed);

            g_currentMission.missionStats.fuelUsageTotal = g_currentMission.missionStats.fuelUsageTotal + fuelUsed;
            g_currentMission.missionStats.fuelUsageSession = g_currentMission.missionStats.fuelUsageSession + fuelUsed;

            end
    end;
end;

