print("register fruit type: soybean");

local soyhudFile = Utils.getFilename("mods/Map_Fruits/soyHud.png", getUserProfileAppPath());
FruitUtil.registerFruitType("soybean", true, true, false, 0.3, 0.4, 0.38, 0.05, 0.02, soyhudFile);

local origLoadStatsFromXML = QuickPlayMenu.loadStatsFromXML;
local origSowingMachineLoad = SowingMachine.load;

SowingMachine.load = function (self, xmlFile)
	if origSowingMachineLoad ~= nil then
		origSowingMachineLoad(self, xmlFile);
	end;

	self.seeds = {};
	local i = 1;
    for k, fruitType in pairs(FruitUtil.fruitTypes) do
        if fruitType.allowsSeeding then
            self.seeds[i] = fruitType.index;
			i = i + 1;
        end;
    end;
end;

QuickPlayMenu.loadStatsFromXML = function(self, baseXMLName, savegame)
    origLoadStatsFromXML(self, baseXMLName, savegame);
    for i = 1, FruitUtil.NUM_FRUITTYPES do
        if savegame.stats.farmSiloFruitAmount[i] == 0 then
            savegame.stats.farmSiloFruitAmount[i] = 15000;
		end;
        if savegame.stats.fruitPrices[i] == nil then
            savegame.stats.fruitPrices[i] = FruitUtil.fruitIndexToDesc[i].pricePerLiter;
        end;
        if savegame.stats.yesterdaysFruitPrices[i] == nil then
            savegame.stats.yesterdaysFruitPrices[i] = FruitUtil.fruitIndexToDesc[i].yesterdaysPrice;
        end;
    end;
end;




