-- ##########################################################
-- #	showRPM												#
-- #														#
-- #	author: Webby										#
-- #	board: http://fieldstar.forumprofi.de				#
-- #	date: 09.07.2012									#
-- #	version: 1.0										#
-- #														#
-- #	THX 4 Help 2: modelleicher							#
-- #														#
-- #		   DO NOT COPY OR CHANGE THIS SCRIPT!			#
-- ##########################################################

showRPM = {};

function showRPM.prerequisitesPresent(specializations)
	print("RPM Hud Script v1 by Webby loaded!");
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function showRPM:load(xmlFile)
	self.ShowRPM = {};
	self.ShowRPMHudxPos = 0.005;
	self.ShowRPMHudyPos = 0.009;
	self.ShowRPMHudwidth = 0.160;
	self.ShowRPMHudheight = 0.044;
	self.ShowRPMHudOverlay = Overlay:new("RPMHUDOverlay", Utils.getFilename("model/Textura/rpmHud.png", self.baseDirectory), self.ShowRPMHudxPos, self.ShowRPMHudyPos, self.ShowRPMHudwidth, self.ShowRPMHudheight);
	
	self.RenderText = true;
end;

function showRPM:delete()
end;

function showRPM:mouseEvent(posX, posY, isDown, isUp, button)
end;

function showRPM:keyEvent(unicode, sym, modifier, isDown)
end;

function showRPM:update(dt)
	if self.isEntered then
		if self.motor.lastMotorRpm > 2000 then
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_LEFT);
			setTextColor(1, 0, 0, 1);
			renderText(self.ShowRPMHudxPos + 0.085, self.ShowRPMHudyPos + 0.013, 0.021, tostring(math.floor(self.motor.lastMotorRpm)));
		else
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_LEFT);
			setTextColor(0, 1, 0, 1);
			renderText(self.ShowRPMHudxPos + 0.085, self.ShowRPMHudyPos + 0.013, 0.021, tostring(math.floor(self.motor.lastMotorRpm)));
		end;
	end;
end;

function showRPM:draw()
	self.ShowRPMHudOverlay:render();
end;

function showRPM:onLeave()
	self.RenderText = false;
end;
