--
-- internalSound
-- Specialization for physically adapting Camera
--
-- @author  Knagsted
-- @date  3/04/10
--

-- Do not edit without my permission
--
internalSound = {};

function internalSound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function internalSound:load(xmlFile)
	self.intCameraIndex = 1;

	local motorStartSoundInternal = getXMLString(xmlFile, "vehicle.motorStartSoundInternal#file");
	if motorStartSoundInternal ~= nil and motorStartSoundInternal ~= "" then
        motorStartSoundInternal = Utils.getFilename(motorStartSoundInternal, self.baseDirectory);
        self.motorStartSoundInternal = createSample("motorStartSoundInternal");
        loadSample(self.motorStartSoundInternal, motorStartSoundInternal, false);
        self.motorStartSoundInternalPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStartSoundInternal#pitchOffset"), 0);
        self.motorStartSoundInternalVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStartSoundInternal#volume"), 1.0);
    end;

    local motorStopSoundInternal = getXMLString(xmlFile, "vehicle.motorStopSoundInternal#file");
    if motorStopSoundInternal ~= nil and motorStopSoundInternal ~= "" then
        motorStopSoundInternal = Utils.getFilename(motorStopSoundInternal, self.baseDirectory);
        self.motorStopSoundInternal = createSample("motorStopSoundInternal");
        loadSample(self.motorStopSoundInternal, motorStopSoundInternal, false);
        self.motorStopSoundInternalPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSoundInternal#pitchOffset"), 0);
        self.motorStopSoundInternalVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSoundInternal#volume"), 1.0);
    end;

    local motorSoundInternal = getXMLString(xmlFile, "vehicle.motorSoundInternal#file");
    if motorSoundInternal ~= nil and motorSoundInternal ~= "" then
        motorSoundInternal = Utils.getFilename(motorSoundInternal, self.baseDirectory);
        self.motorSoundInternal = createSample("motorSoundInternal");
        loadSample(self.motorSoundInternal, motorSoundInternal, false);
        self.motorSoundInternalPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchOffset"), 0);
        self.motorSoundInternalPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchScale"), 0.05);
        self.motorSoundInternalPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchMax"), 2.0);
        self.motorSoundInternalVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#volume"), 1.0);
    end;

    local motorSoundInternalRun = getXMLString(xmlFile, "vehicle.motorSoundInternalRun#file");
    if motorSoundInternalRun ~= nil and motorSoundInternalRun ~= "" then
        motorSoundInternalRun = Utils.getFilename(motorSoundInternalRun, self.baseDirectory);
        self.motorSoundInternalRun = createSample("motorSoundInternalRun");
        loadSample(self.motorSoundInternalRun, motorSoundInternalRun, false);
        self.motorSoundInternalRunPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchOffset"), 0);
        self.motorSoundInternalRunPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchScale"), 0.05);
        self.motorSoundInternalRunPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchMax"), 2.0);
        self.motorSoundInternalRunVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#volume"), 1.0);
    end;

    local powerCommandMotorSoundInternal = getXMLString(xmlFile, "vehicle.motorSoundInternal#file");
    if powerCommandMotorSoundInternal ~= nil and powerCommandMotorSoundInternal ~= "" then
        powerCommandMotorSoundInternal = Utils.getFilename(powerCommandMotorSoundInternal, self.baseDirectory);
        self.powerCommandMotorSoundInternal = createSample("powerCommandMotorSoundInternal");
        loadSample(self.powerCommandMotorSoundInternal, powerCommandMotorSoundInternal, false);
        self.powerCommandMotorSoundInternalPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchOffset"), 0);
        self.powerCommandMotorSoundInternalPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchScale"), 0.05);
        self.powerCommandMotorSoundInternalPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#pitchMax"), 2.0);
        self.powerCommandMotorSoundInternalVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternal#volume"), 1.0);
    end;

    local powerCommandMotorSoundInternalRun = getXMLString(xmlFile, "vehicle.motorSoundInternalRun#file");
    if powerCommandMotorSoundInternalRun ~= nil and powerCommandMotorSoundInternalRun ~= "" then
        powerCommandMotorSoundInternalRun = Utils.getFilename(powerCommandMotorSoundInternalRun, self.baseDirectory);
        self.powerCommandMotorSoundInternalRun = createSample("powerCommandMotorSoundInternalRun");
        loadSample(self.powerCommandMotorSoundInternalRun, powerCommandMotorSoundInternalRun, false);
        self.powerCommandMotorSoundInternalRunPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchOffset"), 0);
        self.powerCommandMotorSoundInternalRunPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchScale"), 0.05);
        self.powerCommandMotorSoundInternalRunPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#pitchMax"), 2.0);
        self.powerCommandMotorSoundInternalRunVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorSoundInternalRun#volume"), 1.0);
    end;

	self.originalMotorStartSound = self.motorStartSound;
	self.originalMotorStopSound = self.motorStopSoundNew;
	self.originalMotorSound = self.motorSound;
	self.originalMotorSoundRun = self.motorSoundRun;

	self.originalPowerCommandMotorSound = self.powerCommandMotorSound;
	self.originalPowerCommandMotorSoundRun = self.powerCommandMotorSoundRun;

	self.soundSwitched = true;
	self.motorStartHandled = false;


	self.powerCommandMotorSound = self.powerCommandMotorSoundInternal;
	self.powerCommandMotorSoundRun =self.powerCommandMotorSoundInternalRun;
	self.motorSound = self.motorSoundInternal;
	self.motorSoundRun =self.motorSoundInternalRun;
end;

function internalSound:delete()
end;

function internalSound:readStream(streamId, connection)
	self.motorStartHandled = streamReadBool(streamId);
end;

function internalSound:writeStream(streamId, connection)
	streamWriteBool(streamId, self.motorStartHandled);
end;

function internalSound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function internalSound:keyEvent(unicode, sym, modifier, isDown)
end;

function internalSound:update(dt)
	if InputBinding.hasEvent(InputBinding.CAMERA_SWITCH) and self.isEntered then
		self.soundSwitched = true;
	end;
	if self.playMotorSoundTime ~= nil and self.playMotorSoundTime <= self.time and not self.motorStartHandled then
		self.motorStartHandled = true;
		self.soundSwitched = true;
	end;

	if self.soundSwitched then
		if table.getn(self.wheels) > 0 then
			stopSample(self.motorSound);
			stopSample(self.motorSoundRun);
			--stopSample(self.motorStartSound);
			--stopSample(self.motorStopSound);
			stopSample(self.powerCommandMotorSound);
			stopSample(self.powerCommandMotorSoundRun);

			if self.camIndex == self.intCameraIndex then

				self.motorStartSound = self.motorStartSoundInternal;
				self.motorStopSoundNew = self.motorStopSoundInternal;
				self.powerCommandMotorSound = self.powerCommandMotorSoundInternal;
				self.powerCommandMotorSoundRun =self.powerCommandMotorSoundInternalRun;
			else
				self.motorStartSound = self.originalMotorStartSound;
				self.motorStopSoundNew = self.originalMotorStopSound;
				self.powerCommandMotorSound = self.originalPowerCommandMotorSound;
				self.powerCommandMotorSoundRun =self.originalPowerCommandMotorSoundRun;
			end;

			if self.isMotorStarted then
				--renderText(0.5, 0.5, 0.0250, string.format("about to play"));
				if self:getIsActiveForSound() then
					--renderText(0.5, 0.6, 0.0250, string.format("almost playing"));
					if self.powerCommandMotorSound ~= nil and self.playMotorSoundTime <= self.time then
						playSample(self.powerCommandMotorSound, 0, self.powerCommandMotorSoundVolume, 0);
						self.playPowerCommandMotorSound = false;

						if self.powerCommandMotorSoundRun ~= nil then
							playSample(self.powerCommandMotorSoundRun, 0, 0.0, 0);
						end;
						--renderText(0.5, 0.7, 0.0250, string.format("playing"));
					end;
				end;
			end;
		end;
		self.soundSwitched = false;
	end;
end;

function internalSound:onLeave()
	self.soundSwitched = true;
    Motorized.stopSounds(self);
end;

function internalSound:onEnter()
	self.soundSwitched = true;
end;

function internalSound:startMotor()
	--renderText(0.5, 0.1, 0.0250, string.format("start engine"));
	self.motorStartHandled = false;
end;

function internalSound:draw()
end;

