--
-- IHC 1455 XL
-- Spezialization um Hilfe ein- bzw. ausblenden zu knnen
-- 
--
-- Author  Friedrich L.  -  Skullman
-- Date 18. Dezember 2010
-- Web www.modding-society.de
--
-- Copyright (c) Friedrich L. - All Rights Reserved.
--

ShowHelp = {};

function ShowHelp.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ShowHelp:load(xmlFile)
	self.showHelp = false;
end;

function ShowHelp:delete()
end;

function ShowHelp:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ShowHelp:keyEvent(unicode, sym, modifier, isDown)
end;

function ShowHelp:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.TOGGLE_SHOW_HELP) then
			self.showHelp = not self.showHelp;
		end;
	end;
end;



function ShowHelp:updateTick(dt)
end;


function ShowHelp:draw()
	if not self.showHelp then
		renderText(0.77, 0.22, 0.02, "0: Turn HUD On");
	 else
		renderText(0.77, 0.22, 0.02, "0: Turn HUD Off");
		renderText(0.72, 0.81, 0.025, "-- New Holland T8 390 --");			
		renderText(0.72, 0.78, 0.02, "NP_Enter: Engine Start/Stop");
		renderText(0.72, 0.76, 0.02, "Home: Beacon On/Off");
		renderText(0.72, 0.74, 0.02, "0: Horn");			
		renderText(0.72, 0.72, 0.02, "5: Front Underhooks On/Off");
		renderText(0.72, 0.70, 0.02, "6: Front Weights On/Off")
		renderText(0.72, 0.68, 0.02, "7: Front Hydraulics Raise/Lower")
		renderText(0.72, 0.66, 0.02, "8: Wideload Flags On/Off")
		renderText(0.72, 0.64, 0.02, "9: Change Wheel Configurations");
		renderText(0.72, 0.62, 0.02, "NP_1: Left Turn Signal");
		renderText(0.72, 0.60, 0.02, "NP_2: Hazard Lights");
		renderText(0.72, 0.58, 0.02, "NP_3: Right Turn Signal");
    renderText(0.72, 0.56, 0.02, "NP_4: 4x4 On/Off");
    renderText(0.72, 0.54, 0.02, "NP_5: Front Working Lights");
    renderText(0.72, 0.52, 0.02, "NP_6: Rear Working Lights");
    renderText(0.72, 0.50, 0.02, "NP_7: Left Cab Door Open/Close");
    renderText(0.72, 0.48, 0.02, "NP_8: Rear Cab Window Open/Close");
    renderText(0.72, 0.46, 0.02, "Pg_Up/Pg_Down: Throttle up/down");
		renderText(0.72, 0.44, 0.02, "insert: Attacher Up");
		renderText(0.72, 0.42, 0.02, "delete: Attacher Down");
    renderText(0.72, 0.38, 0.02, "Edit by Farm Bozza");
	end;
end;

function ShowHelp:onLeave()
	self.showHelp = false;
end;




