NH = {};

function NH.prerequisitesPresent(specializations)
	return true;
end;

function NH:load(xmlFile)
	self.controlpath = Utils.getFilename("Texture/control.png", self.baseDirectory);
	self.hudclaasPoxX = 0.01;
	self.hudclaasPoxY = 1-0.204;
	self.hudclaasWidth = 0.240;
	self.hudclaasHeight = 0.240;
	self.hudclaasPoxX = 0.75;
	self.hudclaasPoxY = 0.60
	self.hudclaasOverlay = Overlay:new("hudcontrol", self.controlpath, self.hudclaasPoxX, self.hudclaasPoxY, self.hudclaasWidth, self.hudclaasHeight);

	turn1SoundFile = Utils.getFilename("Sounds/turn1.wav", self.baseDirectory);
	self.turn1 = createSample("turn1");
	loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("Sounds/turn2.wav", self.baseDirectory);
	self.turn2 = createSample("turn2");
	loadSample(self.turn2, turn2SoundFile, false);	
	
	self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
	self.turnlights = {};
	for i=1, self.numTurnlights do
		local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
		self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
		setVisibility(self.turnlights[i], false);
	end;	
	self.turnlightsActive = false;
	
	self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
	self.turnlights2 = {};
	for i=1, self.numTurnlights2 do
		local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
		self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
		setVisibility(self.turnlights2[i], false);
	end;	
	self.turnlightsActive2 = false;

	self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
	self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
	self.rundumleuchtenAn = false;
	self.rundumleuchten = {};
	for i=1, self.rundumleuchtenAnz do
		local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
		self.rundumleuchten[i] = {};
		self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
		self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
		self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
		self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
		self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
		if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
		   setVisibility(self.rundumleuchten[i].source, false);
		end;
	end;
	
	self.keys = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.keys.input(%d)", i);
		local inputName = getXMLString(xmlFile, baseName.. "#name");
		if inputName == nil then
			break;
		end;
		local inputKey = getXMLString(xmlFile, baseName.. "#key");
		if Input[inputKey] == nil then
			print("Error: invalid key '" .. inputKey .. "'	for input event '" .. inputName .. "'");
			break;
		end;
		self.keys[inputName] = Input[inputKey];
		i = i+1;
	end;	
end;

function NH:delete()
end;

function NH:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NH:keyEvent(unicode, sym, modifier, isDown)
	if InputBinding.isPressed(InputBinding.HUD) then -- isDown and sym == 48 then -- Key: 0
		self.bcActive = not self.bcActive;
	end;
	
	if InputBinding.isPressed(InputBinding.TURNRIGHT) then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.turnlightsActive2 = false;
		self.flashWarner = false;
	end;
	if InputBinding.isPressed(InputBinding.WARN) then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
	if InputBinding.isPressed(InputBinding.TURNLEFT) then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.turnlightsActive = false;
		self.flashWarner = false;
	end;
	if self.isEntered then
	  if self.rundumleuchtenKey ~= nil then
		 if isDown and sym == Input[self.rundumleuchtenKey] then
		   self.rundumleuchtenAn = not self.rundumleuchtenAn;
		   for i=1, self.rundumleuchtenAnz do
			 setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
		   end;
		 end;
	  end;
	end;
end;

function NH:update(dt)
		if self.flash then
			if self.delayOn >= 0 then
				self.delayOn = self.delayOn -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOn < 0 then
					self.delayOff = 500;
					self.flashlightsRightActive = true;
					self.flashlightsLeftActive = true;
					self.flashlightsWarnerActive = true;
					self.turnlightsActive2 = true;
					self.turnlightsActive = true;
					playSample(self.turn1, 1, 0.7, 0);
				end;
			end;
			if self.delayOff >= 0 then
				self.delayOff = self.delayOff -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOff < 0 then
					self.delayOn = 500;
					self.flashlightsLeftActive = false;
					self.flashlightsRightActive = false;
					self.flashlightsWarnerActive = false;
					self.turnlightsActive2 = false;
					self.turnlightsActive = false;
					playSample(self.turn2, 1, 0.7, 0);
				end;
			end;
		end;

		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.flashlightsRightActive = true;
					self.turnlightsActive2 = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffRight >= 0 then
			   self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.flashlightsRightActive = false;
					self.turnlightsActive2 = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive2 = false;
			end;
		end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;

		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
		if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
  if self.isEntered then
	if self.rundumleuchtenAnz > 0 then
	  if self.rundumleuchtenAn then
		for i=1, self.rundumleuchtenAnz do
		  rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
		end;
	  end;
	end;
  end;
end;

function NH:onLeave()
	self.rundumleuchtenAn = false;
	 for i=1, self.rundumleuchtenAnz do
	   setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
	  end;
end;

function NH:draw()
  if self.hudclaasOverlay ~= nil then
  if self.bcActive then
	self.hudclaasOverlay:render();
  end;
end;
		if self.bcActive then	
				g_currentMission:addHelpButtonText(g_i18n:getText("HUD_off"), InputBinding.HUD);
		else
				g_currentMission:addHelpButtonText(g_i18n:getText("HUD_on"), InputBinding.HUD);
		end;
end;