Klappen3 = {};

function Klappen3.prerequisitesPresent(specializations)
	return true;
end;

function Klappen3:load(xmlFile)

self.setRotateDirection4= SpecializationUtil.callSpecializationsFunction("setRotateDirection4");

local rotationPartNodeRotation4= Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Rotation4#index"));
	if rotationPartNodeRotation4 ~= nil then
		self.Rotation4 = {};
		self.Rotation4.node = rotationPartNodeRotation4;

		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Rotation4#minRot"));
		self.Rotation4.minRot = {};
		self.Rotation4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.Rotation4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.Rotation4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Rotation4#maxRot"));
		self.Rotation4.maxRot = {};
		self.Rotation4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.Rotation4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.Rotation4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

		self.Rotation4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Rotation4#rotTime"), 2)*1000;
	end;

  self.currentRotationDir4= false;
end;

function Klappen3:delete()
end;

function Klappen3:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Klappen3:keyEvent(unicode, sym, modifier, isDown)
	   if isDown and sym == Input.KEY_x then
			 self:setRotateDirection4(not self.currentRotationDir4);
	  end;
	  end;
function Klappen3:readStream(streamId, connection)
	 self:setRotateDirection4(streamReadBool(streamId), true);
end;

function Klappen3:writeStream(streamId, connection)
	streamWriteBool(streamId, self.currentRotationDir4);
end;

function Klappen3:update(dt)
end;


function Klappen3:updateTick(dt)
	if self.Rotation4 ~= nil then
		local x, y, z = getRotation(self.Rotation4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.Rotation4.maxRot, self.Rotation4.minRot, 3, self.Rotation4.rotTime, dt, not self.currentRotationDir4);
		setRotation(self.Rotation4.node, unpack(newRot));
   end;
end;

function Klappen3:setRotateDirection4(newDirection, noEventSend)
	RotationEvent3.sendEvent(self, newDirection, noEventSend);
	self.currentRotationDir4 = newDirection;
end;

function Klappen3:draw()
end; 