Klappen2 = {};

function Klappen2.prerequisitesPresent(specializations)
	return true;
end;

function Klappen2:load(xmlFile)

self.setRotateDirection2= SpecializationUtil.callSpecializationsFunction("setRotateDirection2");

local rotationPartNodeRotation2= Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Rotation2#index"));
	if rotationPartNodeRotation2 ~= nil then
		self.Rotation2 = {};
		self.Rotation2.node = rotationPartNodeRotation2;

		local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Rotation2#minRot"));
		self.Rotation2.minRot = {};
		self.Rotation2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.Rotation2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.Rotation2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

		x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Rotation2#maxRot"));
		self.Rotation2.maxRot = {};
		self.Rotation2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
		self.Rotation2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
		self.Rotation2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

		self.Rotation2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Rotation2#rotTime"), 2)*1000;
	end;

  self.currentRotationDir2= false;
end;

function Klappen2:delete()
end;

function Klappen2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Klappen2:keyEvent(unicode, sym, modifier, isDown)
	   if isDown and sym == Input.KEY_l then
			 self:setRotateDirection2(not self.currentRotationDir2);
	  end;
	  end;
function Klappen2:readStream(streamId, connection)
	 self:setRotateDirection2(streamReadBool(streamId), true);
end;

function Klappen2:writeStream(streamId, connection)
	streamWriteBool(streamId, self.currentRotationDir2);
end;

function Klappen2:update(dt)
end;

function Klappen2:updateTick(dt)
	if self.Rotation2 ~= nil then
		local x, y, z = getRotation(self.Rotation2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.Rotation2.maxRot, self.Rotation2.minRot, 3, self.Rotation2.rotTime, dt, not self.currentRotationDir2);
		setRotation(self.Rotation2.node, unpack(newRot));
   end;
end;

function Klappen2:setRotateDirection2(newDirection, noEventSend)
	RotationEvent2.sendEvent(self, newDirection, noEventSend);
	self.currentRotationDir2 = newDirection;
end;
function Klappen2:draw()
end;