--
-- Mercura
-- 
--
-- @poc@lypse
-- 

Mercura = {};

function Mercura.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;


function Mercura:load(xmlFile)
   
   self.rundumleuchtenAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.rundumleuchten#count"),0);
    self.rundumleuchtenKey = getXMLString(xmlFile, "vehicle.rundumleuchten#key");
    self.rundumleuchtenAn = false;
    self.rundumleuchten = {};
    for i=1, self.rundumleuchtenAnz do
        local objname = string.format("vehicle.rundumleuchten.light" .. "%d",i);
        self.rundumleuchten[i] = {};
        self.rundumleuchten[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.rundumleuchten[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.rundumleuchten[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.rundumleuchten[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.rundumleuchten[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.rundumleuchten[i].emit and self.rundumleuchten[i].source ~= nil then
           setVisibility(self.rundumleuchten[i].source, false);
        end;
    end;
      self.LightkeyLeft = getXMLString(xmlFile, "vehicle.Lights1L#key");
      self.numLights1L = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Lights1L#count"), 0);
    self.Lights1L = {};
    for i=1, self.numLights1L do
        local Light1Lnamei = string.format("vehicle.Lights1L.Light1L" .. "%d", i);
        self.Lights1L[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, Light1Lnamei .. "#index"));
        setVisibility(self.Lights1L[i], false);
    end;       
     self.numLights2L = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Lights2L#count"), 0);
    self.Lights2L = {};
    for i=1, self.numLights2L do
        local Light2Lnamei = string.format("vehicle.Lights2L.Light2L" .. "%d", i);
        self.Lights2L[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, Light2Lnamei .. "#index"));
        setVisibility(self.Lights2L[i], false);
    end;  
  
     self.LightkeyRight = getXMLString(xmlFile, "vehicle.Lights1R#key");
      self.numLights1R = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Lights1R#count"), 0);
    self.Lights1R = {};
    for i=1, self.numLights1R do
        local Light1Rnamei = string.format("vehicle.Lights1R.Light1R" .. "%d", i);
        self.Lights1R[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, Light1Rnamei .. "#index"));
        setVisibility(self.Lights1R[i], false);
    end;       
     self.numLights2R = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Lights2R#count"), 0);
    self.Lights2R = {};
    for i=1, self.numLights2R do
        local Light2Rnamei = string.format("vehicle.Lights2R.Light2R" .. "%d", i);
        self.Lights2R[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, Light2Rnamei .. "#index"));
        setVisibility(self.Lights2R[i], false);
    end;  

    self.Lights1LActive = false; 
    self.Lights2LActive = false;
    self.leftdelay = 0; 
    self.leftdelayOn = 0; 
    self.Lights1RGo = false;
    self.Lights1RActive = false; 
    self.Lights2RActive = false;
    self.rightdelay = 0; 
    self.rightdelayOn = 0; 
    self.Lights1RGo = false;
end;

function Mercura:delete()
  
end;

function Mercura:mouseEvent(posX, posY, isDown, isUp, button)
   
end;

function Mercura:keyEvent(unicode, sym, modifier, isDown)
  
    if self.rundumleuchtenKey ~= nil then
         if isDown and sym == Input[self.rundumleuchtenKey] then
           self.rundumleuchtenAn = not self.rundumleuchtenAn;
           for i=1, self.rundumleuchtenAnz do
             setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
           end;
         end;
      end;

    if isDown and sym == Input[self.LightkeyLeft] then
       self.Lights1LGo = not self.Lights1LGo;
       self.leftdelay = 1;      
     end;
    
     if isDown and sym == Input[self.LightkeyRight] then
       self.Lights1RGo = not self.Lights1RGo;
       self.rightdelay = 1;      
     end; 

end;

function Mercura:update(dt)
   
   if self.rundumleuchtenAnz > 0 then
      if self.rundumleuchtenAn then
        for i=1, self.rundumleuchtenAnz do
          rotate(self.rundumleuchten[i].rotNode, 0, dt*self.rundumleuchten[i].speed, 0);
        end;
      end;
    end;
    



   if self.Lights1LGo then   
         self.Lights1LActive = true;
           if self.leftdelay == 1 then 
            self.leftdelayOn = self.leftdelayOn + dt;
            self.leftdelay = 2;
           elseif self.leftdelay == 2 then
             self.leftdelay = 1;
           end;
          if self.leftdelayOn > 200 then           
                self.Lights1LActive = true;
                self.Lights2LActive = true;              
           end;
           if self.leftdelayOn > 400 then
                self.Lights1LActive = false;
                self.Lights2LActive = false; 
            end;
            if self.leftdelayOn > 600 then
                self.leftdelayOn = 0;
                self.Lights1LActive = true;
            end;
   else
              self.Lights1LActive = false;
              self.Lights2LActive = false;
              self.leftdelay = 0;             
   end;
                 
     if self.Lights1LActive then
		   for i=1, self.numLights1L do
			local Light1L = self.Lights1L[i];
			setVisibility(Light1L, self.Lights1LActive);
		   end;
	       else
		   for i=1, self.numLights1L do
			local Light1L = self.Lights1L[i];
			setVisibility(Light1L, self.Lights1LActive, false);
		   end;
	    end;
     
       if self.Lights2LActive then
		   for i=1, self.numLights2L do
			local Light2L = self.Lights2L[i];
			setVisibility(Light2L, self.Lights2LActive);
		   end;
	       else
		   for i=1, self.numLights2L do
			local Light2L = self.Lights2L[i];
			setVisibility(Light2L, self.Lights2LActive, false);
		   end;
	    end;

    if self.Lights1RGo then    
         self.Lights1RActive = true;
           if self.rightdelay == 1 then 
            self.rightdelayOn = self.rightdelayOn + dt;
            self.rightdelay = 2;
           elseif self.rightdelay == 2 then
             self.rightdelay = 1;
           end;
          if self.rightdelayOn > 200 then           
                self.Lights1RActive = true;
                self.Lights2RActive = true;              
           end;
           if self.rightdelayOn > 400 then
                self.Lights1RActive = false;
                self.Lights2RActive = false; 
            end;
            if self.rightdelayOn > 600 then
                self.rightdelayOn = 0;
                self.Lights1RActive = true;
            end;
   else
              self.Lights1RActive = false;
              self.Lights2RActive = false;
              self.rightdelay = 0;             
   end;

 if self.Lights1RActive then
		   for i=1, self.numLights1R do
			local Light1R = self.Lights1R[i];
			setVisibility(Light1R, self.Lights1RActive);
		   end;
	       else
		   for i=1, self.numLights1R do
			local Light1R = self.Lights1R[i];
			setVisibility(Light1R, self.Lights1RActive, false);
		   end;
	    end;
     
       if self.Lights2RActive then
		   for i=1, self.numLights2R do
			local Light2R = self.Lights2R[i];
			setVisibility(Light2R, self.Lights2RActive);
		   end;
	       else
		   for i=1, self.numLights2R do
			local Light2R = self.Lights2R[i];
			setVisibility(Light2R, self.Lights2RActive, false);
		   end;
	    end;


end;

function Mercura:draw()
 

     g_currentMission:addExtraPrintText("Touche X : Allumer/Eteindre Girophare");
     g_currentMission:addExtraPrintText("Touche B : Allumer/Eteindre Fleche gauche");
     g_currentMission:addExtraPrintText("Touche N : Allumer/Eteindre Fleche droite");
   
end;


function Mercura:onDetach()
	 self.rundumleuchtenAn = false;
    for i=1, self.rundumleuchtenAnz do
       setVisibility(self.rundumleuchten[i].light, self.rundumleuchtenAn);
    end;
   
    
end;

