--


FL = {};

function FL.prerequisitesPresent(specializations)
    Vehicle.registerJointType("frontloader");
	return true;
end;

function FL:load(xmlFile)
	local hydraulicsCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.hydraulics#count"), 0);	
	self.collisionJoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.components.joint#index"));	
	self.hydraulics2 = {};	
	for i=1, hydraulicsCount do
		local hydraulicName = string.format("vehicle.hydraulics.hydraulic%d", i);
		
		self.hydraulics2[i] = {};		
		self.hydraulics2[i].node = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#index"));
		self.hydraulics2[i].punch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punch"));
		self.hydraulics2[i].translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#punchFixpoint"));
		self.hydraulics2[i].fenderFixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, hydraulicName .. "#fixpoint"));
		if self.hydraulics2[i].punch ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulics2[i].punch);
			local bx, by, bz = getWorldTranslation(self.hydraulics2[i].translationPunch);		
			self.hydraulics2[i].punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);	
		end;
	end;
    local stuetzeNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontloader#index"));
    if stuetzeNode ~= nil then
        self.stuetze = {};
        self.stuetze.node = stuetzeNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.frontloader#minRot"));
        self.stuetze.minRot = {};
        self.stuetze.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.stuetze.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.stuetze.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.frontloader#maxRot"));
        self.stuetze.maxRot = {};
        self.stuetze.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.stuetze.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.stuetze.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.stuetze.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.frontloader#rotTime"), 2)*1000;
     end;

	 

end;

function FL:delete()
end;

function FL:mouseEvent(posX, posY, isDown, isUp, button)

end;

function FL:keyEvent(unicode, sym, modifier, isDown)

end;

function FL:update(dt)

	
	if self.attacherVehicle ~= nil then
	 if self.attacherVehicle.isEntered then
		--print("2");
		for i=1, table.getn(self.hydraulics2) do
			local ax, ay, az = getWorldTranslation(self.hydraulics2[i].node);
			local bx, by, bz = getWorldTranslation(self.hydraulics2[i].fenderFixPoint);
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulics2[i].node), bx-ax, by-ay, bz-az);
			
			setDirection(self.hydraulics2[i].node, x, y, z, 0, 1, 0);
			if self.hydraulics2[i].punch ~= nil then
				local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				setTranslation(self.hydraulics2[i].punch, 0, 0, distance-self.hydraulics2[i].punchDistance);
			end;	
		end;
	 end;
	
	
	end;
	if self.stuetze ~= nil then
        local x, y, z = getRotation(self.stuetze.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.stuetze.maxRot, self.stuetze.minRot, 3, self.stuetze.rotTime, dt, not self.down);
        setRotation(self.stuetze.node, unpack(newRot));
    end;


end;
function FL:draw()

end;
function FL:onLeave()
end;
function FL:onDetach()	
	self.down = false;
	setCenterOfMass(self.components[1].node, 0 ,0, 1.288);
	setCenterOfMass(self.components[2].node, 0, -0.204, 0.545);
	setTranslation(self.collisionJoint, 0, -0.435 , 2.001);	
	setRotation(self.collisionJoint, 0, 0, 0);
	setJointFrame(self.componentJoints[1].jointIndex, 0, self.collisionJoint);	
end;
function FL:onAttach(attacherVehicle)
	self.down = true;
	setCenterOfMass(self.components[1].node, 0, 0, 0);
	setCenterOfMass(self.components[2].node, 0, 0, 0);	
	setTranslation(self.collisionJoint, 0, -0.136 , 0.428);
	setRotation(self.collisionJoint, -5.693, 0, 0);
	setJointFrame(self.componentJoints[1].jointIndex, 0, self.collisionJoint);			
end;