--
-- Geringhoff8
-- 
--
-- @author  MySQly
-- @date  15/08/11
--
-- Copyright (C) MySQly, Confidential, All Rights Reserved.

Geringhoff8 = {};
source("dataS/scripts/vehicles/specializations/CutterAreaEvent.lua");
  
function Geringhoff8.prerequisitesPresent(specializations)
    return true;
end;
  
function Geringhoff8:load(xmlFile)
	self.reelSpeedOwn = 0.003;
	self.hederNisko = false;
	self.percentArea = 0;
	self.cutterIsOpening = false;
	self.cutterIsOpen = true;
	self.cutterOpenStage = 0;
	self.cutterOpenTimer = 0;
	self.rightSideOpen = true;
	self.rightSideDividerOpen = true;
	self.leftSideOpen = true;
	self.leftSideDividerOpen = true;
	self.vehicleAttacher = nil;
	self.cutterOpen = true;
	
	--AI Markers
    self.aiLeftMarkerLong1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index2"));
    self.aiRightMarkerLong1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker#index2"));
	
    self.aiLeftMarkerLong2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index3"));
    self.aiRightMarkerLong2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker#index3"));
	
    self.aiLeftMarkerLong3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiLeftMarker#index4"));
    self.aiRightMarkerLong3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiRightMarker#index4"));
	--AI Markers
	
	self.particleSystemsKukurydza = {};
    local particleSystemsKukurydzaCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.particleSystemsKukurydza#count"), 0);
    for i=1, particleSystemsKukurydzaCount do
        local namei = string.format("vehicle.particleSystemsKukurydza.part%d", i);
		local nodei = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, namei .. "#index"));
        Utils.loadParticleSystem(xmlFile, self.particleSystemsKukurydza, namei, nodei, false, nil, self.baseDirectory)			
    end;
	
    self.schneckeMitte = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot.path#schneckeMitte"));
	self.schneckeLinks = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot.path#schneckeLinks"));
	self.schneckeRechts = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rot.path#schneckeRechts"));	
	
	local rotationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight#index"));
    if rotationPartNodeRight ~= nil then
        self.rotationPartRight = {};
        self.rotationPartRight.node = rotationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartRight.minRot = {};
        self.rotationPartRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#maxRot"));
        self.rotationPartRight.maxRot = {};
        self.rotationPartRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#rotTime"), 2)*1000;
        self.rotationPartRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#touchRotLimit"), 10));
    end;  
	local rotationPartNodeRight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight2#index"));
    if rotationPartNodeRight2 ~= nil then
        self.rotationPartRight2 = {};
        self.rotationPartRight2.node = rotationPartNodeRight2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight2#minRot"));
        self.rotationPartRight2.minRot = {};
        self.rotationPartRight2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight2#maxRot"));
        self.rotationPartRight2.maxRot = {};
        self.rotationPartRight2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight2#rotTime"), 2)*1000;
        self.rotationPartRight2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight2#touchRotLimit"), 10));
    end;
	local rotationPartNodeRight3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight3#index"));
    if rotationPartNodeRight3 ~= nil then
        self.rotationPartRight3 = {};
        self.rotationPartRight3.node = rotationPartNodeRight3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight3#minRot"));
        self.rotationPartRight3.minRot = {};
        self.rotationPartRight3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight3#maxRot"));
        self.rotationPartRight3.maxRot = {};
        self.rotationPartRight3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight3#rotTime"), 2)*1000;
        self.rotationPartRight3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight3#touchRotLimit"), 10));
    end;
	local rotationPartNodeRight4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight4#index"));
    if rotationPartNodeRight4 ~= nil then
        self.rotationPartRight4 = {};
        self.rotationPartRight4.node = rotationPartNodeRight4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight4#minRot"));
        self.rotationPartRight4.minRot = {};
        self.rotationPartRight4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight4#maxRot"));
        self.rotationPartRight4.maxRot = {};
        self.rotationPartRight4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight4#rotTime"), 2)*1000;
        self.rotationPartRight4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight4#touchRotLimit"), 10));
    end;
	    
	
	local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;    
	local rotationPartNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft2#index"));
    if rotationPartNodeLeft2 ~= nil then
        self.rotationPartLeft2 = {};
        self.rotationPartLeft2.node = rotationPartNodeLeft2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#minRot"));
        self.rotationPartLeft2.minRot = {};
        self.rotationPartLeft2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft2#maxRot"));
        self.rotationPartLeft2.maxRot = {};
        self.rotationPartLeft2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#rotTime"), 2)*1000;
        self.rotationPartLeft2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft2#touchRotLimit"), 10));
    end;
	local rotationPartNodeLeft3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft3#index"));
    if rotationPartNodeLeft3 ~= nil then
        self.rotationPartLeft3 = {};
        self.rotationPartLeft3.node = rotationPartNodeLeft3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#minRot"));
        self.rotationPartLeft3.minRot = {};
        self.rotationPartLeft3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft3#maxRot"));
        self.rotationPartLeft3.maxRot = {};
        self.rotationPartLeft3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#rotTime"), 2)*1000;
        self.rotationPartLeft3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft3#touchRotLimit"), 10));
    end;
	local rotationPartNodeLeft4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft4#index"));
    if rotationPartNodeLeft4 ~= nil then
        self.rotationPartLeft4 = {};
        self.rotationPartLeft4.node = rotationPartNodeLeft4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft4#minRot"));
        self.rotationPartLeft4.minRot = {};
        self.rotationPartLeft4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft4#maxRot"));
        self.rotationPartLeft4.maxRot = {};
        self.rotationPartLeft4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft4#rotTime"), 2)*1000;
        self.rotationPartLeft4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft4#touchRotLimit"), 10));
    end;

	self.hydraulic = {};
	self.hydraulic.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic#indexHydraulic"));
	self.hydraulic.punch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic#indexPunch"));
	self.hydraulic.translationPunch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic#translationPunch"));
	local ax, ay, az = getWorldTranslation(self.hydraulic.punch);
    local bx, by, bz = getWorldTranslation(self.hydraulic.translationPunch);
    self.hydraulic.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	
	self.hydraulic2 = {};
	self.hydraulic2.node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic2#indexHydraulic"));
	self.hydraulic2.punch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic2#indexPunch"));
	self.hydraulic2.translationPunch = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic2#translationPunch"));
	local ax, ay, az = getWorldTranslation(self.hydraulic2.punch);
    local bx, by, bz = getWorldTranslation(self.hydraulic2.translationPunch);
    self.hydraulic2.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	
	self.hydraulicPoint = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic#hydraulicPoint"));
	self.hydraulicPoint2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.hydraulic2#hydraulicPoint2"));	

  
  
  --***************************************************************************************************************
    self.setReelSpeedScale = SpecializationUtil.callSpecializationsFunction("setReelSpeedScale");
    self.onStartReel = SpecializationUtil.callSpecializationsFunction("onStartReel");
    self.onStopReel = SpecializationUtil.callSpecializationsFunction("onStopReel");
    self.isReelStarted = Geringhoff8.isReelStarted;
    self.resetFruitType = SpecializationUtil.callSpecializationsFunction("resetFruitType");
    self.setFruitType = SpecializationUtil.callSpecializationsFunction("setFruitType");
    self.getInputFruitType = Geringhoff8.getInputFruitType;
 
    self.reelNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reel#index"));
    self.reelSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.reel#speed"), 0.003);
  
    self.reelSpeedScale = 1;
  
    self.rollNodes = {};
 
    local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index"));
    if rollNode ~= nil then
        local speed = 0.003*3;
        table.insert(self.rollNodes, {node=rollNode, speed=speed});
    end;
    local i = 0;
    while true do
        local key = string.format("vehicle.rolls.roll(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#speed"), 0.003);
        if rollNode ~= nil then
            table.insert(self.rollNodes, {node=rollNode, speed=speed});
        end;
        i = i + 1;
    end;
   
    local indexSpikesStr = getXMLString(xmlFile, "vehicle.reelspikes#index");
    self.spikesCount = getXMLInt(xmlFile, "vehicle.reelspikes#count");
    self.spikesRootNode = Utils.indexToObject(self.components, indexSpikesStr);
  
    self.sideArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sidearms#index"));
    self.sideArmMovable = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.sidearms#movable"), false);
 
    self.threshingParticleSystems = {};
    local psName = "vehicle.threshingParticleSystem";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems, psName, self.components, false, nil, self.baseDirectory)
  
    self.fruitExtraObjects = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.fruitExtraObjects.fruitExtraObject(%d)", i);
        local t = getXMLString(xmlFile, key.."#fruitType");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;
        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            if self.currentExtraObject == nil then
                self.currentExtraObject = node;
                setVisibility(node, true);
            else
                setVisibility(node, false);
            end;
            self.fruitExtraObjects[t] = node;
        end;
        i = i +1;
    end;
  
    self.threshingUVScrollParts = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.threshingUVScrollParts.threshingUVScrollPart(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
        if node ~= nil and speed then
            table.insert(self.threshingUVScrollParts, {node=node, speed=speed});
        end;
        i = i +1;
    end;
  
    self.preferedCombineSize = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.preferedCombineSize"), 1);
  
    self.fruitTypes = {};
    self.fruitTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
    local fruitTypes = getXMLString(xmlFile, "vehicle.fruitTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.fruitTypes[desc.index] = true;
            end;
        end;
    end;
  
    self.convertedFruits = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.convertedFruits.convertedFruit(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local inputType = getXMLString(xmlFile, key .. "#input");
        local outputType = getXMLString(xmlFile, key .. "#output");
  
        if inputType ~= nil and outputType ~= nil then
            local inputDesc = FruitUtil.fruitTypes[inputType];
            local outputDesc = FruitUtil.fruitTypes[outputType];
            if inputDesc ~= nil and outputDesc ~= nil then
                self.convertedFruits[inputDesc.index] = outputDesc.index;
            end;
        end;
  
        i = i + 1;
    end;
  
    self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.currentInputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
  
    self.reelStarted = false;
 
    self.forceLowSpeed = false;
    self.speedLimitLow = 12;
    self.speedLimit = 17.5;
 
    self.speedViolationMaxTime = 50;
    self.speedViolationTimer = self.speedViolationMaxTime;
    self.printRainWarning = false;
  
    self.lastArea = 0;
    self.lastAreaBiggerZero = self.lastArea > 0;
 
    self.cutterGroundFlag = self:getNextDirtyFlag();
  
end;
  
function Geringhoff8:delete()
    Utils.deleteParticleSystem(self.threshingParticleSystems);
end;
  
function Geringhoff8:readStream(streamId, timestamp, connection)
    self.lastAreaBiggerZero = streamReadBool(streamId);
end;
  
function Geringhoff8:writeStream(streamId, connection, dirtyMask)
    streamWriteBool(streamId, self.lastAreaBiggerZero);
end;
  
function Geringhoff8:readUpdateStream(streamId, timestamp, connection)
    if connection:getIsServer() then
        self.lastAreaBiggerZero = streamReadBool(streamId);
    end;
end;
  
function Geringhoff8:writeUpdateStream(streamId, connection, dirtyMask)
    if not connection:getIsServer() then
        streamWriteBool(streamId, self.lastAreaBiggerZero);
    end;
end;
  
function Geringhoff8:mouseEvent(posX, posY, isDown, isUp, button)
end;
  
function Geringhoff8:keyEvent(unicode, sym, modifier, isDown)
    if isDown and sym == Input.KEY_KP_5 then
		if not self.cutterIsOpening then
			self.cutterOpen = not self.cutterOpen;
			self.cutterIsOpening = true;
			self.cutterOpenStage = 1;
			if self.cutterOpen then
				self.cutterOpenTimer = 6000;
				self.leftSideOpen = true;
			else
				self.cutterOpenTimer = 3000;
				self.rightSideDividerOpen = false;
			end;
		else
			self.attacherVehicle.cutterOpeningWarning = true;
		end;
		self.vehicleAttacher.cutterOpened = (self.cutterOpen and not self.cutterIsOpening);
	end;
end;
  
function Geringhoff8:update(dt)
  
	if self.cutterIsOpening then
		self.cutterOpenTimer = self.cutterOpenTimer - dt;
		if self.cutterOpenTimer < 0 then
			if self.cutterOpen then
				if self.cutterOpenStage == 1 then
					self.cutterOpenTimer = 3000;
					self.leftSideDividerOpen = true;
					self.cutterOpenStage = 2;
				elseif self.cutterOpenStage == 2 then
					self.cutterOpenTimer = 6000;
					self.rightSideOpen = true;
					self.cutterOpenStage = 3;
				elseif self.cutterOpenStage == 3 then
					self.cutterOpenTimer = 3000;
					self.rightSideDividerOpen = true;
					self.cutterOpenStage = 4;
				elseif self.cutterOpenStage == 4 then
					self.cutterOpenStage = 0;
					self.cutterIsOpening = false;
				end;
			else
				if self.cutterOpenStage == 1 then
					self.cutterOpenTimer = 6000;
					self.rightSideOpen = false;
					self.cutterOpenStage = 2;
				elseif self.cutterOpenStage == 2 then
					self.cutterOpenTimer = 3000;
					self.leftSideDividerOpen = false;
					self.cutterOpenStage = 3;
				elseif self.cutterOpenStage == 3 then
					self.cutterOpenTimer = 6000;
					self.leftSideOpen = false;
					self.cutterOpenStage = 4;
				elseif self.cutterOpenStage == 4 then
					self.cutterOpenStage = 0;
					self.cutterIsOpening = false;
				end;
			end;
		end;
		self.vehicleAttacher.cutterOpened = (self.cutterOpen and not self.cutterIsOpening);
	end;
  
    if self.attacherVehicle ~= nil and self.attacherVehicle.deactivateCutter then
        Geringhoff8.onDeactivate(self);
		self.attacherVehicle.deactivateCutter = false;
    end;
	self.percentArea = 0;
	if self.attacherVehicle ~= nil then
		self.hederNisko = self.attacherVehicle.cutterLowPosition;
	end;
	

	
	--*************************************************************************************
  
    Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastAreaBiggerZero));
	Utils.setEmittingState(self.particleSystemsSloma, (self.reelStarted and self.lastAreaBiggerZero));
  
    Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastArea > 0.0));
	Utils.setEmittingState(self.particleSystemsKukurydza, (self.reelStarted and self.lastArea > 0.0));
	
	if self.reelStarted then
	    rotate(self.schneckeMitte, dt*self.reelSpeedOwn*6, 0, 0);
	    rotate(self.schneckeLinks, dt*self.reelSpeedOwn*6, 0, 0);
	    rotate(self.schneckeRechts, dt*self.reelSpeedOwn*6, 0, 0);
	end;
	
	--^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^RIGHT^^^^^^^^^^^^^^^^^^^^^SIDE^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	if self.rotationPartRight ~= nil then
        local x, y, z = getRotation(self.rotationPartRight.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight.maxRot, self.rotationPartRight.minRot, 3, self.rotationPartRight.rotTime, dt, self.rightSideOpen);
        setRotation(self.rotationPartRight.node, unpack(newRot));
    end;
	if self.rotationPartRight2 ~= nil then
        local x, y, z = getRotation(self.rotationPartRight2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight2.maxRot, self.rotationPartRight2.minRot, 3, self.rotationPartRight2.rotTime, dt, self.rightSideDividerOpen);
        setRotation(self.rotationPartRight2.node, unpack(newRot));
    end;
	if self.rotationPartRight3 ~= nil then
        local x, y, z = getRotation(self.rotationPartRight3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight3.maxRot, self.rotationPartRight3.minRot, 3, self.rotationPartRight3.rotTime, dt, self.rightSideOpen);
        setRotation(self.rotationPartRight3.node, unpack(newRot));
    end;
    if self.rotationPartRight4 ~= nil then
        local x, y, z = getRotation(self.rotationPartRight4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight4.maxRot, self.rotationPartRight4.minRot, 3, self.rotationPartRight4.rotTime, dt, self.rightSideOpen);
        setRotation(self.rotationPartRight4.node, unpack(newRot));
    end;
	
	--^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^LEFT^^^^^^^^^^^^^^^^^^^^^SIDE^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
    
    if self.rotationPartLeft ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, self.leftSideOpen);
        setRotation(self.rotationPartLeft.node, unpack(newRot));
    end;
    if self.rotationPartLeft2 ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft2.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft2.maxRot, self.rotationPartLeft2.minRot, 3, self.rotationPartLeft2.rotTime, dt, self.leftSideDividerOpen);
        setRotation(self.rotationPartLeft2.node, unpack(newRot));
    end;    
	if self.rotationPartLeft3 ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft3.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft3.maxRot, self.rotationPartLeft3.minRot, 3, self.rotationPartLeft3.rotTime, dt, self.leftSideOpen);
        setRotation(self.rotationPartLeft3.node, unpack(newRot));
    end;
	if self.rotationPartLeft4 ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft4.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft4.maxRot, self.rotationPartLeft4.minRot, 3, self.rotationPartLeft4.rotTime, dt, self.leftSideOpen);
        setRotation(self.rotationPartLeft4.node, unpack(newRot));
    end;
	
	--^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^HYDRAULIC^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	if self.hydraulic ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic.punch, 0, 0, (distance-self.hydraulic.punchDistance)*-1);
		end;
	end;
	
	if self.hydraulic2 ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic2.node);
		local bx, by, bz = getWorldTranslation(self.hydraulicPoint2);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic2.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic2.node, x*-1, y*-1, z*-1, 0, 1, 0);
		if self.hydraulic2.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic2.punch, 0, 0, (distance-self.hydraulic2.punchDistance)*-1);
		end;
	end;	
end;
  
function Geringhoff8:updateTick(dt)
    if self.isServer then
        self.lastArea = 0;
        self.printRainWarning = false;
    end;
    if self.reelStarted and self.movingDirection < 0 then
        local speedLimit = self.speedLimit;
        if Geringhoff8.getUseLowSpeedLimit(self) then
            speedLimit = self.speedLimitLow;
        end;
  
        if self:doCheckSpeedLimit() and self.lastSpeed*3600 > speedLimit then
            self.speedViolationTimer = self.speedViolationTimer - dt;
        else
            self.speedViolationTimer = self.speedViolationMaxTime;
        end;
        if self.isServer then
  
            if self.speedViolationTimer > 0 then
                local isAllowed = true;
                if self.attacherVehicle ~= nil then
                    isAllowed = self.attacherVehicle:getIshreshingAllowed(false);
                end;
                if isAllowed then
                    -- during low fill level new fruit types are allowed to "take over"
                    local lowFillLevel = false;
                    if self.attacherVehicle ~= nil then
                        if self.attacherVehicle.grainTankFillLevel == 0 or self.attacherVehicle.grainTankFillLevel / self.attacherVehicle.grainTankCapacity <= self.attacherVehicle.minThreshold then
                            lowFillLevel = true;
                        end;
                    end;
  
                    local foundFruitType = false;
                    local oldFruitType = self.currentFruitType;
                    local oldInputFruitType = self.currentInputFruitType;
 
                    local allowsThreshing = true;
                    if self.attacherVehicle ~= nil then
                        allowsThreshing = self.attacherVehicle.allowsThreshing;
                    end;
  
                    if allowsThreshing then
                        if self.currentFruitType == FruitUtil.FRUITTYPE_UNKNOWN or lowFillLevel then
                            for fruitType,v in pairs(self.fruitTypes) do
                                local outputFruitType = fruitType;
                                if self.convertedFruits[fruitType] ~= nil then
                                    outputFruitType = self.convertedFruits[fruitType];
                                end;
  
                                local isOk = true;
                                if self.attacherVehicle ~= nil then
                                    if self.attacherVehicle.allowGrainTankFruitType ~= nil then
                                        isOk = self.attacherVehicle:allowGrainTankFruitType(outputFruitType);
                                    end;
                                end;
                                if isOk then
                                    for k,area in pairs(self.cuttingAreas) do
                                        local x,y,z = getWorldTranslation(area.start);
                                        local x1,y1,z1 = getWorldTranslation(area.width);
                                        local x2,y2,z2 = getWorldTranslation(area.height);
                                        local area = Utils.getFruitArea(fruitType, x, z, x1, z1, x2, z2);
                                        if area > 0 then
                                            self.currentFruitType = outputFruitType;
                                            self.currentInputFruitType = fruitType;
                                            if self.currentInputFruitType ~= oldInputFruitType then
                                                Geringhoff8.updateExtraObjects(self)
                                                if self.attacherVehicle ~= nil then
                                                    self.attacherVehicle:emptyGrainTankIfLowFillLevel();
                                                end;
                                            end;
                                            foundFruitType = true;
                                            break;
                                        end;
                                    end;
  
                                    if foundFruitType then
                                        break;
                                    end;
                                end;
                            end;
                        end;
                        if self.currentFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
 
                            --local realArea = 0;
                            local cuttingAreasSend = {};
                            for k,area in pairs(self.cuttingAreas) do
                                if self:getIsAreaActive(area) then
                                    local x,y,z = getWorldTranslation(area.start);
                                    local x1,y1,z1 = getWorldTranslation(area.width);
                                    local x2,y2,z2 = getWorldTranslation(area.height);
                                    table.insert(cuttingAreasSend, {x,z,x1,z1,x2,z2});
                                end;
                            end;
                            if (table.getn(cuttingAreasSend) > 0) then
                                local lastArea, realArea = CutterAreaEvent.runLocally(cuttingAreasSend, self.currentInputFruitType);
                                self.lastArea = lastArea;
                                self.lastAreaBiggerZero = (self.lastArea > 0);
                                if self.lastArea > 0 then
                                    g_server:broadcastEvent(CutterAreaEvent:new(cuttingAreasSend, self.currentInputFruitType));
                                end;
                                if self.lastAreaBiggerZero ~= self.lastAreaBiggerZeroSent then
                                    self:raiseDirtyFlags(self.cutterGroundFlag);
                                    self.lastAreaBiggerZeroSent = self.lastAreaBiggerZero;
                                end;
                                local pixelToSqm = g_currentMission:getFruitPixelsToSqm(); -- 4096px are mapped to 2048m
                                local sqm = realArea*pixelToSqm;
                                local ha = sqm/10000;
								
								self.percentArea = realArea;
								
                                g_currentMission.missionStats.hectaresThreshedTotal = g_currentMission.missionStats.hectaresThreshedTotal + ha;
                                g_currentMission.missionStats.hectaresThreshedSession = g_currentMission.missionStats.hectaresThreshedSession + ha;
                            end;
  
                            g_currentMission.missionStats.threshingDurationTotal = g_currentMission.missionStats.threshingDurationTotal + dt/(1000*60);
                            g_currentMission.missionStats.threshingDurationSession= g_currentMission.missionStats.threshingDurationSession + dt/(1000*60);
                        end;
                    end;
                else
                    self.printRainWarning = true;
                end;
            end;
        end;
    else
        self.speedViolationTimer = self.speedViolationMaxTime;
    end;
end;
  
function Geringhoff8:draw()
	if self.cutterOpen then
		g_currentMission:addExtraPrintText("KEY KP 5    -    Close header");
	else
		g_currentMission:addExtraPrintText("KEY KP 5    -    Open header");
	end;
end;

function Geringhoff8:onAttach()
	if self.attacherVehicle.heder then
		self.rotationMaxRozdzielacz2 = true;
		self.rotationMaxRozdzielacz1 = true;	
		self.rotationMaxKardana = true;	
		setVisibility(self.hydraulicPartTransport, false);
		setVisibility(self.hydraulicPartWork, true);
	end;
	self.hederNisko = false;
	self.vehicleAttacher = self.attacherVehicle;
	self.vehicleAttacher.cutterName = "geringhoff8";
	self.vehicleAttacher.cutterOpened = true;
	self.vehicleAttacher.changeAttacherMaxRotation = true;
end;

function Geringhoff8:onDetach()
    if self.deactivateOnDetach then
        Geringhoff8.onDeactivate(self);
    end;
	self.rotationMaxRozdzielacz2 = false;
	self.rotationMaxRozdzielacz1 = false;
	self.rotationMaxKardana = false;
	setVisibility(self.hydraulicPartTransport, true);
	setVisibility(self.hydraulicPartWork, false);
	self.hederNisko = false;
	self.vehicleAttacher.cutterName = "nil";
end;
  
function Geringhoff8:onLeave()
    if self.deactivateOnLeave then
        Geringhoff8.onDeactivate(self);
    end;
end;
  
function Geringhoff8:onDeactivate()
    self:onStopReel();
    Utils.setEmittingState(self.threshingParticleSystems, false);
    self.speedViolationTimer = self.speedViolationMaxTime;
end;
  
function Geringhoff8:setReelSpeedSpace(speedScale)
    self.reelSpeedScale = speedScale;
end;
  
function Geringhoff8:onStartReel()
    self.reelStarted = true;
  
    for _, part in pairs(self.threshingUVScrollParts) do
        setShaderParameter(part.node, "uvScrollSpeed", part.speed[1], part.speed[2], 0, 0, false);
    end;
end;
  
function Geringhoff8:onStopReel()
    self.reelStarted = false;
    Utils.setEmittingState(self.threshingParticleSystems, false);
    self.speedViolationTimer = self.speedViolationMaxTime;
  
    for _, part in pairs(self.threshingUVScrollParts) do
        setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
    end;
end;
  
function Geringhoff8:isReelStarted()
    return self.reelStarted;
end;
  
function Geringhoff8:resetFruitType()
    self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.currentInputFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.lastArea = 0;
end;
 
function Geringhoff8:setFruitType(fruitType)
    if self.currentInputFruitType ~= fruitType then
        self.currentInputFruitType = fruitType;
        self.currentFruitType = fruitType;
        if self.convertedFruits[fruitType] ~= nil then
            self.currentFruitType = self.convertedFruits[fruitType];
        end;
        self.lastArea = 0;
 
        Geringhoff8.updateExtraObjects(self)
    end;
end;
  
function Geringhoff8.getUseLowSpeedLimit(self)
    if self.forceLowSpeed or (self.attacherVehicle ~= nil and self.preferedCombineSize > self.attacherVehicle.combineSize) then
        return true;
    end;
    return false;
end;
  
function Geringhoff8.updateExtraObjects(self)
    if self.currentExtraObject ~= nil then
        setVisibility(self.currentExtraObject, false);
        self.currentExtraObject = nil;
    end;
    if self.currentInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local name = FruitUtil.fruitIndexToDesc[self.currentInputFruitType].name;
        local extraObject = self.fruitExtraObjects[name];
        if extraObject ~= nil then
            setVisibility(extraObject, true);
            self.currentExtraObject = extraObject;
        end;
    end;
end;
  
-- Deprecated, use Combine.getIshreshingAllowed
function Geringhoff8.allowThreshing(earlyWarning)
    if earlyWarning ~= nil and earlyWarning == true then
        if g_currentMission.environment.lastRainScale <= 0.02 and g_currentMission.environment.timeSinceLastRain > 20 then
            return true;
        end;
    else
        if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 20 then
            return true;
        end;
    end;
    return false;
end;