--
-- NHTM190
-- Specialization for NHTM190 mod
--
-- @author  JoXXer
-- @date  29/08/11
--

NHTM190 = {};

function NHTM190.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function NHTM190:load(xmlFile)

	self.RPMDigits = SpecializationUtil.callSpecializationsFunction("RPMDigits");
	self.updateFuelIndicators = SpecializationUtil.callSpecializationsFunction("updateFuelIndicators");
	self.change4wdState = SpecializationUtil.callSpecializationsFunction("change4wdState");

	-- Beaconlight bases
	self.beaconLightBase1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.beaconLightBase1#index"));
	self.beaconLightBase2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.beaconLightBase2#index"));
	-- Beaconlight switch corona
	self.beaconSwitchLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.beaconSwitchLight#index"));
	-- Rear trailer-pins
	self.trailerPinLow = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#backLow"));
	self.trailerPinHigh = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerAttacherJoints#backHigh"));
	-- Linkage balls
	self.rearLinkageBall1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearLinkageBalls.linkageBall1#index"));
	self.rearLinkageBall2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearLinkageBalls.linkageBall2#index"));

	-- Moving parts
	-- Switches
	self.numSwitches = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.switches#count"),0);
	self.switch = {};
	for i=1, self.numSwitches do
		local objname = string.format("vehicle.switches.switch" .. "%d", i);
		self.switch[i] = {};
		self.switch[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
	end;

	-- Levers

	self.shuttleLever = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.shuttleLever#index"));
	self.indicatorsLever = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.indicatorsLever#index"));
	self.wiperLever = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiperLever#index"));

	-- PTO
	self.PTOKnob = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PTOKnob#index"));
	self.PTOOnLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PTOOnLight#index"));

	-- Dashboard indicators
	self.dashboardFuel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardFuel#index"));
	self.dashboard4WD = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboard4WD#index"));
	self.dashboardParkingBrake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardParkingBrake#index"));
	self.dashboardSlow = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardSlow#index"));
	self.dashboardFast = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardFast#index"));
	self.dashboardBattery = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardBattery#index"));
	self.dashboardEngineThing1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardEngineThing1#index"));
	self.dashboardEngineThing2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.dashboardEngineThing2#index"));
	self.blankDisplays = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blankDisplays#index"));

	-- Front axle animation
	self.frontAxle = {};
	self.frontAxle.rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontAxle#rotNode"));

	-- Seat animation
	self.seatNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.seatNode#index"));

	if self.seatNode ~=nil then
		local x,y,z = getTranslation(self.seatNode);
		self.startSeatXTranslation = x;
		self.startSeatYTranslation = y;
		self.startSeatZTranslation = z;
	end;

	if self.wheels[3].repr ~= nil and self.wheels[4].repr ~= nil then
		local x,y,z = getTranslation(self.wheels[3].repr);
		local x2,y2,z2 = getTranslation(self.wheels[4].repr);

		self.averageYTranslation = (y + y2)/2;
	end;

	self.maxTranslationPrCycle = 0.00008;
	self.seatTranslation = self.averageYTranslation;

	-- Animated wheels
	self.numAnimatedWheels = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.animatedWheels#count"), 0);
	self.animatedWheel = {};
    for i=1, self.numAnimatedWheels do
        local objname = string.format("vehicle.animatedWheels.wheel" .. "%d", i);
		self.animatedWheel[i] = {};
        self.animatedWheel[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		self.animatedWheel[i].wheel = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#wheelIndex"));
		self.animatedWheel[i].fenderAttach = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#fenderAttach"));
    end;

	-- Rear attacher animation
	self.rearAttacherJoint = {};
	self.rearAttacherJoint.armPullerRearNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearAttacherJoint#armPullerRearIndex"));
	self.rearAttacherJoint.orientNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.rearAttacherJoint#orientIndex"));

	-- Front wiper animation
	local wiperFrontAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiperFront#rootNode"));
    self.wiperFrontAnimCharSet = 0;
    if wiperFrontAnimRootNode ~= nil and wiperFrontAnimRootNode ~= 0 then
        self.wiperFrontAnimCharSet = getAnimCharacterSet(wiperFrontAnimRootNode);
        if self.wiperFrontAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperFrontAnimCharSet, getXMLString(xmlFile, "vehicle.wiperFront#clip"));
            assignAnimTrackClip(self.wiperFrontAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperFrontAnimCharSet, 0, true);
            local wiperFrontAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiperFront#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperFrontAnimCharSet, 0, wiperFrontAnimSpeedScale);
            self.wiperFrontAnimDuration = getAnimClipDuration(self.wiperFrontAnimCharSet, clip);
        end;
    end;

	self.isWiperFrontActive = false;
	self.finishWiperFront = true;

	-- Rear wiper animation
	local wiperBackAnimRootNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wiperBack#rootNode"));
    self.wiperBackAnimCharSet = 0;
    if wiperBackAnimRootNode ~= nil and wiperBackAnimRootNode ~= 0 then
        self.wiperBackAnimCharSet = getAnimCharacterSet(wiperBackAnimRootNode);
        if self.wiperBackAnimCharSet ~= 0 then
            local clip = getAnimClipIndex(self.wiperBackAnimCharSet, getXMLString(xmlFile, "vehicle.wiperBack#clip"));
            assignAnimTrackClip(self.wiperBackAnimCharSet, 0, clip);
            setAnimTrackLoopState(self.wiperBackAnimCharSet, 0, true);
            local wiperBackAnimSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wiperBack#speedScale"), 1);
			setAnimTrackSpeedScale(self.wiperBackAnimCharSet, 0, wiperBackAnimSpeedScale);
            self.wiperBackAnimDuration = getAnimClipDuration(self.wiperBackAnimCharSet, clip);
        end;
    end;
	self.isWiperBackActive = false;
	self.finishWiperBack = true;
	self.wiperFrontOn = false;
	self.wiperBackOn = false;

	self.digitRPMs = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.digitRPMs#index"));
	self.digitRPMsLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.digitRPMsLight#index"));
	setVisibility(self.digitRPMs,true);
	setVisibility(self.digitRPMsLight,false);

	-- Fuel indicators
	self.fuelIndicatorsGroup = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fuelIndicators#index"));

	self.numFuelIndicators = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.fuelIndicators#count"), 0);
	self.fuelIndicators = {};
    for i=1, self.numFuelIndicators do
        local objname = string.format("vehicle.fuelIndicators.fuelIndicator" .. "%d", i);
		self.fuelIndicators[i] = {};
        self.fuelIndicators[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.fuelIndicators[i].rotNode,true);
    end;
	--Fuel indicators light
	self.fuelIndicatorsLightGroup = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.fuelIndicatorsLight#index"));

	self.numFuelIndicatorsLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.fuelIndicatorsLight#count"), 0);
	self.fuelIndicatorsLight = {};
    for i=1, self.numFuelIndicatorsLight do
        local objname = string.format("vehicle.fuelIndicatorsLight.fuelIndicator" .. "%d", i);
		self.fuelIndicatorsLight[i] = {};
        self.fuelIndicatorsLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.fuelIndicatorsLight[i].rotNode,true);
    end;
	setVisibility(self.fuelIndicatorsLightGroup, false);

	-- Digital Display digits RPM
	self.numDigitRPMOne = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMOne#count"), 0);
	self.digitRPMOne = {};
    for i=1, self.numDigitRPMOne do
        local objname = string.format("vehicle.displayDigitRPMOne.digitRPM" .. "%d", i);
		self.digitRPMOne[i] = {};
        self.digitRPMOne[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMOne[i].rotNode,false);
    end;
	setVisibility(self.digitRPMOne[self.numDigitRPMOne].rotNode,true);

	self.numDigitRPMTwo = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMTwo#count"), 0);
	self.digitRPMTwo = {};
    for i=1, self.numDigitRPMTwo do
        local objname = string.format("vehicle.displayDigitRPMTwo.digitRPM" .. "%d", i);
		self.digitRPMTwo[i] = {};
        self.digitRPMTwo[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMTwo[i].rotNode,false);
    end;
	setVisibility(self.digitRPMTwo[self.numDigitRPMTwo].rotNode,true);

	self.numDigitRPMThree = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMThree#count"), 0);
	self.digitRPMThree = {};
    for i=1, self.numDigitRPMThree do
        local objname = string.format("vehicle.displayDigitRPMThree.digitRPM" .. "%d", i);
		self.digitRPMThree[i] = {};
        self.digitRPMThree[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMThree[i].rotNode,false);
    end;
	setVisibility(self.digitRPMThree[self.numDigitRPMThree].rotNode,true);

	self.numDigitRPMFour = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMFour#count"), 0);
	self.digitRPMFour = {};
    for i=1, self.numDigitRPMFour do
        local objname = string.format("vehicle.displayDigitRPMFour.digitRPM" .. "%d", i);
		self.digitRPMFour[i] = {};
        self.digitRPMFour[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMFour[i].rotNode,false);
    end;
	setVisibility(self.digitRPMFour[self.numDigitRPMFour].rotNode,true);

	-- Digital display ligth on
	-- Digital Display digits RPM
	self.numDigitRPMOneLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMOneLight#count"), 0);
	self.digitRPMOneLight = {};
    for i=1, self.numDigitRPMOneLight do
        local objname = string.format("vehicle.displayDigitRPMOneLight.digitRPM" .. "%d", i);
		self.digitRPMOneLight[i] = {};
        self.digitRPMOneLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMOneLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMOneLight[self.numDigitRPMOneLight].rotNode,true);

	self.numDigitRPMTwoLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMTwoLight#count"), 0);
	self.digitRPMTwoLight = {};
    for i=1, self.numDigitRPMTwoLight do
        local objname = string.format("vehicle.displayDigitRPMTwoLight.digitRPM" .. "%d", i);
		self.digitRPMTwoLight[i] = {};
        self.digitRPMTwoLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMTwoLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMTwoLight[self.numDigitRPMTwoLight].rotNode,true);

	self.numDigitRPMThreeLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMThreeLight#count"), 0);
	self.digitRPMThreeLight = {};
    for i=1, self.numDigitRPMThreeLight do
        local objname = string.format("vehicle.displayDigitRPMThreeLight.digitRPM" .. "%d", i);
		self.digitRPMThreeLight[i] = {};
        self.digitRPMThreeLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMThreeLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMThreeLight[self.numDigitRPMThreeLight].rotNode,true);

	self.numDigitRPMFourLight = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.displayDigitRPMFourLight#count"), 0);
	self.digitRPMFourLight = {};
    for i=1, self.numDigitRPMFourLight do
        local objname = string.format("vehicle.displayDigitRPMFourLight.digitRPM" .. "%d", i);
		self.digitRPMFourLight[i] = {};
        self.digitRPMFourLight[i].rotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#rotNode"));
		setVisibility(self.digitRPMFourLight[i].rotNode,false);
    end;
	setVisibility(self.digitRPMFourLight[self.numDigitRPMFourLight].rotNode,true);

	-- RPM display
	self.displayValue = 0;
	self.prevousDigitRPMFour = self.numDigitRPMFour;
	self.prevousDigitRPMThree = self.numDigitRPMThree;
	self.prevousDigitRPMTwo = self.numDigitRPMTwo;
	self.prevousDigitRPMOne = 0;

	self.cycleRoundMax = 30;
	self.currentCycle = 0;
	self.lastRpm = 0;

	NHTM190.hasPowerCommand = true;

	self.showSpeed = false;

	self.implementCount = 0;

	-- Boolean to control 4WD
	self.is4wdActive = true;
end;

function NHTM190:delete()
end;

function NHTM190:readStream(streamId, connection)
	self.showSpeed = streamReadBool(streamId);
	self.is4wdActive = streamReadBool(streamId);
end;

function NHTM190:writeStream(streamId, connection)
	streamWriteBool(streamId, self.showSpeed);
	streamWriteBool(streamId, self.is4wdActive);
end;

function NHTM190:readUpdateStream(streamId, timestamp, connection)
	if connection:getIsServer() then
		if streamReadBool(streamId) then
		end;
	end;
end;

function NHTM190:writeUpdateStream(streamId, connection, dirtyMask)
	if not connection:getIsServer() then
		if streamWriteBool(streamId, bitAND(dirtyMask, self.vehicleDirtyFlag) ~= 0) then
        end;
    end;
end;

function NHTM190:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NHTM190:keyEvent(unicode, sym, modifier, isDown)
end;

function NHTM190:update(dt)
	if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			Cylindered.setDirty(self, part);
		end;

		if self.beaconLightsActive then
			rotate(self.beaconLightBase1, 0, self.beaconLights[1].speed*dt, 0);
			rotate(self.beaconLightBase2, 0, self.beaconLights[2].speed*dt, 0);
		end;
		if self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.NH_LOWER_ALL_IMPLEMENTS) then
				if self.implementCount == 2 then
					self.loweringDone = false;
					self.delay = self.moveDownIntervall;
					self.doLowering = true;
					self.nextAction = not self.attacherJoints[1].moveDown;
					if self.attacherJoints[2].moveDown ~= not self.nextAction then
						self.nextAction = false;
					end;
				end;
			end;
		end;
	end;

	if self.frontAxle.rotNode ~= nil and self.wheels[1].repr ~= nil and self.wheels[2].repr ~= nil then
		local ax, ay, az = getWorldTranslation(self.wheels[1].repr);
        local bx, by, bz = getWorldTranslation(self.wheels[2].repr);
		local x, y, z = worldDirectionToLocal(getParent(self.frontAxle.rotNode), bx-ax, by-ay, bz-az);

        setDirection(self.frontAxle.rotNode, x, y, z, 1, 0, 1);

		local x2,y2,z2 = getRotation(self.frontAxle.rotNode);

		--renderText(0.5, 0.65, 0.040, "x=" .. string.format((x2/3.14) * 180));
		--renderText(0.5, 0.75, 0.040, "y=" .. string.format((y2/3.14) * 180));
		--renderText(0.5, 0.85, 0.040, "z=" .. string.format((z2/3.14) * 180));

		setRotation(self.frontAxle.rotNode,x2 - 1.571,y2,z2 + 1.571);
	end;

	-- Seat animation
	if self.wheels[3].repr ~= nil and self.wheels[4].repr ~= nil then
		local x,y,z = getTranslation(self.wheels[3].repr);
		local x2,y2,z2 = getTranslation(self.wheels[4].repr);

		self.averageYTranslation = (y + y2)/2;
	end;

	if self.seatTranslation > self.averageYTranslation then
		self.seatTranslation = self.seatTranslation - self.maxTranslationPrCycle * dt;
		if self.seatTranslation < self.averageYTranslation then
			self.seatTranslation = self.averageYTranslation;
		end;
	elseif self.seatTranslation < self.averageYTranslation then
		self.seatTranslation = self.seatTranslation + self.maxTranslationPrCycle * dt;
		if self.seatTranslation > self.averageYTranslation then
			self.seatTranslation = self.averageYTranslation;
		end;
	end;

	if self.seatNode ~= nil then
		setTranslation(self.seatNode, self.startSeatXTranslation, self.seatTranslation, self.startSeatZTranslation);
	end;
	-- Making the visible wheels rotate
	if self.wheels[1].repr ~= nil and self.wheels[2].repr ~= nil then
		local x,y,z = getRotation(self.wheels[1].driveNode);
		local x2,y2,z2 = getRotation(self.wheels[1].repr);
		setRotation(self.animatedWheel[1].wheel, x,y,z);
		setRotation(self.animatedWheel[1].rotNode, x2,y2,z2);

		local x3,y3,z3 = getRotation(self.wheels[2].driveNode);
		local x4,y4,z4 = getRotation(self.wheels[2].repr);
		setRotation(self.animatedWheel[2].wheel, x3,y3,z3);
		setRotation(self.animatedWheel[2].rotNode, x4,y4,z4);
	end;

	-- Dynamic fenders
	if self.animatedWheel[1].fenderAttach ~= nil and self.animatedWheel[2].fenderAttach ~= nil then
		local x, y, z = getRotation(self.animatedWheel[1].rotNode);
		local x2, y2, z2 = getRotation(self.animatedWheel[2].rotNode);

		local fenderYRot = (y * 0.6 - self.maxTranslationPrCycle * dt);
		local fenderY2Rot = (y2 * 0.6 - self.maxTranslationPrCycle * dt);

		setRotation(self.animatedWheel[1].fenderAttach, x, fenderYRot, z);
		setRotation(self.animatedWheel[2].fenderAttach, x2, fenderY2Rot, z2);

		--local x3,y3,z3 = getRotation(self.animatedWheel[1].fenderAttach);
		--renderText(0.5, 0.65, 0.040, string.format(y3));

		--local x4,y4,z4 = getRotation(self.animatedWheel[2].fenderAttach);
		--renderText(0.5, 0.55, 0.040, string.format(y4));
	end;

	if self.isEntered then
		self:RPMDigits();
		self:updateFuelIndicators();
	end;
end;

function NHTM190:updateTick(dt)
	if self:getIsActive() then
		if self.rearAttacherJoint.armPullerRearNode ~= nil and self.rearAttacherJoint.orientNode ~= nil then
			local x,_,_ = getRotation(self.rearAttacherJoint.orientNode)
			local _,y,z = getRotation(self.rearAttacherJoint.armPullerRearNode)
			setRotation(self.rearAttacherJoint.armPullerRearNode, x,y,z);
		end;

		if self.isMotorStarted then
			if self.fuelFillLevel < 50 then
				setVisibility(self.dashboardFuel, true);
			else
				setVisibility(self.dashboardFuel, false);
			end;

			if self.is4wdActive then
				setVisibility(self.dashboard4WD, true);
			else
				setVisibility(self.dashboard4WD, false);
			end;

			if self.dashboardFast ~= nil then
				if self.currentFwdGear > 14 then
					setVisibility(self.dashboardFast, true);
				elseif self.currentFwdGear <= 14 then
					setVisibility(self.dashboardFast, false);
				end;
			end;

			if self.dashboardSlow ~= nil then
				if self.currentFwdGear <= 6 then
					setVisibility(self.dashboardSlow, true);
				else
					setVisibility(self.dashboardSlow, false);
				end;
			end;

			local mySpeed = self.lastSpeed*3600;
			if self.isBraking and mySpeed > 0 then
				if self.dashboard4WD ~= nil then
					setVisibility(self.dashboard4WD, true);
				end;
			end;

			if self.dashboardParkingBrake ~= nil then
				if self.handbrake then
					setVisibility(self.dashboardParkingBrake, true);
				else
					setVisibility(self.dashboardParkingBrake, false);
				end;
			end;

			if self.lightsActive then
				setVisibility(self.digitRPMs,false);
				setVisibility(self.digitRPMsLight,true);
				setVisibility(self.fuelIndicatorsGroup, false);
				setVisibility(self.fuelIndicatorsLightGroup, true);
			else
				setVisibility(self.digitRPMs,true);
				setVisibility(self.digitRPMsLight,false);
				setVisibility(self.fuelIndicatorsGroup, true);
				setVisibility(self.fuelIndicatorsLightGroup, false);
			end;

			for k, implement in pairs(self.attachedImplements) do
				if implement.object ~= nil then
					if implement.object.isTurnedOn then
						setTranslation(self.PTOKnob, -0.71, 2.378, -1.335);
						setVisibility(self.PTOOnLight, true);
					else
						setTranslation(self.PTOKnob, -0.71675, 2.3679, -1.3369);
						setVisibility(self.PTOOnLight, false);
					end;
				end;
			end;
		end;

		if self.ignitionMode == 0 then
			if self.dashboardSlow ~= nil then
				setVisibility(self.dashboardSlow, false);
			end;
			if self.dashboardFast ~= nil then
				setVisibility(self.dashboardFast, false);
			end;
			if self.dashboardParkingBrake ~= nil then
				setVisibility(self.dashboardParkingBrake, false);
			end;
			if self.shuttleIndicatorsIndex ~= nil then
				setVisibility(self.shuttleIndicatorsIndex,false);
			end;
			if self.shuttleIndicatorsLightIndex ~= nil then
				setVisibility(self.shuttleIndicatorsLightIndex,false);
			end;
			if self.gearDigits ~= nil then
				setVisibility(self.gearDigits,false);
			end;
			if self.gearDigitsLight ~= nil then
				setVisibility(self.gearDigitsLight,false);
			end;
			if self.dashboard4WD ~= nil then
				setVisibility(self.dashboard4WD, false);
			end;
			if self.dashboardFuel ~= nil then
				setVisibility(self.dashboardFuel, false);
			end;
			if self.digitRPMs ~= nil then
				setVisibility(self.digitRPMs,false);
			end;
			if self.digitRPMsLight ~= nil then
				setVisibility(self.digitRPMsLight,false);
			end;
			if self.fuelIndicatorsGroup ~= nil then
				setVisibility(self.fuelIndicatorsGroup, false);
			end;
			if self.fuelIndicatorsLightGroup ~= nil then
				setVisibility(self.fuelIndicatorsLightGroup, false);
			end;
			if self.blankDisplays ~= nil then
				setVisibility(self.blankDisplays, true);
			end;
		elseif self.ignitionMode == 1 then
			if self.lightsActive then
				if self.fuelIndicatorsGroup ~= nil then
					setVisibility(self.fuelIndicatorsGroup, false);
				end;
				if self.fuelIndicatorsLightGroup ~= nil then
					setVisibility(self.fuelIndicatorsLightGroup, true);
				end;
			else
				if self.fuelIndicatorsGroup ~= nil then
					setVisibility(self.fuelIndicatorsGroup, true);
				end;
				if self.fuelIndicatorsLightGroup ~= nil then
					setVisibility(self.fuelIndicatorsLightGroup, false);
				end;
			end;
			if self.blankDisplays ~= nil then
				setVisibility(self.blankDisplays, false);
			end;
			if self.dashboardBattery ~= nil then
				setVisibility(self.dashboardBattery, true);
			end;
			if self.dashboardEngineThing1 ~= nil then
				setVisibility(self.dashboardEngineThing1, true);
			end;
			if self.dashboardEngineThing2 ~= nil then
				setVisibility(self.dashboardEngineThing2, true);
			end;
			if self.dashboardParkingBrake ~= nil then
				setVisibility(self.dashboardParkingBrake, true);
			end;
			if self.oilLight ~= nil then
				setVisibility(self.oilLight, true);
			end;
			if self.dashboardFuel ~= nil then
				setVisibility(self.dashboardFuel, true);
			end;
		elseif self.ignitionMode == 2 then
			if self.dashboardBattery ~= nil then
				setVisibility(self.dashboardBattery, false);
			end;
			if self.dashboardEngineThing1 ~= nil then
				setVisibility(self.dashboardEngineThing1, false);
			end;
			if self.dashboardEngineThing2 ~= nil then
				setVisibility(self.dashboardEngineThing2, false);
			end;
			if self.oilLight ~= nil then
				setVisibility(self.oilLight, false);
			end;
			if self.dashboardFuel ~= nil then
				setVisibility(self.dashboardFuel, false);
			end;
		end;
	end;

	-- Stop wipers in correct position
	if not self.finishWiperFront then
		if getAnimTrackTime(self.wiperFrontAnimCharSet, 0) % self.wiperFrontAnimDuration <= 100 then
			setAnimTrackTime(self.wiperFrontAnimCharSet, 0, 0.0);
			disableAnimTrack(self.wiperFrontAnimCharSet, 0);
			self.finishWiperFront = true;
		end;
	end;

	if not self.finishWiperBack then
		if getAnimTrackTime(self.wiperBackAnimCharSet, 0) % self.wiperBackAnimDuration <= 100 then
			setAnimTrackTime(self.wiperBackAnimCharSet, 0, 0.0);
			disableAnimTrack(self.wiperBackAnimCharSet, 0);
			self.finishWiperBack = true;
		end;
	end;

	-- Start front wiper g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 or
	if self.wiperFrontOn then
		if not self.isWiperFrontActive then
			enableAnimTrack(self.wiperFrontAnimCharSet, 0);
			enableAnimTrack(self.wiperBackAnimCharSet, 0);
			self.isWiperFrontActive = true;
			self.isWiperBackActive = true;
		end;
		setRotation(self.wiperLever, 0, math.rad(-18), 0);
	else
		if self.isWiperFrontActive then
			self.isWiperFrontActive = false;
			self.finishWiperFront = false;
		end;
		setRotation(self.wiperLever, 0, 0, 0);
	end;

	-- Start rear wiper g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 or
	if self.wiperBackOn then
		if not self.isWiperBackActive then
			enableAnimTrack(self.wiperBackAnimCharSet, 0);
			self.isWiperBackActive = true;
		end;
	else
		if self.isWiperBackActive then
			self.isWiperBackActive = false;
			self.finishWiperBack = false;
		end;
	end;

	-- Switches rotations
	-- Back wiper switch
	if self.switch[1] ~= nil then
		if self.wiperBackOn then
			setRotation(self.switch[1], math.rad(-43.27), math.rad(-11.6), math.rad(-12));
		else
			setRotation(self.switch[1], math.rad(-44.5), 0, 0);
		end;
	end;

	-- Beaconlights switch
	if self.switch[2] ~= nil then
		if self.beaconLightsActive then
			setRotation(self.switch[2], math.rad(-43.27), math.rad(-11.6), math.rad(-12));
			setVisibility(self.beaconSwitchLight, true);
		else
			setRotation(self.switch[2], math.rad(-44.5), 0, 0);
			setVisibility(self.beaconSwitchLight, false);
		end;
	end;

	-- Warninglights switch
	if self.switch[3] ~= nil then
		if self.B3.wl then
			setRotation(self.switch[3], math.rad(-43.27), math.rad(-11.6), math.rad(-12));
		else
			setRotation(self.switch[3], math.rad(-44.5), 0, 0);
		end;
	end;

	-- Levers rotations
	if self.shuttleLever ~= nil then
		if self.shuttleDirection == "forward" then
			setRotation(self.shuttleLever, 0, math.rad(-15), 0);
		elseif self.shuttleDirection == "reverse" then
			setRotation(self.shuttleLever, 0, math.rad(15), 0);
		elseif self.shuttleDirection == "neutral" then
			setRotation(self.shuttleLever, 0, 0, 0);
		end;
	end;
	if self.indicatorsLever ~= nil then
		if not self.B3.wl then
			if self.B3.dirRight[1].a then
				setRotation(self.indicatorsLever, 0, math.rad(20), math.rad(180));
			elseif self.B3.dirLeft[1].a then
				setRotation(self.indicatorsLever, 0, math.rad(-20), math.rad(180));
			else
				setRotation(self.indicatorsLever, 0, 0, math.rad(180));
			end;
		else
			setRotation(self.indicatorsLever, 0, 0, math.rad(180));
		end;
	end;
end;

function NHTM190:draw()
	if self.implementCount == 2 then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("LOWER_ALL_IMPLEMENTS"), self.typeDesc), InputBinding.LOWER_ALL_IMPLEMENTS);
	end;
end;

function NHTM190:onLeave()
	if self.isWiperFrontActive then
		disableAnimTrack(self.wiperFrontAnimCharSet, 0);
	end;
	if self.isWiperBackActive then
		disableAnimTrack(self.wiperBackAnimCharSet, 0);
	end;
end;

function NHTM190:onEnter()
	if self.isWiperFrontActive then
		enableAnimTrack(self.wiperFrontAnimCharSet, 0);
	end;
	if self.isWiperBackActive then
		enableAnimTrack(self.wiperBackAnimCharSet, 0);
	end;
end;

function NHTM190:RPMDigits()
	-- Digital Display handling RPM
	if self.isEntered then
		if self.isMotorStarted then
			if self.showSpeed then
				local mySpeed = self.lastSpeed*3600;
				self.displayValue = mySpeed;
			else
				if self.currentCycle < self.cycleRoundMax then
					self.currentCycle = self.currentCycle + 1;
					self.currentRPM = self.motor.lastMotorRpm;
					if self.rpmMeterValue ~= nil then
						self.currentRPM = self.rpmMeterValue;
					end;
					self.lastRpm = math.floor((self.lastRpm + self.currentRPM)/2);
				else
					self.currentCycle = 0;
					self.displayValue = self.lastRpm;
				end;
			end;
		else
			self.displayValue = 0;
		end;

		local displayValue = self.displayValue;
		-- Handle the digitRPMs in the display
		if self.isMotorStarted then
			local thousends = math.floor(displayValue/1000);
			local displayIndex = thousends;
			local isBlank = false;
			if self.prevousDigitRPMFour ~= thousends then
				if self.prevousDigitRPMFour > 0 then
					setVisibility(self.digitRPMFour[self.prevousDigitRPMFour].rotNode,false);
					setVisibility(self.digitRPMFourLight[self.prevousDigitRPMFour].rotNode,false);
				end;
				if displayIndex == 0 then
					isBlank = true;
				end;
				if isBlank then
					for i=1, self.numDigitRPMFour do
						setVisibility(self.digitRPMFour[i].rotNode,false);
						setVisibility(self.digitRPMFourLight[i].rotNode,false);
					end;
				else
					setVisibility(self.digitRPMFour[displayIndex].rotNode,true);
					setVisibility(self.digitRPMFourLight[displayIndex].rotNode,true);
				end;
			end;
			self.prevousDigitRPMFour = displayIndex;

			displayValue = displayValue - thousends * 1000;
			local hundreds = math.floor(displayValue/100);
			displayIndex = hundreds;
			isBlank = false;
			if self.prevousDigitRPMThree ~= hundreds then
				if self.prevousDigitRPMThree > 0 then
					setVisibility(self.digitRPMThree[self.prevousDigitRPMThree].rotNode,false);
					setVisibility(self.digitRPMThreeLight[self.prevousDigitRPMThree].rotNode,false);
				end;
				if displayIndex == 0 and thousends == 0 then
					isBlank = true;
				elseif displayIndex == 0 then
					if thousends > 0 then
						displayIndex = 10;
					end;
				end;
				if isBlank then
					for i=1, self.numDigitRPMThree do
						setVisibility(self.digitRPMThree[i].rotNode,false);
						setVisibility(self.digitRPMThreeLight[i].rotNode,false);
					end;
				else
					setVisibility(self.digitRPMThree[displayIndex].rotNode,true);
					setVisibility(self.digitRPMThreeLight[displayIndex].rotNode,true);
				end;
			end;
			self.prevousDigitRPMThree = displayIndex;

			displayValue = displayValue - hundreds * 100;
			local tens = math.floor(displayValue/10);
			displayIndex = tens;
			isBlank = false;
			if self.prevousDigitRPMTwo ~= tens then
				if self.prevousDigitRPMTwo > 0 then
					setVisibility(self.digitRPMTwo[self.prevousDigitRPMTwo].rotNode,false);
					setVisibility(self.digitRPMTwoLight[self.prevousDigitRPMTwo].rotNode,false);
				end;
				if displayIndex == 0 and hundreds == 0 then
					isBlank = true;
				elseif displayIndex == 0 then
					if hundreds > 0 or thousends > 0 then
						displayIndex = 10;
					end;
				end;
				if isBlank then
					for i=1, self.numDigitRPMTwo do
						setVisibility(self.digitRPMTwo[i].rotNode,false);
						setVisibility(self.digitRPMTwoLight[i].rotNode,false);
					end;
				else
					setVisibility(self.digitRPMTwo[displayIndex].rotNode,true);
					setVisibility(self.digitRPMTwoLight[displayIndex].rotNode,true);
				end;
			end;
			self.prevousDigitRPMTwo = displayIndex;

			displayValue = displayValue - tens * 10;
			local ones = math.floor(displayValue);
			--displayIndex = 10;
			if self.showSpeed then
				if displayValue >= 10 and displayValue < 20 then
					displayIndex = displayValue-10;
				elseif displayValue >= 20 and displayValue < 30 then
					displayIndex = displayValue-20;
				elseif displayValue >= 30 and displayValue < 40 then
					displayIndex = displayValue-30;
				elseif displayValue >= 40 and displayValue < 50 then
					displayIndex = displayValue-40;
				elseif displayValue >= 50 and displayValue < 60 then
					displayIndex = displayValue-50;
				else
					displayIndex = displayValue;
				end;
				--renderText(0.5, 0.65, 0.040, string.format(displayIndex));
			end;
			if self.prevousDigitRPMOne ~= ones then
				if self.prevousDigitRPMOne > 0 then
					if (math.floor(displayIndex)+1) ~= 11 then
						setVisibility(self.digitRPMOne[self.prevousDigitRPMOne].rotNode,false);
						setVisibility(self.digitRPMOneLight[self.prevousDigitRPMOne].rotNode,false);
					end;
				end;

				if math.floor(displayIndex) == 0 then
					displayIndex = 10;
				end;
				--renderText(0.5, 0.65, 0.040, string.format(displayIndex));
				setVisibility(self.digitRPMOne[math.floor(displayIndex)].rotNode,true);
				setVisibility(self.digitRPMOneLight[math.floor(displayIndex)].rotNode,true);
			end;
			self.prevousDigitRPMOne = math.floor(displayIndex);
			self.rpmDisplaysSetOff = false;
		else
			if not self.rpmDisplaysSetOff then
				for i=1, self.numDigitRPMOne do
					setVisibility(self.digitRPMOne[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMTwo do
					setVisibility(self.digitRPMTwo[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMThree do
					setVisibility(self.digitRPMThree[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMFour do
					setVisibility(self.digitRPMFour[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMOneLight do
					setVisibility(self.digitRPMOneLight[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMTwoLight do
					setVisibility(self.digitRPMTwoLight[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMThreeLight do
					setVisibility(self.digitRPMThreeLight[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMFourLight do
					setVisibility(self.digitRPMFourLight[i].rotNode,false);
				end;

				self.rpmDisplaysSetOff = true;
			end;
		end;
	end;
end;

function NHTM190:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = self.implementCount + 1;
		end;
		if jointIndex == 1 then
			setVisibility(self.rearLinkageBall1, true);
			setVisibility(self.rearLinkageBall2, true);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 2 then
			setVisibility(self.trailerPinHigh, true);
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 3 then
			setVisibility(self.trailerPinLow, true);
		end;
	end;

	self.updateJoint = true;
end;

function NHTM190:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = math.max(self.implementCount - 1, 0);
		end;
		if jointIndex == 1 then
			setVisibility(self.rearLinkageBall1, false);
			setVisibility(self.rearLinkageBall2, false);
		end;
	else
		setVisibility(self.trailerPinLow, false);
		setVisibility(self.trailerPinHigh, false);
	end;
end;

function NHTM190:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;

function NHTM190:updateFuelIndicators()
	local amountOfFuelPerIndicator = self.fuelCapacity/12;

	local timesToIterate = self.fuelFillLevel/amountOfFuelPerIndicator;

	timesToIterate = math.floor(timesToIterate);

	if self.oldTimesToIterate ~= timesToIterate then
		for i=1, self.numFuelIndicators do
			setVisibility(self.fuelIndicators[i].rotNode, false);
			setVisibility(self.fuelIndicatorsLight[i].rotNode, false);
		end;

		for i=1, timesToIterate do
			setVisibility(self.fuelIndicators[i].rotNode, true);
			setVisibility(self.fuelIndicatorsLight[i].rotNode, true);
		end;
	end;

	self.oldTimesToIterate = timesToIterate;
end;

function NHTM190:change4wdState(current4wdState, noEventSend)
	Change4wdStateEvent.sendEvent(self,current4wdState,noEventSend);

	if current4wdState then
		self.wheels[1].driveMode = 0;
		self.wheels[2].driveMode = 0;
		self.is4wdActive = false;
		self.motor.forwardTorqueCurve = AnimCurve:new(linearInterpolator1);
 		self.motor.forwardTorqueCurve:addKeyframe({v = 11.5*3, time = 2550});
	else
		self.wheels[1].driveMode = 2;
		self.wheels[2].driveMode = 2;
		self.is4wdActive = true;
		self.motor.forwardTorqueCurve = AnimCurve:new(linearInterpolator1);
 		self.motor.forwardTorqueCurve:addKeyframe({v = 7.5*3, time = 2550});
	end;
end;
