-- Power Command change shuttle to neutral event-class
ShuttleToNeutralEvent = {};
ShuttleToNeutralEvent_mt = Class(ShuttleToNeutralEvent, Event);

InitEventClass(ShuttleToNeutralEvent, "ShuttleToNeutralEvent");

function ShuttleToNeutralEvent:emptyNew()
    local self = Event:new(ShuttleToNeutralEvent_mt);
    self.className="ShuttleToNeutralEvent";
    return self;
end;

function ShuttleToNeutralEvent:new(vehicle, shuttleDirectionNeutral)
    local self = ShuttleToNeutralEvent:emptyNew()
    self.vehicle = vehicle;
	self.shuttleDirectionNeutral = shuttleDirectionNeutral;
    return self;
end;

function ShuttleToNeutralEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.shuttleDirectionNeutral = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ShuttleToNeutralEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.shuttleDirectionNeutral);
end;

function ShuttleToNeutralEvent:run(connection)
	self.vehicle:shuttleToNeutral(self.shuttleDirectionNeutral, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ShuttleToNeutralEvent:new(self.vehicle, self.shuttleDirectionNeutral), nil, connection, self.vehicle);
    end;
end;

function ShuttleToNeutralEvent.sendEvent(vehicle, shuttleDirectionNeutral, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ShuttleToNeutralEvent:new(vehicle, shuttleDirectionNeutral), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ShuttleToNeutralEvent:new(vehicle, shuttleDirectionNeutral));
		end;
	end;
end;
