SetLastAccelerationEvent = {};
SetLastAccelerationEvent_mt = Class(SetLastAccelerationEvent, Event);

InitEventClass(SetLastAccelerationEvent, "SetLastAccelerationEvent");

function SetLastAccelerationEvent:emptyNew()
    local self = Event:new(SetLastAccelerationEvent_mt);
    self.className="SetLastAccelerationEvent";
    return self;
end;

function SetLastAccelerationEvent:new(vehicle, lastAcceleration)
    local self = SetLastAccelerationEvent:emptyNew()
    self.vehicle = vehicle;
	self.lastAcceleration = lastAcceleration;
    return self;
end;

function SetLastAccelerationEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.lastAcceleration = streamReadFloat32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetLastAccelerationEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteFloat32(streamId, self.lastAcceleration);
end;

function SetLastAccelerationEvent:run(connection)
	self.vehicle:setLastAcceleration(self.lastAcceleration);
end;
