SetGearRatiosEvent = {};
SetGearRatiosEvent_mt = Class(SetGearRatiosEvent, Event);

InitEventClass(SetGearRatiosEvent, "SetGearRatiosEvent");

function SetGearRatiosEvent:emptyNew()
    local self = Event:new(SetGearRatiosEvent_mt);
    self.className="SetGearRatiosEvent";
    return self;
end;

function SetGearRatiosEvent:new(vehicle, currentRatio)
    local self = SetGearRatiosEvent:emptyNew()
    self.vehicle = vehicle;
	self.currentRatio = currentRatio;
    return self;
end;

function SetGearRatiosEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.currentRatio = streamReadFloat32(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetGearRatiosEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteFloat32(streamId, self.currentRatio);
end;

function SetGearRatiosEvent:run(connection)
	self.vehicle:setGearRatio(self.currentRatio);
end;
