--
-- NCfarms
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

NCfarms = {}

local NCfarms_mt = Class(NCfarms, Mission00);

function NCfarms:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = NCfarms_mt;
    end;
    local self = NCfarms:superClass():new(baseDirectory, mt);
    return self;
end;

function NCfarms:delete()
    NCfarms:superClass().delete(self);
end;

function NCfarms:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
	
	-- load paths for AI traffic vehicles
    -- self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));


    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    NCfarms:superClass().load(self);
end
function NCfarms:loadFinished()
    NCfarms:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function NCfarms:mouseEvent(posX, posY, isDown, isUp, button)
    NCfarms:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function NCfarms:keyEvent(unicode, sym, modifier, isDown)
    NCfarms:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function NCfarms:update(dt)
    NCfarms:superClass().update(self, dt);
end;

function NCfarms:draw()
    NCfarms:superClass().draw(self);
end;
