--
-- manualIgnition
-- Specialization for Motor Ignition
--
-- @author  Templaer
-- @date  01/05/09
--

manualIgnition = {};

function manualIgnition.prerequisitesPresent(specializations)
    return true;
end;

function manualIgnition:load(xmlFile)
    -- Booleans
    self.ignitionKey = false;
	self.allowedIgnition = false;                                                  
	
	-- Backup Stop Sound volume
    self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
end;

function manualIgnition:delete()
end;

function manualIgnition:mouseEvent(posX, posY, isDown, isUp, button)
end;

function manualIgnition:keyEvent(unicode, sym, modifier, isDown)
end;

function manualIgnition:update(dt)
    acceleration = -InputBinding.getAnalogInputAxis(InputBinding.AXIS_FORWARD);
    if InputBinding.isAxisZero(acceleration) then
        acceleration = -InputBinding.getDigitalInputAxis(InputBinding.AXIS_FORWARD);
    end;

	-- Does not execute when AI is activated
    if not self.isAITractorActivated then
        -- Handles ignition key input
        if self:getIsActiveForInput() then
            if InputBinding.hasEvent(InputBinding.M150IGNITION) then
		        self.ignitionKey = not self.ignitionKey;
			    self.allowedIgnition = true;
	        end;
			
			if math.abs(acceleration) > 0.3 and self.isMotorStarted == false then
			    self.ignitionKey = true;
				self.allowedIgnition = true;
			end;
	    end;
		
	    -- Prevents the engine from starting upon entering
	    if not self.allowedIgnition and  not self.ignitionKey then
            self.isMotorStarted = false;
            Motorized.stopSounds(self);
	        self.steeringEnabled = false;
            Utils.setEmittingState(self.exhaustParticleSystems, false)
			self.motor:setSpeedLevel(0, true);
	    end;
	
	    -- Mutes stop sound when engine is off
	    if not self.ignitionKey then
	        self.motorStopSoundVolume = 0;
        else
	        self.motorStopSoundVolume = self.motorStopSoundVolume2;
	    end;
		
	    -- Starts and stops the engine
	    if self.allowedIgnition then
	        if  not self.ignitionKey then
		        self.motorStopSoundVolume = self.motorStopSoundVolume2;
                self:stopMotor();
			    self.steeringEnabled = false;
                self.allowedIgnition = false;	
		
			    -- Brakes the wheels upon turning off the engine
                for k,wheel in pairs(self.wheels) do
                    setWheelShapeProps(wheel.node, wheel.wheelShape, 0, self.motor.brakeForce, 0);
                end;
                self:onDeactivateAttachements();
	        elseif self.ignitionKey then
                self:startMotor();
                self.steeringEnabled = true;
                self.allowedIgnition = false;
				if self.isMotorStarted and self.isEntered then	
			if self.motor.speedLevel ~= 0 then
				self.speedLevel = self.motor.speedLevel;
			end;
		end;  	
       	    end;
	    end;
    -- Prevents the AI from working when engine is off
    elseif not self.ignitionKey and not self.deactivateOnLeave then
		self:stopAITractor();
	end;
end;

function manualIgnition:onLeave()
    --Leaves the engine on when AI is driving
	if not self.deactivateOnLeave then
	    self.allowedIgnition = false;
	    self.ignitionKey = true; 
    else
	    self.allowedIgnition = false;
	    self.ignitionKey = false;
	end;
end;

function manualIgnition:draw()
    -- Draws ignition mode and ignition text
    --[[if not self.isMotorStarted and not self.automaticStart then	
        g_currentMission:addHelpButtonText(g_i18n:getText("FendtStart"), InputBinding.IGNITION);
	end;]]
end;

