--
-- Stats
-- Specialization for Stats
--
-- @author  Hitman
--@date 20/10/09
--
--Copyright (C) by Hitman, Confidential, All Rights Reserved.

Stats = {};

function Stats.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Stats:load(xmlFile)
		
	self.statsInfoBasePosX = 0.012;
    self.statsInfoBaseWidth = 0.22;
    self.statsInfoBasePosY = 0.012;
    self.statsInfoBaseHeight = 0.14;

	self.infoPanelPath = Utils.getFilename("Spezi/HUD.png", self.baseDirectory);
	self.statsInfoBaseOverlay = Overlay:new("statsInfoBaseOverlay", self.infoPanelPath, self.statsInfoBasePosX, self.statsInfoBasePosY, self.statsInfoBaseWidth, self.statsInfoBaseHeight);
				
	self.fuelUsage = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.fuelUsage"), 0.01);
	self.fuelConsumption = 0;
	self.distanceDriven = 0;
	self.fuelUsed = 0;
	self.runningTime = 0;	
	
  
end;

function Stats:delete()
end;

function Stats:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Stats:keyEvent(unicode, sym, modifier, isDown)

 if InputBinding.isPressed(InputBinding.STATS) then
	
	self.statsInfoPanel = not self.statsInfoPanel;

end;
end;

function Stats:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    local runningTime =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#runningTime"),0);
    self.runningTime = runningTime;
    local distanceDriven =  Utils.getNoNil(getXMLFloat(xmlFile, key.."#distanceDriven"),0);
    self.distanceDriven = distanceDriven;
	local fuelUsed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#fuelUsed"), 0);
	self.fuelUsed = fuelUsed;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function Stats:getSaveAttributesAndNodes(nodeIdent)
    local runningTime = Utils.getNoNil(self.runningTime, 10);
	local distanceDriven = Utils.getNoNil(self.distanceDriven, 10);
	local fuelUsed = Utils.getNoNil(self.fuelUsed, 10);
    local attributes = 'runningTime="'..string.format("%f", runningTime)..'"'..' distanceDriven="'..string.format("%f", distanceDriven)..'"'..' fuelUsed="'..string.format("%f", fuelUsed)..'"';
    return attributes, nil;
end;



function Stats:update(dt)
	
	local kmMs = self.lastSpeed*self.speedDisplayScale / 1000;
	self.distanceDriven = self.distanceDriven + (kmMs * dt);
	
	if self.isMotorStarted then
	self.fuelConsumption = (self.motor.lastMotorRpm/1000*self.fuelUsage / dt) * 1000 * 60 * 60;
	else
	self.fuelConsumption = 0;
	end;
	
	self.fuelUsed = self.fuelUsed + self.motor.lastMotorRpm/1000*self.fuelUsage;
	
	  if self.isMotorStarted or self.isHired then 

		local time = (g_currentMission.environment.dayTime/(3600000000000/g_settingsTimeScale));

		self.runningTime = self.runningTime + time;
end;

function Stats:onLeave()
		
		self.fuelConsumption = 0;

end;   

	
	



function Stats:draw()

 if self.isEntered then
 
		if not self.statsInfoPanel then
		g_currentMission:addExtraPrintText(string.format("Taste %s: Stats anschalten", InputBinding.getKeyNamesOfDigitalAction(InputBinding.STATS)));
		end;
		if self.statsInfoPanel then
		g_currentMission:addExtraPrintText(string.format("Taste %s: Stats abschalten", InputBinding.getKeyNamesOfDigitalAction(InputBinding.STATS)));
			self.statsInfoBaseOverlay:render();
			setTextColor(1,1,1,1);
			renderText(self.statsInfoBasePosX + 0.01, self.statsInfoBasePosY + 0.07, 0.02,string.format("%s%d","Betriebsstunden: ", self.runningTime));
			renderText(self.statsInfoBasePosX + 0.01, self.statsInfoBasePosY + 0.03, 0.02,string.format("%s%d","Verb.(l/h): ", self.fuelConsumption));
			renderText(self.statsInfoBasePosX + 0.01, self.statsInfoBasePosY + 0.05, 0.02,string.format("%s%d","Verb.gesamt (l): ", self.fuelUsed));
			renderText(self.statsInfoBasePosX + 0.01, self.statsInfoBasePosY + 0.01, 0.02,string.format("%s%.1f","Gefahrene (km): ", self.distanceDriven));
			setTextColor(0,1,0,1);
			renderText(self.statsInfoBasePosX + 0.05, self.statsInfoBasePosY + 0.11, 0.025,"Statistiken"); 
		end;
	end;
	end;
end;