--
-- ESLimiter
-- Specialization for ESLimiter
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  20/12/09
--

ESLimiter = {};

function ESLimiter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function ESLimiter:load(xmlFile)

	self.LoadFromAttributesAndNodes = self.loadFromAttributesAndNodes;

	self.ESLimiter = {};
	self.ESLimiter.xPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ESLimiter#posX"), 0.835);
	self.ESLimiter.yPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ESLimiter#posY"), 0.15);
	self.ESLimiter.maxRPM = self.motor.maxRpm[3];
	self.ESLimiter.percentage = {};
	--for k,v in pairs(self.motor.maxRpm) do
		--self.ESLimiter.percentage[k] = self.motor.maxRpm[k]* 100 / self.ESLimiter.maxRPM
	--end;
end;

function ESLimiter:delete()
end;

function ESLimiter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ESLimiter:keyEvent(unicode, sym, modifier, isDown)
end;

function ESLimiter:update(dt)
	if self:getIsActiveForInput() then
		
		for i=1,table.getn(self.motor.maxRpm) do
			self.ESLimiter.percentage[i] =  self.motor.maxRpm[i] * 100 / self.ESLimiter.maxRPM
		end
		local currentLevel = self.motor.speedLevel;
		if currentLevel ~= 0 then
			local percentage = self.ESLimiter.percentage;
			if InputBinding.isPressed(InputBinding.ESLimiter_PLUS) and percentage[currentLevel] < 100 then
				percentage[currentLevel] = percentage[currentLevel] + 1;
			elseif InputBinding.isPressed(InputBinding.ESLimiter_MINUS) and percentage[currentLevel] > 10 then
				percentage[currentLevel] = percentage[currentLevel] - 1;
			end;
			self.motor.maxRpm[currentLevel] = percentage[currentLevel] * self.ESLimiter.maxRPM / 100;
		else
			self.motor.maxRpm[3] = self.ESLimiter.maxRPM;
		end;
	end;
end;

function ESLimiter:draw()
	local currentLevel = self.motor.speedLevel;
	local text = "Deaktiviert";
	local plus = string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.ESLimiter_PLUS), "Numpad ", "KP");	
	local minus = string.gsub(InputBinding.getKeyNamesOfDigitalAction(InputBinding.ESLimiter_MINUS), "Numpad ", "KP");	
	if currentLevel ~= 0 then
		local percentage = string.format("%d", self.ESLimiter.percentage[currentLevel]);
		if percentage ~= "100" then
			percentage = " " .. percentage;
		end;
		text = g_i18n:getText("ESLimiter_level") .. currentLevel .. ":" .. percentage .. "% [" .. plus .. "/" .. minus .. "]";	
	end;
	setTextBold(true);
	renderText(self.ESLimiter.xPos, self.ESLimiter.yPos, 0.02, text);
end;

_=[[
function ESLimiter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local valueStr = getXMLString(xmlFile, key.."#limiterValues");		
		if valueStr ~= nil then
			local found = string.find(valueStr, ";");
			local index = 1;
			while found ~= nil do
				local value = string.sub(valueStr, 0, found-1);
				valueStr = string.sub(valueStr, found+1);
				found = string.find(valueStr, ";");
				self.ESLimiter.percentage[index] = tonumber(value);
				if found == nil then
					self.ESLimiter.percentage[index+1] = tonumber(valueStr);
				end;
				index = index + 1;	
			end;
		end;
	end; 

    return BaseMission.VEHICLE_LOAD_OK;
end;

function ESLimiter:getSaveAttributesAndNodes(nodeIdent)
	local values = "";	
	for k,v in pairs(self.ESLimiter.percentage) do
		if k ~= 1 then
			values = values .. ";";
		end;
		values = values .. string.format("%d", v);
	end;
	
    local attributes = 'limiterValues="'.. values .. '"';
    return attributes, nil;
end;]]




