ReelAnimation = {};

function ReelAnimation.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations);
end;

function ReelAnimation:load(xmlFile)
end;

function ReelAnimation:delete()
end;

function ReelAnimation:readStream(streamId, connection)
end;

function ReelAnimation:writeStream(streamId, connection)
end;

function ReelAnimation:readUpdateStream(streamId, timestamp, connection)
end;

function ReelAnimation:writeUpdateStream(streamId, connection, dirtyMask)
end;

function ReelAnimation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ReelAnimation:keyEvent(unicode, sym, modifier, isDown)
end;

function ReelAnimation:update(dt)
    if self:getIsActiveForInput() then
		if InputBinding.isPressed(InputBinding.ReelAnimation_ReelUp) and self:getIsActiveForInput() then
			self:setAnimationTime(1, self.animationParts[1].currentPosition+(self.animationParts[1].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.ReelAnimation_ReelDown) and self:getIsActiveForInput() then
			self:setAnimationTime(1, self.animationParts[1].currentPosition-(self.animationParts[1].offSet+dt), false);
		end;
		if InputBinding.isPressed(InputBinding.ReelAnimation_ReelBack) and self:getIsActiveForInput() then
			self:setAnimationTime(2, self.animationParts[2].currentPosition+(self.animationParts[2].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.ReelAnimation_ReelFront) and self:getIsActiveForInput() then
			self:setAnimationTime(2, self.animationParts[2].currentPosition-(self.animationParts[2].offSet+dt), false);
		end;
    end;
end;

function ReelAnimation:updateTick(dt)
end;

function ReelAnimation:draw()
	--g_currentMission:addExtraPrintText(string.format(""..InputBinding.getKeyNamesOfDigitalAction(InputBinding.ReelAnimation_ReelUp) .. " / " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.ReelAnimation_ReelDown)..":      "..g_i18n:getText("ReelAnimation_ReelUpDown")..""));
	--g_currentMission:addExtraPrintText(string.format(""..InputBinding.getKeyNamesOfDigitalAction(InputBinding.ReelAnimation_ReelFront) .. " / " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.ReelAnimation_ReelBack)..":    "..g_i18n:getText("ReelAnimation_ReelFrontBack")..""));
end;

function ReelAnimation:onDetach()
end;

function ReelAnimation:onLeave()
end;

function ReelAnimation:onDeactivate()
end;