--
-- MountainValley
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

MountainValley = {}

local MountainValley_mt = Class(MountainValley, Mission00);

function MountainValley:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = MountainValley_mt;
    end;
    local self = MountainValley:superClass():new(baseDirectory, mt);
    return self;
end;

function MountainValley:delete()
    MountainValley:superClass().delete(self);
end;

function MountainValley:load()
    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);
    
    -- load the map
    self:loadMap(Utils.getFilename("map01.i3d", self.baseDirectory));
    
    -- load paths for AI traffic vehicles
    self:loadMap(Utils.getFilename("map01/paths/trafficPaths.i3d", self.baseDirectory));
    
    -- load paths for AI pedestrians
    self:loadMap(Utils.getFilename("map01/paths/pedestrianPaths.i3d", self.baseDirectory));
        
    AnimalHusbandry.initialize();
    self:loadMap(Utils.getFilename("$data/maps/missions/CattleMeadow.i3d", self.baseDirectory));
    
    -- load the PDA map image
    self.missionPDA:loadMap(Utils.getFilename("map01/pda_map.png", self.baseDirectory));
    
    MountainValley:superClass().load(self);
end
function MountainValley:loadFinished()
    MountainValley:superClass().loadFinished(self);
    AnimalHusbandry.finalize();
end;

function MountainValley:mouseEvent(posX, posY, isDown, isUp, button)
    MountainValley:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function MountainValley:keyEvent(unicode, sym, modifier, isDown)
    MountainValley:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function MountainValley:update(dt)
    MountainValley:superClass().update(self, dt);
end;

function MountainValley:draw()
    MountainValley:superClass().draw(self);
end;
