SetPrzeciwwagaPanelEvent = {};
SetPrzeciwwagaPanelEvent_mt = Class(SetPrzeciwwagaPanelEvent, Event);

InitEventClass(SetPrzeciwwagaPanelEvent, "SetPrzeciwwagaPanelEvent");

function SetPrzeciwwagaPanelEvent:emptyNew()
    local self = Event:new(SetPrzeciwwagaPanelEvent_mt);
    self.className="SetPrzeciwwagaPanelEvent";
    return self;
end;

function SetPrzeciwwagaPanelEvent:new(vehicle, isPrzeciwwagaDoorState)
    local self = SetPrzeciwwagaPanelEvent:emptyNew()
    self.vehicle = vehicle;
	self.isPrzeciwwagaPanelState = isPrzeciwwagaDoorState;
    return self;
end;

function SetPrzeciwwagaPanelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isPrzeciwwagaPanelState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetPrzeciwwagaPanelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isPrzeciwwagaPanelState);
end;

function SetPrzeciwwagaPanelEvent:run(connection)   
	self.vehicle:SetPrzeciwwagaPanel(self.isPrzeciwwagaPanelState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetPrzeciwwagaPanelEvent:new(self.vehicle, self.isPrzeciwwagaPanelState), nil, connection, self.vehicle);
    end;
end;

function SetPrzeciwwagaPanelEvent.sendEvent(vehicle, isPrzeciwwagaDoorState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetPrzeciwwagaPanelEvent:new(vehicle, isPrzeciwwagaDoorState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetPrzeciwwagaPanelEvent:new(vehicle, isPrzeciwwagaDoorState));
		end;
	end;
end;