SetMechanizmyPanelEvent = {};
SetMechanizmyPanelEvent_mt = Class(SetMechanizmyPanelEvent, Event);

InitEventClass(SetMechanizmyPanelEvent, "SetMechanizmyPanelEvent");

function SetMechanizmyPanelEvent:emptyNew()
    local self = Event:new(SetMechanizmyPanelEvent_mt);
    self.className="SetMechanizmyPanelEvent";
    return self;
end;

function SetMechanizmyPanelEvent:new(vehicle, isMechanizmyDoorState)
    local self = SetMechanizmyPanelEvent:emptyNew()
    self.vehicle = vehicle;
	self.isMechanizmyPanelState = isMechanizmyDoorState;
    return self;
end;

function SetMechanizmyPanelEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isMechanizmyPanelState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetMechanizmyPanelEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isMechanizmyPanelState);
end;

function SetMechanizmyPanelEvent:run(connection)   
	self.vehicle:SetMechanizmyPanel(self.isMechanizmyPanelState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetMechanizmyPanelEvent:new(self.vehicle, self.isMechanizmyPanelState), nil, connection, self.vehicle);
    end;
end;

function SetMechanizmyPanelEvent.sendEvent(vehicle, isMechanizmyDoorState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetMechanizmyPanelEvent:new(vehicle, isMechanizmyDoorState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetMechanizmyPanelEvent:new(vehicle, isMechanizmyDoorState));
		end;
	end;
end;