--
-- RopeBreakdown
-- Specialization for New Holland BB 980 from Strawmod to get it breakable due to a lack of rope.
--
-- @author  			Benjamin Biot (J&B Modding)
-- @version 			v1.0
-- @date  				30/11/10
-- @Sipma Z224 edit 	Burner

RopeBreakdown = {};

function RopeBreakdown.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Baler, specializations);
end;

function RopeBreakdown:load(xmlFile)
	self.SetDoorPanel= SpecializationUtil.callSpecializationsFunction("SetDoorPanel");
	self.SetMechanizmyPanel= SpecializationUtil.callSpecializationsFunction("SetMechanizmyPanel");
	self.SetPrzeciwwagaPanel= SpecializationUtil.callSpecializationsFunction("SetPrzeciwwagaPanel");
	self.SetHasRopes= SpecializationUtil.callSpecializationsFunction("SetHasRopes");
	-- Animation --
	self.DoorPanelAnimation = getXMLString(xmlFile, "vehicle.RopeDoorPanel#animationName");
	self.MechanizmyPanelAnimation = getXMLString(xmlFile, "vehicle.MechanizmyPanel#animationName");
	self.PrzeciwwagaPanelAnimation = getXMLString(xmlFile, "vehicle.PrzeciwwagaPanel#animationName");	
	self.DoorPanel = true;
	self.MechanizmyPanel = true;
	self.PrzeciwwagaPanel = true;
	
	-- Index of Rope Door --
	local RopeDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.RopeDoorPanel#index"));
	if RopeDoor ~= nil then
		self.RopeDoor = RopeDoor;
	end;
	
	-- Index of Mechanizmy Door --
	local MechanizmyDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.MechanizmyPanel#index"));
	if MechanizmyDoor ~= nil then
		self.MechanizmyDoor = MechanizmyDoor;
	end;
	
	-- Index of Przeciwwaga Door --
	local PrzeciwwagaDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.PrzeciwwagaPanel#index"));
	if PrzeciwwagaDoor ~= nil then
		self.PrzeciwwagaDoor = PrzeciwwagaDoor;
	end;
	
	-- Ropes management --
	self.Ropes = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.Ropes#index"));
	self.RopesCapacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Ropes#Capacity"), 4);
	self.hasRopes = true;
	self.isLoaded = true;
	
	-- Sound for "no Ropes " --
    NoRopeSoundFile = Utils.getFilename("Sounds/NoRope.ogg", self.baseDirectory);
    self.NoRopeSoundId = createSample("NoRopeSound");
    loadSample(self.NoRopeSoundId, NoRopeSoundFile, false);
    self.NoRopePlaying = false;
end;

function RopeBreakdown:delete()
    if self.NoRopeSound ~= nil then
        delete(self.NoRopeSound);
    end;
end;

function RopeBreakdown:readStream(streamId, connection)
	self:SetPrzeciwwagaPanel(streamReadBool(streamId), true);
    self:SetMechanizmyPanel(streamReadBool(streamId), true);
	self:SetDoorPanel(streamReadBool(streamId), true);
    self:SetHasRopes(streamReadBool(streamId), true);
end;

function RopeBreakdown:writeStream(streamId, connection)
	streamWriteBool(streamId, self.PrzeciwwagaPanel);
    streamWriteBool(streamId, self.MechanizmyPanel);
	streamWriteBool(streamId, self.DoorPanel);
    streamWriteBool(streamId, self.isLoaded);
end;

function RopeBreakdown:readUpdateStream(streamId, timestamp, connection)
end;

function RopeBreakdown:writeUpdateStream(streamId, connection, dirtyMask)
end;

function RopeBreakdown:mouseEvent(posX, posY, isDown, isUp, button)
end;

function RopeBreakdown:keyEvent(unicode, sym, modifier, isDown)
end;

function RopeBreakdown:update(dt)	
	-- Manage key events --
	if self.inrangeRopeDoor then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			self:SetDoorPanel(not self.DoorPanel);
		end;
		if not self.isLoaded then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:SetHasRopes(true);
			end;
		end;
	end;
	if self.inrangeMechanizmyDoor then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			self:SetMechanizmyPanel(not self.MechanizmyPanel);
		end;
	end;
	if self.inrangePrzeciwwagaDoor then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
			self:SetPrzeciwwagaPanel(not self.PrzeciwwagaPanel);
		end;
	end;
	-- trigger the breakdown --
	if self.NoRopesBalesCount >= self.RopesCapacity then
		self:SetHasRopes(false);
	end;		
	-- Display key when in range --
	if self.inrangeRopeDoor then
		if self.DoorPanel then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("OPEN_DOOR"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("CLOSE_DOOR"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
			if not self.isLoaded then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("RELOAD_ROPES"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			end;
		end;
	end;
	if self.inrangeMechanizmyDoor then
		if self.MechanizmyPanel then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("OPEN_DOOR"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("CLOSE_DOOR"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		end;
	end;
	if self.inrangePrzeciwwagaDoor then
		if self.PrzeciwwagaPanel then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("OPEN_DOOR"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("CLOSE_DOOR"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
		end;
	end;
end;

function RopeBreakdown:updateTick(dt)	
	if self.attacherVehicle and g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 1.0; --max distance allowed
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(self.RopeDoor); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrangeRopeDoor = true; 
		else
			self.inrangeRopeDoor = false; 
		end;
		
		local qx, qy, qz = getWorldTranslation(self.MechanizmyDoor); 
		local mechanizmyDistance = Utils.vector3Length(qx-vx, qy-vy, qz-vz);	
		if mechanizmyDistance < nearestDistance then
			self.inrangeMechanizmyDoor = true; 
		else
			self.inrangeMechanizmyDoor = false; 
		end;
		
		local wx, wy, wz = getWorldTranslation(self.PrzeciwwagaDoor); 
		local przeciwwagaDistance = Utils.vector3Length(wx-vx, wy-vy, wz-vz);	
		if przeciwwagaDistance < nearestDistance then
			self.inrangePrzeciwwagaDoor = true; 
		else
			self.inrangePrzeciwwagaDoor = false; 
		end;
	end;
end;

function RopeBreakdown:SetDoorPanel(isDoorPanel,noEventSend)
	SetDoorPanelEvent.sendEvent(self, isDoorPanel, noEventSend);
	-- Play doorPanel animation if inRange --
	if isDoorPanel then
		if self.DoorPanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.DoorPanelAnimation, -1, nil, true);
			self.DoorPanel = true;
		end;
	else
		if self.DoorPanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.DoorPanelAnimation, 1, nil, true);
			self.DoorPanel = false;
		end;
	end;
end;

function RopeBreakdown:SetMechanizmyPanel(isMechanizmyPanel,noEventSend)
	SetMechanizmyPanelEvent.sendEvent(self, isMechanizmyPanel, noEventSend);
	-- Play MechanizmyPanel animation if inRange --
	if isMechanizmyPanel then
		if self.MechanizmyPanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.MechanizmyPanelAnimation, -1, nil, true);
			self.MechanizmyPanel = true;
		end;
	else
		if self.MechanizmyPanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.MechanizmyPanelAnimation, 1, nil, true);
			self.MechanizmyPanel = false;
		end;
	end;
end;

function RopeBreakdown:SetPrzeciwwagaPanel(isPrzeciwwagaPanel,noEventSend)
	SetPrzeciwwagaPanelEvent.sendEvent(self, isPrzeciwwagaPanel, noEventSend);
	-- Play PrzeciwwagaPanel animation if inRange --
	if isPrzeciwwagaPanel then
		if self.PrzeciwwagaPanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.PrzeciwwagaPanelAnimation, -1, nil, true);
			self.PrzeciwwagaPanel = true;
		end;
	else
		if self.PrzeciwwagaPanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.PrzeciwwagaPanelAnimation, 1, nil, true);
			self.PrzeciwwagaPanel = false;
		end;
	end;
end;

function RopeBreakdown:SetHasRopes(isLoaded,noEventSend)
	self.isLoaded = isLoaded;
	SetHasRopesEvent.sendEvent(self, self.isLoaded, noEventSend);
	if self.isLoaded then
		self.NoRopesBalesCount = 0;
		setVisibility(self.Ropes, true);
		if self.NoRopePlaying then
			stopSample(self.NoRopeSoundId);
			self.NoRopePlaying = false;
		end;
	else
		setVisibility(self.Ropes, false);	
		self:setPickup(false, true);
		if self:getIsActiveForSound() then
			if not self.NoRopePlaying then
				playSample(self.NoRopeSoundId, 1, 1, 0);
				self.NoRopePlaying = true;
			end;
		end;
	end;
end;

function RopeBreakdown:draw()
	setTextBold(true);
	setTextColor(0, 0, 0, 1.0);
	--if self.HUD then	
		if not self.isLoaded then
			--g_currentMission:addWarning("Brak sznurka.\nPodejdz do prasy i uzupelnij sznurek");
			if self.HUD then	
				renderText(0.542, 0.918, 0.015, string.format("Brak sznurka"));
			end;
		end;
	--end;
end;