-----
---------------HEDER DO BIZONA BS Z110
-----------BY MAJSTER2009
-------------->>>>>WSZELKIE PRAWA ZASTRZEONE <<<<<<<-----------------
------www.poladmod.r32.pl

heder_bs = {};

function heder_bs.prerequisitesPresent(specializations)
    return true;
end;

function heder_bs:load(xmlFile)

    self.setReelSpeed = SpecializationUtil.callSpecializationsFunction("setReelSpeed");
    self.onStartReel = SpecializationUtil.callSpecializationsFunction("onStartReel");
    self.onStopReel = SpecializationUtil.callSpecializationsFunction("onStopReel");
    self.isReelStarted = heder_bs.isReelStarted;
    self.resetFruitType = SpecializationUtil.callSpecializationsFunction("resetFruitType");
    self.setFruitType = SpecializationUtil.callSpecializationsFunction("setFruitType");

    self.reelNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.reel#index"));

    self.rollNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.roll#index"));

    local indexSpikesStr = getXMLString(xmlFile, "vehicle.reelspikes#index");
    self.spikesCount = getXMLInt(xmlFile, "vehicle.reelspikes#count");
    self.spikesRootNode = Utils.indexToObject(self.components, indexSpikesStr);

    self.sideArm = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.sidearms#index"));
    self.sideArmMovable = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.sidearms#movable"), false);

    self.threshingParticleSystems = {};
    local psName = "vehicle.threshingParticleSystem";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems, psName, self.components, false, nil, self.baseDirectory)

    self.fruitExtraObjects = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.fruitExtraObjects.fruitExtraObject(%d)", i);
        local t = getXMLString(xmlFile, key.."#fruitType");
        local index = getXMLString(xmlFile, key.."#index");
        if t==nil or index==nil then
            break;
        end;

        local node = Utils.indexToObject(self.components, index);
        if node ~= nil then
            if self.currentExtraObject == nil then
                self.currentExtraObject = node;
                setVisibility(node, true);
            else
                setVisibility(node, false);
            end;
            self.fruitExtraObjects[t] = node;
        end;
        i = i +1;
    end;

    self.preferedCombineSize = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.preferedCombineSize"), 1);

    self.fruitTypes = {};
    self.fruitTypes[FruitUtil.FRUITTYPE_UNKNOWN] = true;
    local fruitTypes = getXMLString(xmlFile, "vehicle.fruitTypes#fruitTypes");
    if fruitTypes ~= nil then
        local types = Utils.splitString(" ", fruitTypes);
        for k,v in pairs(types) do
            local desc = FruitUtil.fruitTypes[v];
            if desc ~= nil then
                self.fruitTypes[desc.index] = true;
            end;
        end;
    end;

    self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;

    self.reelStarted = false;

    self.forceLowSpeed = false;
    self.speedLimitLow = 12;
    self.speedLimit = 17.5;

    self.speedViolationMaxTime = 50;
    self.speedViolationTimer = self.speedViolationMaxTime;
    self.printRainWarning = false;


    self.lastArea = 0;

	
	
	---------------------------TLOKI-------------------------
	local tlok2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tlok2#index"));
		if tlok2Node ~= nil then
        self.tlok2 = {};
        self.tlok2.node = tlok2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tlok2#minRot"));
        self.tlok2.minRot = {};
        self.tlok2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tlok2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tlok2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tlok2#maxRot"));
        self.tlok2.maxRot = {};
        self.tlok2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tlok2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tlok2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tlok2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tlok2#rotTime"), 2)*1000;
        self.tlok2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tlok2#touchRotLimit"), 10));
    end;
	
			local tlokNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tlok#index"));
		if tlokNode ~= nil then
        self.tlok = {};
        self.tlok.node = tlokNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tlok#minRot"));
        self.tlok.minRot = {};
        self.tlok.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tlok.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tlok.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tlok#maxRot"));
        self.tlok.maxRot = {};
        self.tlok.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tlok.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tlok.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tlok.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tlok#rotTime"), 2)*1000;
        self.tlok.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tlok#touchRotLimit"), 10));
    end;
--------------END----------------------
	--------RAMIONA---------------------
		local ramionaNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ramiona#index"));
		if ramionaNode ~= nil then
        self.ramiona = {};
        self.ramiona.node = ramionaNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ramiona#minRot"));
        self.ramiona.minRot = {};
        self.ramiona.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ramiona.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ramiona.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ramiona#maxRot"));
        self.ramiona.maxRot = {};
        self.ramiona.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ramiona.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ramiona.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.ramiona.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ramiona#rotTime"), 2)*1000;
        self.ramiona.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ramiona#touchRotLimit"), 10));
    end;
	-------END------------
------------KOSA-------------------
	local translationPartNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kosa#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kosa#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kosa#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kosa2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kosa2#touchTransLimit"), 10);
    end;
	local translationPartNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kosa2#index"));
    if translationPartNode3 ~= nil then
        self.translationPart3 = {};
        self.translationPart3.node = translationPartNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kosa2#minTrans"));
        self.translationPart3.minTrans = {};
        self.translationPart3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kosa2#maxTrans"));
        self.translationPart3.maxTrans = {};
        self.translationPart3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kosa2#transTime"), 2)*1000;
        self.translationPart3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kosa2#touchTransLimit"), 10);
    end;
-------------END--------------
-----------WYSUWNIE MOTOWIDEL----------------
	local translationPartNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wysuwanie_motowidel#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wysuwanie_motowidel#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wysuwanie_motowidel#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wysuwanie_motowidel#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wysuwanie_motowidel#touchTransLimit"), 10);
    end;	
-------------END--------------	
	self.controlpath = Utils.getFilename("pomoc2.png", self.baseDirectory);
    self.bshudWidth = 0.356;
    self.bshudHeight = 0.416;
	self.bshudPoxX = -0.045;
    self.bshudPoxY = 1-0.6;
    self.bshudOverlay = Overlay:new("bshudControl", self.controlpath, self.bshudPoxX, self.bshudPoxY, self.bshudWidth, self.bshudHeight);
	
	self.test = 80;

	self.numstols = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.stol#count"), 0);
    self.stols = {};
    for i=1, self.numstols do
        local stolnamei = string.format("vehicle.stol.stol" .. "%d", i);
        self.stols[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, stolnamei .. "#index"));
        setVisibility(self.stols[i], false);
    end;
self.stolvis = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kosa_vis#index"));
self.stolvisActive = false;
self.stolsActive = false;	
end;

function heder_bs:delete()
    Utils.deleteParticleSystem(self.threshingParticleSystems);
end;

function heder_bs:mouseEvent(posX, posY, isDown, isUp, button)
end;

function heder_bs:keyEvent(unicode, sym, modifier, isDown)
----------RAMIONA------------
	if sym == Input.KEY_KP_2 then
		self.ramionaMax = isDown;
		self.tlokMax = isDown;
		self.tlok2Max = isDown;
	end;
	if sym == Input.KEY_KP_8 then
		self.ramionaMin = isDown;
		self.tlokMin = isDown;
		self.tlok2Min = isDown;
	end;	
---------------END---------------
----------WYSUWANIE MOTOWIDEL------------
	if sym == Input.KEY_KP_6 then
		self.translationMax = isDown;
	end;
	if sym == Input.KEY_KP_4 then
		self.translationMin = isDown;
	end;	
---------------END---------------
--------------END----------
   if isDown and sym == Input.KEY_KP_0 then
		self.bcActive = not self.bcActive;
	end;
--------------POMOC------------
----------REGULACJA PREDKOSCI MOTOWIDEL-------------------
	if sym == Input.KEY_KP_1 then 
		self.wolniej = isDown;
	end;
	if sym == Input.KEY_KP_3 then
		self.szybciej = isDown;
	end;
---------------END------------------
   if isDown and sym == Input.KEY_KP_5 then
		self.stolsActive = not self.stolsActive;
		self.stolvisActive = not self.stolvisActive;
	end;
	
end;

function heder_bs:update(dt)

  self.lastArea = 0;
    if self.reelStarted and self.movingDirection < 0 then

        local speedLimit = self.speedLimit;
        if heder_bs.getUseLowSpeedLimit(self) then
            speedLimit = self.speedLimitLow;
        end;

        if self:doCheckSpeedLimit() and self.lastSpeed*3600 > speedLimit then
            self.speedViolationTimer = self.speedViolationTimer - dt;
        else
            self.speedViolationTimer = self.speedViolationMaxTime;
        end;

        if self.speedViolationTimer > 0 then
            if heder_bs.allowThreshing(false) then
                self.printRainWarning = false;

                -- during low fill level new fruit types are allowed to "take over"
                local lowFillLevel = false;
                if self.attacherVehicle ~= nil then
                    if self.attacherVehicle.grainTankFillLevel > 0 and self.attacherVehicle.grainTankFillLevel / self.attacherVehicle.grainTankCapacity <= self.attacherVehicle.minThreshold then
                        lowFillLevel = true;
                    end;
                end;

                local foundFruitType = false;
                local oldFruitType = self.currentFruitType;
                
                local allowsThreshing = true;
                if self.attacherVehicle ~= nil then
                    allowsThreshing = self.attacherVehicle.allowsThreshing;
                end;

                if allowsThreshing then
                    if self.currentFruitType == FruitUtil.FRUITTYPE_UNKNOWN or lowFillLevel then
                        for fruitType,v in pairs(self.fruitTypes) do
                            local isOk = true;
                            if self.attacherVehicle ~= nil then
                                if self.attacherVehicle.allowGrainTankFruitType ~= nil then
                                    isOk = self.attacherVehicle:allowGrainTankFruitType(fruitType);
                                end;
                            end;
                            if isOk then
                                for k,area in pairs(self.cuttingAreas) do
                                    local x,y,z = getWorldTranslation(area.start);
                                    local x1,y1,z1 = getWorldTranslation(area.width);
                                    local x2,y2,z2 = getWorldTranslation(area.height);
                                    local area = Utils.getFruitArea(fruitType, x, z, x1, z1, x2, z2);
                                    if area > 0 then
                                        self.currentFruitType = fruitType;
                                        if self.currentFruitType ~= oldFruitType then
                                            heder_bs.updateExtraObjects(self)
                                            if self.attacherVehicle ~= nil then
                                                self.attacherVehicle:emptyGrainTankIfLowFillLevel();
                                            end;
                                        end;
                                        foundFruitType = true;
                                        break;
                                    end;
                                end;

                                if foundFruitType then
                                    break;
                                end;
                            end;
                        end;
                    end;
                    if self.currentFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
                        local realArea = 0;
                        for k,area in pairs(self.cuttingAreas) do
                            local x,y,z = getWorldTranslation(area.start);
                            local x1,y1,z1 = getWorldTranslation(area.width);
                            local x2,y2,z2 = getWorldTranslation(area.height);
                            Utils.updateFruitCutShortArea(self.currentFruitType, x, z, x1, z1, x2, z2, 1);
                            local area = Utils.cutFruitArea(self.currentFruitType, x, z, x1, z1, x2, z2);
                            if area > 0 then
                                local spray = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.sprayChannel, x, z, x1, z1, x2, z2);
                                local multi = 1;
                                if spray > 0 then
                                    multi = 2;
                                end;
                                self.lastArea = self.lastArea + area*multi;
                                realArea = realArea + area/g_currentMission.maxFruitValue;
                            end;
                        end;
                        local pixelToQm = 2048 / 4096 * 2048 / 4096; -- 4096px are mapped to 2048m
                        local qm = realArea*pixelToQm;
                        local ha = qm/10000;

                        g_currentMission.missionStats.hectaresThreshedTotal = g_currentMission.missionStats.hectaresThreshedTotal + ha;
                        g_currentMission.missionStats.hectaresThreshedSession = g_currentMission.missionStats.hectaresThreshedSession + ha;

                        g_currentMission.missionStats.threshingDurationTotal = g_currentMission.missionStats.threshingDurationTotal + dt/(1000*60);
                        g_currentMission.missionStats.threshingDurationSession= g_currentMission.missionStats.threshingDurationSession + dt/(1000*60);
                    end;
                end;
            else
                self.printRainWarning = true;
            end;
        end;
    else
        self.speedViolationTimer = self.speedViolationMaxTime;
    end;

    Utils.setEmittingState(self.threshingParticleSystems, (self.reelStarted and self.lastArea > 0.0));

    if self.reelStarted then

        rotate(self.rollNode, -dt*self.reelSpeed*3, 0, 0);

        if self.reelNode ~= nil then
            rotate(self.reelNode, -dt*self.reelSpeed, 0, 0);

            if self.sideArmMovable then
                --:TODO: move arm downwards
            end;

            --correct spikes, so that they always look down
            atx, aty, atz = getRotation(self.reelNode);

            for i=1, self.spikesCount do
                local spike    =    getChildAt(self.spikesRootNode, i-1);
                tx, ty, tz = getRotation(spike);
                setRotation(spike, -atx, aty, atz);
            end;
        end;

    end;
------------RAMIONA------------
 local doRotate = self.ramionaMax or self.ramionaMin 
	if self.ramiona ~= nil and doRotate then
        	local x, y, z = getRotation(self.ramiona.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.ramiona.maxRot, self.ramiona.minRot, 3, self.ramiona.rotTime, dt, not self.ramionaMax);
        	setRotation(self.ramiona.node, unpack(newRot));
	end;  
------------END------------
-----------KOSA----------------
	if self.translationMax2 ~= nil then
		local x, y, z = getTranslation(self.translationPart2.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax2);
        setTranslation(self.translationPart2.node, unpack(newTrans));
	end;
	if self.translationMax3 ~= nil then
		local x, y, z = getTranslation(self.translationPart3.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart3.maxTrans, self.translationPart3.minTrans, 3, self.translationPart3.transTime, dt, not self.translationMax3);
        setTranslation(self.translationPart3.node, unpack(newTrans));
	end;
-------------END----------------
--------------RUCH KOSY-----------
	if self.reelStarted then
		self.test = self.test - dt;
		if self.test < 0 then
			self.translationMax2 = not self.translationMax2;
			self.translationMax3 = not self.translationMax3;
			self.test = 80;
		end;

	end;
----------END--------------
-----------WYSUWNIE MOTOWIDEL----------------
	local doTranslate = self.translationMax or self.translationMin
		if self.translationPart ~= nil and doTranslate then
			local x, y, z = getTranslation(self.translationPart.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
			setTranslation(self.translationPart.node, unpack(newTrans));
		end;
-------------END----------------	
-----------PREDKOSC MOTOWIDEL--------------------
if self.szybciej then		
	if self.reelSpeed < 0.005 then
			self.reelSpeed = self.reelSpeed + 0.00001;
		end;	
end;
if self.wolniej then
	if self.reelSpeed > 0.0015 then
			self.reelSpeed = self.reelSpeed - 0.00001;
	end;
end;
----------END--------------------	
---------------------TLOKI----------------
		---------------------------------tlok----------------------------------
 local doRotate = self.tlokMax or self.tlokMin 
	if self.tlok ~= nil and doRotate then
        	local x, y, z = getRotation(self.tlok.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.tlok.maxRot, self.tlok.minRot, 3, self.tlok.rotTime, dt, not self.tlokMax);
        	setRotation(self.tlok.node, unpack(newRot));
	end; 

 local doRotate = self.tlok2Max or self.tlok2Min 
	if self.tlok2 ~= nil and doRotate then
        	local x, y, z = getRotation(self.tlok2.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.tlok2.maxRot, self.tlok2.minRot, 3, self.tlok2.rotTime, dt, not self.tlok2Max);
        	setRotation(self.tlok2.node, unpack(newRot));
	end; 
----------END-----------------

        if self.stolsActive then
		   for i=1, self.numstols do
			local stol = self.stols[i];
			setVisibility(stol, self.wstolsActive);
		   end;
	       else
		   for i=1, self.numstols do
			local stol = self.stols[i];
			setVisibility(stol, self.stolsActive, false);
		   end;
	    end;
		setVisibility(self.stolvis, self.stolvisActive);

end;

function heder_bs:draw()

    if math.abs(self.speedViolationTimer - self.speedViolationMaxTime) > 2 then
        local str = "2";
        local keyStr = InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL2)
        if heder_bs.getUseLowSpeedLimit(self) then
            str = "1";
            keyStr = InputBinding.getButtonKeyName(InputBinding.SPEED_LEVEL1)
        end;
        g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), str, keyStr), 0.07+0.022, 0.019+0.029);
    end;

    if self.printRainWarning then
			g_currentMission:addWarning(g_i18n:getText("Dont_do_threshing_during_rain_or_hail"), 0.018, 0.033);
    end;
	if self.bshudOverlay ~= nil then
			if self.bcActive then
			self.bshudOverlay:render();
			end;
		end;
	
	if self.bcActive then
		setTextColor(1,1,1,1);
		renderText(0.8335, 0.15, 0.02, "NUM 0: Wylacz Pomoc");
	else
		setTextColor(1,1,1,1);
		renderText(0.8335, 0.15, 0.02, "NUM 0: Wlacz Pomoc");
	end;
	
	if self.bcActive then
		
		renderText(0.08, 0.75, 0.027, "-->Heder<--");
		
		renderText(0.051, 0.725, 0.023, "Klawiatura numeryczna");
		
		renderText(0.0525, 0.69, 0.020, "Wsun motowidla: 4");
		renderText(0.0525, 0.67, 0.020, "Wysun motowidla: 6");
		renderText(0.0525, 0.65, 0.020, "Motowidla gora: 8");
		renderText(0.0525, 0.63, 0.020, "Motowidla dol: 2");
		renderText(0.0525, 0.61, 0.020, "- Predkosc motowidel: 1");
		renderText(0.0525, 0.59, 0.020, "+ Predkosc motowidel: 3");
		renderText(0.0525, 0.57, 0.020, "Stol do rzepaku: 5");

	
	end;
end;

function heder_bs:onDetach()
    if self.deactivateOnDetach then
        heder_bs.onDeactivate(self);
    end;
end;

function heder_bs:onLeave()
    if self.deactivateOnLeave then
        heder_bs.onDeactivate(self);
    end;
end;

function heder_bs:onDeactivate()
    self:onStopReel();
    Utils.setEmittingState(self.threshingParticleSystems, false);
    self.speedViolationTimer = self.speedViolationMaxTime;
end;

function heder_bs:setReelSpeed(speed)
    self.reelSpeed = speed;
end;

function heder_bs:onStartReel()
    self.reelStarted = true;
end;

function heder_bs:onStopReel()
    self.reelStarted = false;
    Utils.setEmittingState(self.threshingParticleSystems, false);
    self.speedViolationTimer = self.speedViolationMaxTime;
end;

function heder_bs:isReelStarted()
    return self.reelStarted;
end;

function heder_bs:resetFruitType()
    self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.lastArea = 0;
end;

function heder_bs:setFruitType(fruitType)
    if self.currentFruitType ~= fruitType then
        self.currentFruitType = fruitType;
        self.lastArea = 0;

        heder_bs.updateExtraObjects(self)
    end;
end;

function heder_bs.getUseLowSpeedLimit(self)
    if self.forceLowSpeed or (self.attacherVehicle ~= nil and self.preferedCombineSize > self.attacherVehicle.combineSize) then
        return true;
    end;
    return false;
end;

function heder_bs.updateExtraObjects(self)
    if self.currentExtraObject ~= nil then
        setVisibility(self.currentExtraObject, false);
        self.currentExtraObject = nil;
    end;
    if self.currentFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        local name = FruitUtil.fruitIndexToDesc[self.currentFruitType].name;
        local extraObject = self.fruitExtraObjects[name];
        if extraObject ~= nil then
            setVisibility(extraObject, true);
            self.currentExtraObject = extraObject;
        end;
    end;
end;

function heder_bs.allowThreshing(earlyWarning)
    if early ~= nil and early == true then
        if g_currentMission.environment.lastRainScale <= 0.02 and g_currentMission.environment.timeSinceLastRain > 20 then
            return true;
        end;
    else
        if g_currentMission.environment.lastRainScale <= 0.1 and g_currentMission.environment.timeSinceLastRain > 20 then
            return true;
        end;
    end;
    return false;
end;
