-- tarcsa
-- Class for all tarcsa
--
-- @author  Acid_Burn84 & surci HUN to LS2011
-- @date  23/12/10

tarcsa = {};

function tarcsa.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;
function tarcsa:load(xmlFile)
self.aiTerrainDetailChannel1 = g_currentMission.sowingChannel; 
self.aiTerrainDetailChannel2 = g_currentMission.cultivatorChannel; 
self.safeMode = true
            print("'lua loaded '" );	
	
	self.drumNodeLeft1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index1"));
	self.drumNodeLeft2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index2"));
	self.drumNodeLeft3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index3"));
	self.drumNodeRight1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index4"));
	self.drumNodeRight2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index5"));
	self.drumNodeRight3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.drum#index6"));
	self.drumRotationScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.drum#rotationScale"), 1);
   
	
	local rotationPartNodeRight = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartRight#index"));
    if rotationPartNodeRight ~= nil then
        self.rotationPartRight = {};
        self.rotationPartRight.node = rotationPartNodeRight;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#minRot"));
        self.rotationPartRight.minRot = {};
        self.rotationPartRight.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartRight#maxRot"));
        self.rotationPartRight.maxRot = {};
        self.rotationPartRight.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartRight.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartRight.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartRight.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#rotTime"), 2)*1000;
        self.rotationPartRight.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartRight#touchRotLimit"), 10));
    end;
	
	
	local rotationPartNodeLeft = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartLeft#index"));
    if rotationPartNodeLeft ~= nil then
        self.rotationPartLeft = {};
        self.rotationPartLeft.node = rotationPartNodeLeft;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#minRot"));
        self.rotationPartLeft.minRot = {};
        self.rotationPartLeft.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartLeft#maxRot"));
        self.rotationPartLeft.maxRot = {};
        self.rotationPartLeft.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartLeft.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartLeft.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartLeft.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#rotTime"), 2)*1000;
        self.rotationPartLeft.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartLeft#touchRotLimit"), 10));
    end;
	
	
	local translationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart#touchTransLimit"), 10);
    end;
	
	local translationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart2#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart2#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart2#touchTransLimit"), 10);
    end;
	
	local translationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.translationPart3#index"));
    if translationPartNode3 ~= nil then
        self.translationPart3 = {};
        self.translationPart3.node = translationPartNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#minTrans"));
        self.translationPart3.minTrans = {};
        self.translationPart3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.translationPart3#maxTrans"));
        self.translationPart3.maxTrans = {};
        self.translationPart3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#transTime"), 2)*1000;
        self.translationPart3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.translationPart3#touchTransLimit"), 10);
    end;

	self.threshingParticleSystems1 = {};
    local psName = "vehicle.threshingParticleSystem1";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems1, psName, self.rootNode, false)
	
	self.threshingParticleSystems2 = {};
    local psName = "vehicle.threshingParticleSystem2";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems2, psName, self.rootNode, false)
	
	self.threshingParticleSystems3 = {};
    local psName = "vehicle.threshingParticleSystem3";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems3, psName, self.rootNode, false)
	
	self.threshingParticleSystems4 = {};
    local psName = "vehicle.threshingParticleSystem4";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems4, psName, self.rootNode, false)
	
	self.threshingParticleSystems5 = {};
    local psName = "vehicle.threshingParticleSystem5";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems5, psName, self.rootNode, false)
	
	self.threshingParticleSystems6 = {};
    local psName = "vehicle.threshingParticleSystem6";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems6, psName, self.rootNode, false)
	
	self.threshingParticleSystems7 = {};
    local psName = "vehicle.threshingParticleSystem7";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems7, psName, self.rootNode, false)
	
	self.threshingParticleSystems8 = {};
    local psName = "vehicle.threshingParticleSystem8";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems8, psName, self.rootNode, false)
	
	self.threshingParticleSystems9 = {};
    local psName = "vehicle.threshingParticleSystem9";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems9, psName, self.rootNode, false)
	
	self.threshingParticleSystems10 = {};
    local psName = "vehicle.threshingParticleSystem10";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems10, psName, self.rootNode, false)
	
	self.threshingParticleSystems11 = {};
    local psName = "vehicle.threshingParticleSystem11";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems11, psName, self.rootNode, false)
	
	self.threshingParticleSystems12 = {};
    local psName = "vehicle.threshingParticleSystem12";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems12, psName, self.rootNode, false)
	
	self.threshingParticleSystems13 = {};
    local psName = "vehicle.threshingParticleSystem13";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems13, psName, self.rootNode, false)
	
	self.threshingParticleSystems14 = {};
    local psName = "vehicle.threshingParticleSystem14";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems14, psName, self.rootNode, false)
	
	self.threshingParticleSystems15 = {};
    local psName = "vehicle.threshingParticleSystem15";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems15, psName, self.rootNode, false)
	
	self.threshingParticleSystems16 = {};
    local psName = "vehicle.threshingParticleSystem16";
    Utils.loadParticleSystem(xmlFile, self.threshingParticleSystems16, psName, self.rootNode, false)	
 
	self.rotationMaxRight = true;
	self.rotationMaxLeft = true;
    self.translationMax2 = true;
	self.translationMax3 = false;
end;

function tarcsa:delete()
end;


function tarcsa:mouseEvent(posX, posY, isDown, isUp, button)
end;

function tarcsa:keyEvent(unicode, sym, modifier, isDown)
	
	if sym == Input.KEY_k then
		print("max")
		self.translationMax = isDown;
	end;
	if sym == Input.KEY_m then
		print("min")
		self.translationMin = isDown;
	end;
	
	if isDown and sym == Input.KEY_b then
		self.rotationMaxRight = not self.rotationMaxRight;
		self.rotationMaxLeft = not self.rotationMaxLeft;
	end;
	
	if isDown and sym == Input.KEY_n then
		self.translationMax2 = not self.translationMax2;
	end;	
end;


function tarcsa:update(dt)
	
	if self.attacherVehicle then
	
		self.isExpandedRight = false;
        if self.rotationPartRight ~= nil then
            local x, y, z = getRotation(self.rotationPartRight.node);
            local minRot = self.rotationPartRight.minRot;
            local eps = self.rotationPartRight.touchRotLimit;

            if math.abs(x-minRot[1]) < eps and math.abs(y-minRot[2]) < eps and math.abs(z-minRot[3]) < eps then
                self.isExpandedRight = true;
            end;
        end;
		
		self.translationMax3 = true;
		
		if  self.translationMax2 then
		
		
		
			Utils.setEmittingState(self.threshingParticleSystems1, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems2, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems3, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems4, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems5, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems6, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems7, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems8, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems9, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems10, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems11, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems12, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems13, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems14, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems15, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			Utils.setEmittingState(self.threshingParticleSystems16, (self.attacherVehicle.lastSpeed*3600 > 2 ));
			
			if self.drumNodeLeft1 ~= nil then
				rotate(self.drumNodeLeft1, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
			if self.drumNodeLeft2 ~= nil then
				rotate(self.drumNodeLeft2, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
			if self.drumNodeLeft3 ~= nil then
				rotate(self.drumNodeLeft3, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
			if self.drumNodeRight1 ~= nil then
				rotate(self.drumNodeRight1, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
			if self.drumNodeRight2 ~= nil then
				rotate(self.drumNodeRight2, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
			if self.drumNodeRight3 ~= nil then
				rotate(self.drumNodeRight3, self.drumRotationScale * self.attacherVehicle.lastSpeed * self.attacherVehicle.movingDirection, 0, 0);
			end;
			
			if table.getn(self.cuttingAreas) > 0 then
				local x,y,z = getWorldTranslation(self.cuttingAreas[1].start);
				local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[1].width);
				local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[1].height);
				Utils.updateCultivatorArea(x, z, x1, z1, x2, z2);
			end;
		
			if table.getn(self.cuttingAreas) > 0 then
				local x,y,z = getWorldTranslation(self.cuttingAreas[2].start);
				local x1,y1,z1 = getWorldTranslation(self.cuttingAreas[2].width);
				local x2,y2,z2 = getWorldTranslation(self.cuttingAreas[2].height);
				Utils.updateCultivatorArea(x, z, x1, z1, x2, z2);
			end;
		
		end;	
	
		if self.translationMax2 and self.isExpandedRight and self.attacherVehicle.lastSpeed*3600 > 2 then
			if not self.workSoundRunning then
                print("start");
                playSample(self.workSound, 0, 1.6, 0);
                self.workSoundRunning = true;
			end;
		end;
		
		if not self.translationMax2 or not self.isExpandedRight or self.attacherVehicle.lastSpeed*3600 < 2 then
			if self.workSoundRunning then
                print("end");
                stopSample(self.workSound, 0, 1.6, 0);
                self.workSoundRunning = false;
			end;
			
			Utils.setEmittingState(self.threshingParticleSystems1, false);
			Utils.setEmittingState(self.threshingParticleSystems2, false);
			Utils.setEmittingState(self.threshingParticleSystems3, false);
			Utils.setEmittingState(self.threshingParticleSystems4, false);
			Utils.setEmittingState(self.threshingParticleSystems5, false);
			Utils.setEmittingState(self.threshingParticleSystems6, false);
			Utils.setEmittingState(self.threshingParticleSystems7, false);
			Utils.setEmittingState(self.threshingParticleSystems8, false);
			Utils.setEmittingState(self.threshingParticleSystems9, false);
			Utils.setEmittingState(self.threshingParticleSystems10, false);
			Utils.setEmittingState(self.threshingParticleSystems11, false);
			Utils.setEmittingState(self.threshingParticleSystems12, false);
			Utils.setEmittingState(self.threshingParticleSystems13, false);
			Utils.setEmittingState(self.threshingParticleSystems14, false);
			Utils.setEmittingState(self.threshingParticleSystems15, false);
			Utils.setEmittingState(self.threshingParticleSystems16, false);
		end;
	end;
	
		
	local doTranslate = self.translationMax or self.translationMin
		if self.translationPart ~= nil and doTranslate then
	
        local x, y, z = getTranslation(self.translationPart.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
        setTranslation(self.translationPart.node, unpack(newTrans));
		end;

	if self.rotationPartRight ~= nil then
        local x, y, z = getRotation(self.rotationPartRight.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartRight.maxRot, self.rotationPartRight.minRot, 3, self.rotationPartRight.rotTime, dt, not self.rotationMaxRight);
        setRotation(self.rotationPartRight.node, unpack(newRot));
    end;

    if self.rotationPartLeft ~= nil then
        local x, y, z = getRotation(self.rotationPartLeft.node);
        local rot = {x,y,z};
        local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartLeft.maxRot, self.rotationPartLeft.minRot, 3, self.rotationPartLeft.rotTime, dt, not self.rotationMaxLeft);
        setRotation(self.rotationPartLeft.node, unpack(newRot));
    end;
	
	if self.translationMax2 ~= nil then
		local x, y, z = getTranslation(self.translationPart2.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax2);
        setTranslation(self.translationPart2.node, unpack(newTrans));
	end;
	
	if self.translationMax3 ~= nil then
		local x, y, z = getTranslation(self.translationPart3.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart3.maxTrans, self.translationPart3.minTrans, 3, self.translationPart3.transTime, dt, not self.translationMax3);
        setTranslation(self.translationPart3.node, unpack(newTrans));
	end;
end;

function tarcsa:draw()
if self.safeMode then 
g_currentMission: addHelpButtonText ("switch to normal mode", InputBinding.IMPLEMENT_EXTRA3); 
else 
g_currentMission: addHelpButtonText ("switch to safe mode", InputBinding.IMPLEMENT_EXTRA3); 
end; 
	
	if self.translationMax2 then
		g_currentMission:addExtraPrintText("N gomb: MW KVTB felemel");
	else
		g_currentMission:addExtraPrintText("N gomb: MW KVTB leenged");
	end;
	
end;




