 

belarus = {};

function belarus.prerequisitesPresent(specializations)
    Vehicle.registerJointType("frontloader");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function belarus:load(xmlFile)
      
    self.ventiNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.venti#index"));
    self.backcamera = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backcamera#index"));
    self.numWorklights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.worklights#count"), 0);
    self.worklights = {};
    for i=1, self.numWorklights do
        local worklightnamei = string.format("vehicle.worklights.worklight" .. "%d", i);
        self.worklights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, worklightnamei .. "#index"));
        setVisibility(self.worklights[i], false);
    end;	
	
    self.numbrakelights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.brakelights#count"), 0);
    self.brakelights = {};
    for i=1, self.numbrakelights do
        local brakelightnamei = string.format("vehicle.brakelights.brakelight" .. "%d", i);
        self.brakelights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, brakelightnamei .. "#index"));
        setVisibility(self.brakelights[i], false);
    end;
    self.brakelightsActive = false;
    self.worklightsActive = false;
    self.help = false;
    self.braking = false;

    local armDownNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armDown#index"));
    if armDownNode ~= nil then
        self.armDown = {};
        self.armDown.node = armDownNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armDown#minRot"));
        self.armDown.minRot = {};
        self.armDown.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armDown.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armDown.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armDown#maxRot"));
        self.armDown.maxRot = {};
        self.armDown.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armDown.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armDown.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armDown.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armDown#rotTime"), 2)*1000;
        self.armDown.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armDown#touchRotLimit"), 10));
    end;

    local armUpNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.armUp#index"));
    if armUpNode ~= nil then
        self.armUp = {};
        self.armUp.node = armUpNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armUp#minRot"));
        self.armUp.minRot = {};
        self.armUp.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armUp.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armUp.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.armUp#maxRot"));
        self.armUp.maxRot = {};
        self.armUp.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.armUp.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.armUp.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.armUp.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.armUp#rotTime"), 2)*1000;
        self.armUp.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.armUp#touchRotLimit"), 10));
    end;

    local cylinder1Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cylinder1#index"));
    if cylinder1Node ~= nil then
        self.cylinder1 = {};
        self.cylinder1.node = cylinder1Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder1#minRot"));
        self.cylinder1.minRot = {};
        self.cylinder1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.cylinder1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.cylinder1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder1#maxRot"));
        self.cylinder1.maxRot = {};
        self.cylinder1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.cylinder1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.cylinder1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.cylinder1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder1#rotTime"), 2)*1000;
        self.cylinder1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder1#touchRotLimit"), 10));
    end;

    local cylinder2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.cylinder2#index"));
    if cylinder2Node ~= nil then
        self.cylinder2 = {};
        self.cylinder2.node = cylinder2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder2#minTrans"));
        self.cylinder2.minTrans = {};
        self.cylinder2.minTrans[1] = Utils.getNoNil(x, 0);
        self.cylinder2.minTrans[2] = Utils.getNoNil(y, 0);
        self.cylinder2.minTrans[3] = Utils.getNoNil(z, 0);
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cylinder2#maxTrans"));
        self.cylinder2.maxTrans = {};
        self.cylinder2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.cylinder2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.cylinder2.maxTrans[3] = Utils.getNoNil(z, 0);
        self.cylinder2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder2#transTime"), 2)*1000;
        self.cylinder2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.cylinder2#touchTransLimit"), 10);
    end;

    local rotBraceNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotBrace#index"));
    if rotBraceNode ~= nil then
        self.rotBrace = {};
        self.rotBrace.node = rotBraceNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace#minRot"));
        self.rotBrace.minRot = {};
        self.rotBrace.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotBrace#maxRot"));
        self.rotBrace.maxRot = {};
        self.rotBrace.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotBrace.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotBrace.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
        self.rotBrace.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace#rotTime"), 2)*1000;
        self.rotBrace.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotBrace#touchRotLimit"), 10));
    end;
    
    local rotationPartNodebackwindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.backwindow#index"));
    if rotationPartNodebackwindow ~= nil then
        self.rotationPartbackwindow = {};
        self.rotationPartbackwindow.node = rotationPartNodebackwindow;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.backwindow#minRot"));
        self.rotationPartbackwindow.minRot = {};
        self.rotationPartbackwindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.backwindow#maxRot"));
        self.rotationPartbackwindow.maxRot = {};
        self.rotationPartbackwindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbackwindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#rotTime"), 2)*1000;
        self.rotationPartbackwindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.backwindow#touchRotLimit"), 10));
    end;

    local rotationPartNoderightdoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rightdoor#index"));
    if rotationPartNoderightdoor ~= nil then
        self.rotationPartrightdoor = {};
        self.rotationPartrightdoor.node = rotationPartNoderightdoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#minRot"));
        self.rotationPartrightdoor.minRot = {};
        self.rotationPartrightdoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor#maxRot"));
        self.rotationPartrightdoor.maxRot = {};
        self.rotationPartrightdoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightdoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#rotTime"), 2)*1000;
        self.rotationPartrightdoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor#touchRotLimit"), 10));
    end;

    local rotationPartNoderightdoor1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rightdoor1#index"));
    if rotationPartNoderightdoor1 ~= nil then
        self.rotationPartrightdoor1 = {};
        self.rotationPartrightdoor1.node = rotationPartNoderightdoor1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor1#minRot"));
        self.rotationPartrightdoor1.minRot = {};
        self.rotationPartrightdoor1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rightdoor1#maxRot"));
        self.rotationPartrightdoor1.maxRot = {};
        self.rotationPartrightdoor1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartrightdoor1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartrightdoor1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartrightdoor1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor1#rotTime"), 2)*1000;
        self.rotationPartrightdoor1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rightdoor1#touchRotLimit"), 10));
    end;
	
    local rotationPartNodeleftDoor = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftDoor#index"));
    if rotationPartNodeleftDoor ~= nil then
        self.rotationPartleftDoor = {};
        self.rotationPartleftDoor.node = rotationPartNodeleftDoor;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#minRot"));
        self.rotationPartleftDoor.minRot = {};
        self.rotationPartleftDoor.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor#maxRot"));
        self.rotationPartleftDoor.maxRot = {};
        self.rotationPartleftDoor.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftDoor.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#rotTime"), 2)*1000;
        self.rotationPartleftDoor.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor#touchRotLimit"), 10));
    end;

    local rotationPartNodeleftDoor1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.leftDoor1#index"));
    if rotationPartNodeleftDoor1 ~= nil then
        self.rotationPartleftDoor1 = {};
        self.rotationPartleftDoor1.node = rotationPartNodeleftDoor1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor1#minRot"));
        self.rotationPartleftDoor1.minRot = {};
        self.rotationPartleftDoor1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.leftDoor1#maxRot"));
        self.rotationPartleftDoor1.maxRot = {};
        self.rotationPartleftDoor1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartleftDoor1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartleftDoor1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartleftDoor1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor1#rotTime"), 2)*1000;
        self.rotationPartleftDoor1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.leftDoor1#touchRotLimit"), 10));
    end;

    local rotationPartNodeteto = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.teto#index"));
    if rotationPartNodeteto ~= nil then
        self.rotationPartteto = {};
        self.rotationPartteto.node = rotationPartNodeteto;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.teto#minRot"));
        self.rotationPartteto.minRot = {};
        self.rotationPartteto.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.teto#maxRot"));
        self.rotationPartteto.maxRot = {};
        self.rotationPartteto.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartteto.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartteto.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartteto.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#rotTime"), 2)*1000;
        self.rotationPartteto.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.teto#touchRotLimit"), 10));
    end;

    local rotationPartNodemteto = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.mteto#index"));
    if rotationPartNodemteto ~= nil then
        self.rotationPartmteto = {};
        self.rotationPartmteto.node = rotationPartNodemteto;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.mteto#minRot"));
        self.rotationPartmteto.minRot = {};
        self.rotationPartmteto.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmteto.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmteto.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.mteto#maxRot"));
        self.rotationPartmteto.maxRot = {};
        self.rotationPartmteto.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartmteto.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartmteto.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartmteto.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.mteto#rotTime"), 2)*1000;
        self.rotationPartmteto.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.mteto#touchRotLimit"), 10));
    end;

    local rotationPartNodeabl1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl1#index"));
    if rotationPartNodeabl1 ~= nil then
        self.rotationPartabl1 = {};
        self.rotationPartabl1.node = rotationPartNodeabl1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rabl1#minRot"));
        self.rotationPartabl1.minRot = {};
        self.rotationPartabl1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl1#maxRot"));
        self.rotationPartabl1.maxRot = {};
        self.rotationPartabl1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#rotTime"), 2)*1000;
        self.rotationPartabl1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl1#touchRotLimit"), 10));
    end;

    local rotationPartNodeabl2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.abl2#index"));
    if rotationPartNodeabl2 ~= nil then
        self.rotationPartabl2 = {};
        self.rotationPartabl2.node = rotationPartNodeabl2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl2#minRot"));
        self.rotationPartabl2.minRot = {};
        self.rotationPartabl2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.abl2#maxRot"));
        self.rotationPartabl2.maxRot = {};
        self.rotationPartabl2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartabl2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartabl2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartabl2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#rotTime"), 2)*1000;
        self.rotationPartabl2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.abl2#touchRotLimit"), 10));
    end;

	turn1SoundFile = Utils.getFilename("Sounds/turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("Sounds/turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
	
    self.numTurnlights = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights#count"), 0);
    self.turnlights = {};
    for i=1, self.numTurnlights do
        local turnlightnamei = string.format("vehicle.turnlights.turnlight" .. "%d", i);
        self.turnlights[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei .. "#index"));
        setVisibility(self.turnlights[i], false);
    end;	
	self.turnlightsActive = false;
	
    self.numTurnlights2 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.turnlights2#count"), 0);
    self.turnlights2 = {};
    for i=1, self.numTurnlights2 do
        local turnlightnamei2 = string.format("vehicle.turnlights2.turnlight" .. "%d", i);
        self.turnlights2[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, turnlightnamei2 .. "#index"));
        setVisibility(self.turnlights2[i], false);
    end;	
	self.turnlightsActive2 = false;

end;

function belarus:delete()
   
end;


function belarus:mouseEvent(posX, posY, isDown, isUp, button)

end;

function belarus:keyEvent(unicode, sym, modifier, isDown)

    if sym == Input.KEY_pageup then
	self.armDownMax = isDown;
	self.armUpMax = isDown;
	self.cylinder1Max = isDown;
	self.rotBraceMax = isDown;
	self.cylinder2Max = isDown;
    end;
    if sym == Input.KEY_pagedown then
	self.armDownMin = isDown;
	self.armUpMin = isDown;
	self.cylinder1Min = isDown;
	self.rotBraceMin = isDown;
	self.cylinder2Min = isDown;
    end;

    if isDown and sym == Input.KEY_0 then
	self.help = not self.help;
    end;
    if isDown and sym == Input.KEY_5 then
	self.worklightsActive = not self.worklightsActive;
    end;
    if isDown and sym == Input.KEY_KP_5 then 
	self.rotationMaxbackwindow = not self.rotationMaxbackwindow;
    end; 
    if isDown and sym == Input.KEY_KP_9 then 
	self.rotationMaxrightdoor = not self.rotationMaxrightdoor;
	self.rotationMaxrightdoor1 = not self.rotationMaxrightdoor1;
    end; 
    if isDown and sym == Input.KEY_KP_7 then 
	self.rotationMaxleftDoor = not self.rotationMaxleftDoor;
	self.rotationMaxleftDoor1 = not self.rotationMaxleftDoor1;
    end; 
    if isDown and sym == Input.KEY_KP_8 then 
	self.rotationMaxteto = not self.rotationMaxteto;
    end;
    if isDown and sym == Input.KEY_KP_3 then 
	self.rotationMaxmteto = not self.rotationMaxmteto;
    end;
    if isDown and sym == Input.KEY_KP_6 then 
	self.rotationMaxabl1 = not self.rotationMaxabl1;
    end;
    if isDown and sym == Input.KEY_KP_4 then 
	self.rotationMaxabl2 = not self.rotationMaxabl2;
    end;
--[[Blinker Rechts]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_f2 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.turnlightsActive2 = false;
		self.flashWarner = false;
	end;
--[[Warnblinker]]------------------------------------------------------------	
	if isDown and sym == Input.KEY_f3 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
--[[Blinker Links]]-----------------------------------------------------------
	if isDown and sym == Input.KEY_f4 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.turnlightsActive = false;
		self.flashWarner = false;
	end;	
--[[Blinker ende]]------------------------------------------------------------


end;


function belarus:update(dt)

    if self.isEntered then

        if Input.isKeyPressed(Input.KEY_shift) and self.camIndex == 2 then
                setCamera(self.backcamera);
       	end;

	if self.ventiNode ~= nil then
         	rotate(self.ventiNode, 0, 0, self.motor.lastMotorRpm*dt);
    	end;

	local doRotate = self.armUpMax or self.armUpMin 
	if self.armUp ~= nil and doRotate then
		local x, y, z = getRotation(self.armUp.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.armUp.maxRot, self.armUp.minRot, 3, self.armUp.rotTime, dt, not self.armUpMax);
		setRotation(self.armUp.node, unpack(newRot));
	end;

	local doRotate = self.armDownMax or self.armDownMin 
	if self.armDown ~= nil and doRotate then
        	local x, y, z = getRotation(self.armDown.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.armDown.maxRot, self.armDown.minRot, 3, self.armDown.rotTime, dt, not self.armDownMax);
        	setRotation(self.armDown.node, unpack(newRot));
	end;

	local doRotate = self.cylinder1Max or self.cylinder1Min 
	if self.cylinder1 ~= nil and doRotate then
		local x, y, z = getRotation(self.cylinder1.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.cylinder1.maxRot, self.cylinder1.minRot, 3, self.cylinder1.rotTime, dt, not self.cylinder1Max);
		setRotation(self.cylinder1.node, unpack(newRot));
	end;

	local doTranslate = self.cylinder2Max or self.cylinder2Min 
	if self.cylinder2 ~= nil and doTranslate then 
		local x, y, z = getTranslation(self.cylinder2.node); 
		local trans = {x,y,z}; 
		local newTrans = Utils.getMovedLimitedValues(trans, self.cylinder2.maxTrans, self.cylinder2.minTrans, 3, self.cylinder2.transTime, dt, not self.cylinder2Max); 
		setTranslation(self.cylinder2.node, unpack(newTrans)); 
	end;

	local doRotate = self.rotBraceMax or self.rotBraceMin 
	if self.rotBrace ~= nil and doRotate then
		local x, y, z = getRotation(self.rotBrace.node);		
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotBrace.maxRot, self.rotBrace.minRot, 3, self.rotBrace.rotTime, dt, not self.rotBraceMax);
		setRotation(self.rotBrace.node, unpack(newRot));
	end;
	
	if self.rotationPartbackwindow ~= nil then
		   local x, y, z = getRotation(self.rotationPartbackwindow.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbackwindow.maxRot, self.rotationPartbackwindow.minRot, 3, self.rotationPartbackwindow.rotTime, dt, not self.rotationMaxbackwindow);
		   setRotation(self.rotationPartbackwindow.node, unpack(newRot));
        end;

        if self.rotationPartleftDoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftDoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftDoor.maxRot, self.rotationPartleftDoor.minRot, 3, self.rotationPartleftDoor.rotTime, dt, not self.rotationMaxleftDoor);
		   setRotation(self.rotationPartleftDoor.node, unpack(newRot));
        end;

        if self.rotationPartleftDoor1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartleftDoor1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartleftDoor1.maxRot, self.rotationPartleftDoor1.minRot, 3, self.rotationPartleftDoor1.rotTime, dt, not self.rotationMaxleftDoor1);
		   setRotation(self.rotationPartleftDoor1.node, unpack(newRot));
        end;
    
       if self.rotationPartteto ~= nil then
		   local x, y, z = getRotation(self.rotationPartteto.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartteto.maxRot, self.rotationPartteto.minRot, 3, self.rotationPartteto.rotTime, dt, not self.rotationMaxteto);
		   setRotation(self.rotationPartteto.node, unpack(newRot));
        end;

       if self.rotationPartmteto ~= nil then
		   local x, y, z = getRotation(self.rotationPartmteto.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartmteto.maxRot, self.rotationPartmteto.minRot, 3, self.rotationPartmteto.rotTime, dt, not self.rotationMaxmteto);
		   setRotation(self.rotationPartmteto.node, unpack(newRot));
        end;
        
	if self.rotationPartrightdoor ~= nil then
		   local x, y, z = getRotation(self.rotationPartrightdoor.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightdoor.maxRot, self.rotationPartrightdoor.minRot, 3, self.rotationPartrightdoor.rotTime, dt, not self.rotationMaxrightdoor);
		   setRotation(self.rotationPartrightdoor.node, unpack(newRot));
        end;

	if self.rotationPartrightdoor1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartrightdoor1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartrightdoor1.maxRot, self.rotationPartrightdoor1.minRot, 3, self.rotationPartrightdoor1.rotTime, dt, not self.rotationMaxrightdoor1);
		   setRotation(self.rotationPartrightdoor1.node, unpack(newRot));
        end;

	if self.rotationPartabl1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl1.maxRot, self.rotationPartabl1.minRot, 3, self.rotationPartabl1.rotTime, dt, not self.rotationMaxabl1);
		   setRotation(self.rotationPartabl1.node, unpack(newRot));
        end;
        if self.rotationPartabl2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartabl2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartabl2.maxRot, self.rotationPartabl2.minRot, 3, self.rotationPartabl2.rotTime, dt, not self.rotationMaxabl2);
		   setRotation(self.rotationPartabl2.node, unpack(newRot));
        end;

        if self.worklightsActive then
		   for i=1, self.numWorklights do
		   local worklight = self.worklights[i];
		   setVisibility(worklight, self.worklightsActive);
		end;
	else
		for i=1, self.numWorklights do
			local worklight = self.worklights[i];
			setVisibility(worklight, self.worklightsActive, false);
		end;
	end;

--[[Blinker start]]------------------------------------------------------------
	    if self.flash then
		    if self.delayOn >= 0 then
			    self.delayOn = self.delayOn -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOn < 0 then
				    self.delayOff = 500;
				    self.flashlightsRightActive = true;
				    self.flashlightsLeftActive = true;
			    	self.flashlightsWarnerActive = true;
				    self.turnlightsActive2 = true;
			    	self.turnlightsActive = true;
				    playSample(self.turn1, 1, 0.7, 0);
			    end;
		    end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.turnlightsActive2 = false;
				self.turnlightsActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	  end;

	    if self.flashRight then
		    if self.delayOnRight >= 0 then
			    self.delayOnRight = self.delayOnRight -dt;
		    end;
		    if not self.flashlightsRightActive then
			    if self.delayOnRight < 0 then
				    self.delayOffRight = 500;
				    self.flashlightsRightActive = true;
				    self.turnlightsActive2 = true;
				    playSample(self.turn1,1,0.7,0);
			    end;
		    end;
		    if self.delayOffRight >= 0 then
			   self.delayOffRight = self.delayOffRight -dt;
		    end;
		    if self.flashlightsRightActive then
			    if self.delayOffRight < 0 then
				    self.delayOnRight = 500;
				    self.flashlightsRightActive = false;
				    self.turnlightsActive2 = false;
				    playSample(self.turn2,1,0.7,0);
			    end;
		    end;
	    else
		    if not self.flashWarner then
			    self.turnlightsActive2 = false;
		    end;
	    end;

		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.turnlightsActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.turnlightsActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.turnlightsActive = false;
			end;
		end;

		if self.turnlightsActive then
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive);
			end;
		else
			for i=1, self.numTurnlights do
				local turnlight = self.turnlights[i];
				setVisibility(turnlight, self.turnlightsActive, false);
			end;
		end;
    	if self.turnlightsActive2 then
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2);
			end;
		else
			for i=1, self.numTurnlights2 do
				local turnlight2 = self.turnlights2[i];
				setVisibility(turnlight2, self.turnlightsActive2, false);
			end;
		end;
	
--[[Blinker ende]]------------------------------------------------------------


    end;

end;

function belarus:draw()

	if not self.help then
            renderText(0.1, 0.985, 0.015, "0: Info be");
        else
            renderText(0.1, 0.985, 0.015, "0: Info ki");
        end;
        
        if self.help then
            		renderText(0.02, 0.18, 0.03, "- Universal 650m -");
            		renderText(0.02, 0.22, 0.02, "F2: semnalizare stanga");
			renderText(0.02, 0.24, 0.02, "F3: avertizare");
			renderText(0.02, 0.26, 0.02, "F4: semnalizare dreapta");
			renderText(0.02, 0.28, 0.02, "Numpad 7: usa deschide/inchide");
			renderText(0.02, 0.30, 0.02, "Numpad 9: geam dreapta deschide/inchide");
			renderText(0.02, 0.32, 0.02, "Numpad 5: geam spate deschide/inchide");
			renderText(0.02, 0.40, 0.02, "Numpad +/-: controlul vitezei");
			renderText(0.02, 0.42, 0.02, "Numpad 3: capota deschide/inchide");
			renderText(0.02, 0.44, 0.02, "PAGEUP/PAGEDOWN: hidraulic jos/sus");
            		renderText(0.02, 0.46, 0.02, "F: faruri fata aprinse/inchise");
            		renderText(0.02, 0.48, 0.02, "5: faruri spate aprinse/inchise");
            		renderText(0.02, 0.50, 0.02, "SHIFT: priveste inapoi");
            		renderText(0.02, 0.52, 0.02, "BAL EGER/JOBB EGER: valtas fel/le");
            		renderText(0.02, 0.54, 0.02, "HOME/END: punctul de mijloc Orszagut / teren");
            		renderText(0.02, 0.56, 0.02, "DELETE: muta cutia de viteze");
            		renderText(0.02, 0.58, 0.02, "SPACE: ambreiaj");
		end;

end;

function belaarus:onEnter()

end;

function belarus:onLeave()

end;

function belarus:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;