-----------------------------------------------------
----------------Specjalizacja do Ursusa--------------
-----------------------------------------------------
-----------------------------------------------------
------------------Author: MajsteR--------------------
-----------------------------------------------------
---- Copyright 2011 MajsteR All Rights Reserved.----
-----------------------------------------------------
-------------- www.majster-mod.xaa.pl ---------------
-----------------------------------------------------
-----------------------------------------------------
--#################################################################################
UrsusNR = {};
--#################################################################################
function UrsusNR.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;
--#################################################################################
function UrsusNR:load(xmlFile)
	
	self.controlpath = Utils.getFilename("pomoc.png", self.baseDirectory);
    self.URhudWidth = 0.36;
    self.URhudHeight = 0.42;
	self.URhudPoxX = -0.03;
    self.URhudPoxY = 1-0.58;
    self.URhudOverlay = Overlay:new("URhudControl", self.controlpath, self.URhudPoxX, self.URhudPoxY, self.URhudWidth, self.URhudHeight);
	
	self.halogenP = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Halogeny#Przedni"));
	self.halogenT = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Halogeny#Tylni"));
	self.halogenTActive = false; 
	self.halogenPActive = false;

	local rotationPartNodebackwindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tylna_szyba#index"));
    if rotationPartNodebackwindow ~= nil then
        self.rotationPartbackwindow = {};
        self.rotationPartbackwindow.node = rotationPartNodebackwindow;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParttylna_szyba#minRot"));
        self.rotationPartbackwindow.minRot = {};
        self.rotationPartbackwindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tylna_szyba#maxRot"));
        self.rotationPartbackwindow.maxRot = {};
        self.rotationPartbackwindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbackwindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tylna_szyba#rotTime"), 2)*1000;
        self.rotationPartbackwindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tylna_szyba#touchRotLimit"), 10));
    end;
	self.rotationMaxbackwindow = false;
	
	local rotationPartNodetloczki = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tloki#index"));
    if rotationPartNodetloczki ~= nil then
        self.rotationParttloczki = {};
        self.rotationParttloczki.node = rotationPartNodetloczki;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParttloki#minRot"));
        self.rotationParttloczki.minRot = {};
        self.rotationParttloczki.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttloczki.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttloczki.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tloki#maxRot"));
        self.rotationParttloczki.maxRot = {};
        self.rotationParttloczki.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttloczki.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttloczki.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParttloczki.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tloki#rotTime"), 2)*1000;
        self.rotationParttloczki.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tloki#touchRotLimit"), 10));
    end;
	self.rotationMaxtloczki = false;

	self.kierunek = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kierunek_lewy#index"));	
	self.kierunekActive = false;
	
    self.kierunek2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kierunek_prawy#index"));	
	self.kierunek2Active = false;
	
    self.kogutAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.kogut#count"),0);
    self.kogutKey = getXMLString(xmlFile, "vehicle.kogut#key");
    self.kogutAn = false;
    self.kogut = {};
    for i=1, self.kogutAnz do
        local objname = string.format("vehicle.kogut.light" .. "%d",i);
        self.kogut[i] = {};
        self.kogut[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.kogut[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.kogut[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.kogut[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.kogut[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.kogut[i].emit and self.kogut[i].source ~= nil then
           setVisibility(self.kogut[i].source, false);
        end;
    end;

	
	
	

	
	
	
	
end;
--#################################################################################
function UrsusNR:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_5 then
		self.halogenPActive = not self.halogenPActive;
	end;

	if isDown and sym == Input.KEY_6 then
		self.halogenTActive = not self.halogenTActive;
	end;	
	
	if isDown and sym == Input.KEY_7 then 
		self.rotationMaxbackwindow = not self.rotationMaxbackwindow;
		self.rotationMaxtloczki = not self.rotationMaxtloczki;
	end;

	if isDown and sym == Input.KEY_0 then
		self.bcActive = not self.bcActive;
	end;
	

	if isDown and sym == Input.KEY_KP_6 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.kierunek2Active = false;
		self.flashWarner = false;
	end;
	
	if isDown and sym == Input.KEY_KP_5 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
	
	if isDown and sym == Input.KEY_KP_4 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.kierunekActive = false;
		self.flashWarner = false;
	end;
	    if self.isEntered then
      if self.kogutKey ~= nil then
         if isDown and sym == Input[self.kogutKey] then
           self.kogutAn = not self.kogutAn;
           for i=1, self.kogutAnz do
             setVisibility(self.kogut[i].light, self.kogutAn);
           end;
         end;
      end;
    end;
end;
--#################################################################################
function UrsusNR:update(dt)
	if self.isEntered then
		
		setVisibility(self.halogenP, self.halogenPActive);
		setVisibility(self.halogenT, self.halogenTActive);
  
		if self.rotationPartbackwindow ~= nil then
			local x, y, z = getRotation(self.rotationPartbackwindow.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbackwindow.maxRot, self.rotationPartbackwindow.minRot, 3, self.rotationPartbackwindow.rotTime, dt, not self.rotationMaxbackwindow);
			setRotation(self.rotationPartbackwindow.node, unpack(newRot));
		end;	
	
		if self.rotationParttloczki ~= nil then
			local x, y, z = getRotation(self.rotationParttloczki.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationParttloczki.maxRot, self.rotationParttloczki.minRot, 3, self.rotationParttloczki.rotTime, dt, not self.rotationMaxtloczki);
			setRotation(self.rotationParttloczki.node, unpack(newRot));
		end;	

	end;


	
    if self.kogutAnz > 0 then
      if self.kogutAn then
        for i=1, self.kogutAnz do
          rotate(self.kogut[i].rotNode, 0, dt*self.kogut[i].speed, 0);
        end;
      end;
    end;

	
		

if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashlightsRightActive = true;
				self.flashlightsLeftActive = true;
				self.flashlightsWarnerActive = true;
				self.kierunek2Active = true;
				self.kierunekActive = true;
				playSample(self.turn1, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.kierunek2Active = false;
				self.kierunekActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	end;
	
	if self.flashRight then
		if self.delayOnRight >= 0 then
			self.delayOnRight = self.delayOnRight -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOnRight < 0 then
				self.delayOffRight = 500;
				self.flashlightsRightActive = true;
				self.kierunek2Active = true;
				playSample(self.turn1,1,0.7,0);
			end;
		end;
		if self.delayOffRight >= 0 then
			self.delayOffRight = self.delayOffRight -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOffRight < 0 then
				self.delayOnRight = 500;
				self.flashlightsRightActive = false;
				self.kierunek2Active = false;
				playSample(self.turn2,1,0.7,0);
			end;
		end;
	else
		if not self.flashWarner then
			self.kierunek2Active = false;
		end;
	end;
	
	
		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.kierunekActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.kierunekActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.kierunekActive = false;
			end;
		end;

	

	  setVisibility(self.kierunek, self.kierunekActive);

		setVisibility(self.kierunek2, self.kierunek2Active);

end;		
--#################################################################################		
function UrsusNR:draw()
	
	if self.bcActive then
		setTextBold(true);
		setTextColor(0,1,0,1);
		renderText(0.79, 0.18, 0.022, "Klawisz 0: I-N-F-O On");
	else
		setTextBold(true);
		setTextColor(1,0,0,1);
		renderText(0.79, 0.18, 0.022, "Klawisz 0: I-N-F-O Off");
	end;
	
	if self.URhudOverlay ~= nil then
		if self.bcActive then
			self.URhudOverlay:render();
		end;
	end;
 
	if self.bcActive then
		if self.halogenPActive then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.77, 0.018, "Klawisz 5: Halogeny(P)[On]");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.77, 0.018, "Klawisz 5: Halogeny(P)[Off]");
		end;
  		if self.halogenTActive then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.745, 0.018, "Klawisz 6: Halogeny(T)[On]");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.745, 0.018, "Klawisz 6: Halogeny(T)[Off]");
		end;
	  	if self.rotationMaxbackwindow then
			setTextColor(1,0,0,1);
			renderText(0.05, 0.725, 0.018, "Klawisz 7: Szyba tylna[Off]");
		else
			setTextColor(0,1,0,1);
			renderText(0.05, 0.725, 0.018, "Klawisz 7: Szyba tylna[On]");
		end;
		if self.flash then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.705, 0.018, "Klawisz KP 5: Awaryjne [On]");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.705, 0.018, "Klawisz KP 5: Awaryjne [Off]");
		end;
		if self.flashLeft then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.685, 0.018, "Klawisz KP 6: Kierunek(P) [On]");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.685, 0.018, "Klawisz KP 6: Kierunek(P) [Off]");
		end;
		if self.flashRight then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.665, 0.018, "Klawisz KP 4: Kierunek(L) [On]");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.665, 0.018, "Klawisz KP 4: Kierunek(L) [Off]");
		end;
		if self.kogutAn then
			setTextColor(0,1,0,1);
			renderText(0.05, 0.645, 0.018, "Klawisz 8: Kogut [On]");
		else
			setTextColor(1,0,0,1);
			renderText(0.05, 0.645, 0.018, "Klawisz 8: Kogut [Off]");
		end;
	end;

end;
--#################################################################################
function UrsusNR:onEnter()
    
end;
--#################################################################################
function UrsusNR:onLeave()

	self.halogenTActive = false; 
	self.halogenPActive = false;
	self.kogutAn = false;
    for i=1, self.kogutAnz do
       setVisibility(self.kogut[i].light, self.kogutAn);
    end;

end;
--#################################################################################
function UrsusNR:delete()
end;
--#################################################################################
function UrsusNR:mouseEvent(posX, posY, isDown, isUp, button)
end;
--#################################################################################

