-----------------------------------------------------
----------------Specjalizacja do Ursusa--------------
-----------------------------------------------------
-----------------------------------------------------
------------------Author: MajsteR--------------------
-----------------------------------------------------
---- Copyright 2011 MajsteR All Rights Reserved.----
-----------------------------------------------------
-------------- www.majster-mod.xaa.pl ---------------
-----------------------------------------------------
-----------------------------------------------------
--#################################################################################
Ursus5314 = {};
--#################################################################################
function Ursus5314.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;
--#################################################################################
function Ursus5314:load(xmlFile)
	
	self.controlpath = Utils.getFilename("pomoc.png", self.baseDirectory);
    self.URhudWidth = 0.36;
    self.URhudHeight = 0.42;
	self.URhudPoxX = -0.03;
    self.URhudPoxY = 1-0.58;
    self.URhudOverlay = Overlay:new("URhudControl", self.controlpath, self.URhudPoxX, self.URhudPoxY, self.URhudWidth, self.URhudHeight);
	
	self.halogenT = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Halogeny#tylnie"));
	self.halogenTActive = false;
	self.halogenP = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Halogeny#przednie"));
	self.halogenPActive = false; 
 
 
	self.motorStopSoundVolume2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.motorStopSound#volume"), 1.0);
	local motorMaxRpmStr = getXMLString(xmlFile, "vehicle.motor#maxRpm");
    local motorMaxRpm1, motorMaxRpm2, motorMaxRpm3 = Utils.getVectorFromString(motorMaxRpmStr);
    motorMaxRpm1 = Utils.getNoNil(motorMaxRpm1, 800);
    motorMaxRpm2 = Utils.getNoNil(motorMaxRpm2, 1000);
    motorMaxRpm3 = Utils.getNoNil(motorMaxRpm3, 1800);
    local motorMaxRpm = {motorMaxRpm1, motorMaxRpm2, motorMaxRpm3};
    self.motorMaxRpmLimit = motorMaxRpm;
	
	self.kierunek = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Kierunki#L"));	
	self.kierunekActive = false;
		
    self.kierunek2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Kierunki#P"));	
	self.kierunek2Active = false;

	turn1SoundFile = Utils.getFilename("turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	turn2SoundFile = Utils.getFilename("turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);	
	

end;
--#################################################################################
function Ursus5314:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_5 then
		self.halogenPActive = not self.halogenPActive;
	end;
	if isDown and sym == Input.KEY_6 then
		self.halogenTActive = not self.halogenTActive;
	end;
	
	if isDown and sym == Input.KEY_KP_enter then
		self.bcActive = not self.bcActive;
	end;
	
	if sym == Input.KEY_pagedown then
		self.wajchagazMax = isDown;
	end;
	if sym == Input.KEY_pageup then
		self.wajchagazMin = isDown;
	end;
	
	if isDown and sym == Input.KEY_KP_7 then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.kierunek2Active = false;
		self.flashWarner = false;
	end;
	if isDown and sym == Input.KEY_KP_8 then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
	if isDown and sym == Input.KEY_KP_9 then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.kierunekActive = false;
		self.flashWarner = false;
	end;

end;
--#################################################################################
function Ursus5314:update(dt)
	if self.isEntered then
		setVisibility(self.halogenT, self.halogenTActive);
		setVisibility(self.halogenP, self.halogenPActive);
		
		if self.flash then
			if self.delayOn >= 0 then
				self.delayOn = self.delayOn -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOn < 0 then
					self.delayOff = 500;
					self.flashlightsRightActive = true;
					self.flashlightsLeftActive = true;
					self.flashlightsWarnerActive = true;
					self.kierunek2Active = true;
					self.kierunekActive = true;
					playSample(self.turn1, 1, 0.7, 0);
				end;
			end;
			if self.delayOff >= 0 then
				self.delayOff = self.delayOff -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOff < 0 then
					self.delayOn = 500;
					self.flashlightsLeftActive = false;
					self.flashlightsRightActive = false;
					self.flashlightsWarnerActive = false;
					self.kierunek2Active = false;
					self.kierunekActive = false;
					playSample(self.turn2, 1, 0.7, 0);
				end;
			end;
		end;
	
		if self.flashRight then
			if self.delayOnRight >= 0 then
				self.delayOnRight = self.delayOnRight -dt;
			end;
			if not self.flashlightsRightActive then
				if self.delayOnRight < 0 then
					self.delayOffRight = 500;
					self.flashlightsRightActive = true;
					self.kierunek2Active = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffRight >= 0 then
				self.delayOffRight = self.delayOffRight -dt;
			end;
			if self.flashlightsRightActive then
				if self.delayOffRight < 0 then
					self.delayOnRight = 500;
					self.flashlightsRightActive = false;
					self.kierunek2Active = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.kierunek2Active = false;
			end;
		end;
	
		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.kierunekActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.kierunekActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.kierunekActive = false;
			end;
		end;
		setVisibility(self.kierunek, self.kierunekActive);
		setVisibility(self.kierunek2, self.kierunek2Active);
	
		
		if InputBinding.hasEvent(InputBinding.Ursus5314_SzybaT) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, self.animationParts[1].offSet);
			elseif self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.Ursus5314_Dach) then
			if self.animationParts[2].clipEndTime then
				self:setAnimationTime(2, self.animationParts[2].offSet);
			elseif self.animationParts[2].clipStartTime then
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			end;
		end;		
		if InputBinding.hasEvent(InputBinding.Ursus5314_DrzwiL) then
			if self.animationParts[3].clipEndTime then
				self:setAnimationTime(3, self.animationParts[3].offSet);
			elseif self.animationParts[3].clipStartTime then
				self:setAnimationTime(3, self.animationParts[3].animDuration);
			end;
		end;
		if InputBinding.hasEvent(InputBinding.Ursus5314_DrzwiP) then
			if self.animationParts[4].clipEndTime then
				self:setAnimationTime(4, self.animationParts[4].offSet);
			elseif self.animationParts[4].clipStartTime then
				self:setAnimationTime(4, self.animationParts[4].animDuration);
			end;
		end;		
	    
	if self:getIsActiveForInput() and self.isEntered then
	
	    if self.motor.speedLevel ~= 0 then
			
            if InputBinding.isPressed(InputBinding.ObrUp) then
		        if self.motor.maxRpm[self.motor.speedLevel] <= (self.motorMaxRpmLimit[3] - 50) then
		            self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] + 50;
			    end;
		    elseif InputBinding.isPressed(InputBinding.ObrDown) then
		        if self.motor.maxRpm[self.motor.speedLevel] >= 50 then
			        self.motor.maxRpm[self.motor.speedLevel] = self.motor.maxRpm[self.motor.speedLevel] - 50;
			    end;
	    	end;
				
		else
			
            if InputBinding.isPressed(InputBinding.ObrUp) then
		        if self.motor.maxRpm[3] <= (self.motorMaxRpmLimit[3] - 50) then
		            self.motor.maxRpm[3] = self.motor.maxRpm[3] + 50;
			    end;
		    elseif InputBinding.isPressed(InputBinding.ObrDown) then
		        if self.motor.maxRpm[3] >= 50 then
			            self.motor.maxRpm[3] = self.motor.maxRpm[3] - 50;
			    end;
	    	end;
		end;
	end;
	
		

	
	
end; -- isEntered

 
end;		
--#################################################################################		
function Ursus5314:draw()
	
	if self.bcActive then
		setTextBold(true);
		setTextColor(0,1,0,1);
		renderText(0.79, 0.18, 0.022, "Klawisz minus: I-N-F-O");
	else
		setTextBold(true);
		setTextColor(1,0,0,1);
		renderText(0.79, 0.18, 0.022, "Klawisz minus: I-N-F-O");
	end;
	
	if self.URhudOverlay ~= nil then
		if self.bcActive then
			self.URhudOverlay:render();
		end;
	end;
 	
	if self.isMotorStarted then	
        if self.motor.speedLevel ~= 0 then
            g_currentMission:addExtraPrintText("Klawisz pageup:   "..string.format("%d RPM",self.motor.maxRpm[self.motor.speedLevel]).."");
	    else
            g_currentMission:addExtraPrintText("Klawisz pagedown:   "..string.format("%d RPM",self.motor.maxRpm[3]).."");
	    end;
	end;
 
	if self.bcActive then
		if self.halogenPActive then
			setTextColor(0,1,0,1);
			renderText(0.045, 0.765, 0.018, "Klawisz 5: Halogen Przod");
		else
			setTextColor(1,1,1,1);
			renderText(0.045, 0.765, 0.018, "Klawisz 5: Halogen Przod");
		end;
  		if self.halogenTActive then
			setTextColor(0,1,0,1);
			renderText(0.045, 0.745, 0.018, "Klawisz 6: Halogen Tyl");
		else
			setTextColor(1,1,1,1);
			renderText(0.045, 0.745, 0.018, "Klawisz 6: Halogen Tyl");
		end;
	  	if self.animationParts[1].clipStartTime then
			setTextColor(1,1,1,1);
			renderText(0.045, 0.725, 0.018, "Klawisz 7: Szyba");
		else
			setTextColor(0,1,0,1);
			renderText(0.045, 0.725, 0.018, "Klawisz 7: Szyba");
		end;
		if self.animationParts[2].clipStartTime then
			setTextColor(1,1,1,1);
			renderText(0.045, 0.705, 0.018, "Klawisz 8: Dach");
		else
			setTextColor(0,1,0,1);
			renderText(0.045, 0.705, 0.018, "Klawisz 8: Dach");
		end;
		if self.animationParts[3].clipStartTime then
			setTextColor(1,1,1,1);
			renderText(0.045, 0.685, 0.018, "Klawisz 9: Drzwi Lewe");
		else
			setTextColor(0,1,0,1);
			renderText(0.045, 0.685, 0.018, "Klawisz 9: Drzwi Lewe");
		end;
		if self.animationParts[4].clipStartTime then
			setTextColor(1,1,1,1);
			renderText(0.045, 0.665, 0.018, "Klawisz 0: Drzwi Prawe");
		else
			setTextColor(0,1,0,1);
			renderText(0.045, 0.665, 0.018, "Klawisz 0: Drzwi Prawe");
		end;
		if self.flashRight then
			setTextColor(0,1,0,1);
			renderText(0.045, 0.645, 0.018, "Klawisz KP 7: Kierunek(L)");
		else
			setTextColor(1,1,1,1);
			renderText(0.045, 0.645, 0.018, "Klawisz KP 7: Kierunek(L)");
		end;
		if self.flash then
			setTextColor(0,1,0,1);
			renderText(0.045, 0.625, 0.018, "Klawisz KP 8: Awaryjne");
		else
			setTextColor(1,1,1,1);
			renderText(0.045, 0.625, 0.018, "Klawisz KP 8: Awaryjne");
		end;
		if self.flashLeft then
			setTextColor(0,1,0,1);
			renderText(0.045, 0.605, 0.018, "Klawisz KP 9: Kierunek(P)");
		else
			setTextColor(1,1,1,1);
			renderText(0.045, 0.605, 0.018, "Klawisz KP 9: Kierunek(P)");
		end;

		

	
	end;
        


end;
--#################################################################################
function Ursus5314:onEnter()
    
end;
--#################################################################################
function Ursus5314:onLeave()
	self.halogenTActive = false; 

end;
--#################################################################################
function Ursus5314:delete()
end;
--#################################################################################
function Ursus5314:mouseEvent(posX, posY, isDown, isUp, button)
end;
--#################################################################################

