-- Ursus 1614
-- by DanstesLS

Ursus_1614 = {};

function Ursus_1614.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Ursus_1614:load(xmlFile)
------------------KOGUT--------------------
    self.kogutAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.kogut#count"),0);
    self.kogutKey = getXMLString(xmlFile, "vehicle.kogut#key");
    self.kogutAn = false;
    self.kogut = {};
    for i=1, self.kogutAnz do
        local objname = string.format("vehicle.kogut.light" .. "%d",i);
        self.kogut[i] = {};
        self.kogut[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.kogut[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.kogut[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.kogut[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.kogut[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.kogut[i].emit and self.kogut[i].source ~= nil then
           setVisibility(self.kogut[i].source, false);
        end;
    end;
------------------POMOC--------------------------------
    self.controlpath = Utils.getFilename("pomoc.png", self.baseDirectory);
    self.ursusPoxX = 0.01;
    self.ursusPoxY = 1-0.204;
    self.ursusWidth = 0.240;
    self.ursusHeight = 0.240;
    self.ursusPoxX = 0.75;
    self.ursusPoxY = 0.60
    self.ursusOverlay = Overlay:new("ursuscontrol", self.controlpath, self.ursusPoxX, self.ursusPoxY, self.ursusWidth, self.ursusHeight);
----------------------HOLOGENY PRZEDNIE---------------
    self.numhalogenys = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.halogeny_przednie#count"), 0);
    self.halogenys = {};
    for i=1, self.numhalogenys do
        local halogenynamei = string.format("vehicle.halogeny_przednie.halogeny_przednie" .. "%d", i);
        self.halogenys[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, halogenynamei .. "#index"));
        setVisibility(self.halogenys[i], false);
    end;

  -------------------HALOGENY TYLNE--------------
    self.numtravails = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.halogeny_tylne#count"), 0);
    self.travails = {};
    for i=1, self.numtravails do
        local travailnamei = string.format("vehicle.halogeny_tylne.halogeny_tylne" .. "%d", i);
        self.travails[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, travailnamei .. "#index"));
        setVisibility(self.travails[i], false);
    end;

  -------------------SWIATLO WEWNATRZ--------------
    self.numpodswietlenies = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.swiatlo_wewnatrz#count"), 0);
    self.podswietlenies = {};
    for i=1, self.numpodswietlenies do
        local podswietlenienamei = string.format("vehicle.swiatlo_wewnatrz.swiatlo_wewnatrz" .. "%d", i);
        self.podswietlenies[i] = Utils.indexToObject(self.rootNode, getXMLInt(xmlFile, podswietlenienamei .. "#index"));
        setVisibility(self.podswietlenies[i], false);
    end;

---------------TYLNA SZYBYA------------------

    local rotationPartNodebackwindow = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tylna_szyba#index"));
    if rotationPartNodebackwindow ~= nil then
        self.rotationPartbackwindow = {};
        self.rotationPartbackwindow.node = rotationPartNodebackwindow;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParttylna_szyba#minRot"));
        self.rotationPartbackwindow.minRot = {};
        self.rotationPartbackwindow.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tylna_szyba#maxRot"));
        self.rotationPartbackwindow.maxRot = {};
        self.rotationPartbackwindow.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartbackwindow.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartbackwindow.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartbackwindow.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tylna_szyba#rotTime"), 2)*1000;
        self.rotationPartbackwindow.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tylna_szyba#touchRotLimit"), 10));
    end;
	
	    local rotationPartNodetloczki = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tloki#index"));
    if rotationPartNodetloczki ~= nil then
        self.rotationParttloczki = {};
        self.rotationParttloczki.node = rotationPartNodetloczki;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationParttloki#minRot"));
        self.rotationParttloczki.minRot = {};
        self.rotationParttloczki.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttloczki.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttloczki.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tloki#maxRot"));
        self.rotationParttloczki.maxRot = {};
        self.rotationParttloczki.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationParttloczki.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationParttloczki.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationParttloczki.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tloki#rotTime"), 2)*1000;
        self.rotationParttloczki.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tloki#touchRotLimit"), 10));
    end;


	self.rotationMaxtloczki = true;
	self.rotationMaxbackwindow = true;
	self.travailsActive = false; 
	self.halogenysActive = false;
end;

function Ursus_1614:keyEvent(unicode, sym, modifier, isDown)
--------KOGUT---------------
    if self.isEntered then
      if self.kogutKey ~= nil then
         if isDown and sym == Input[self.kogutKey] then
           self.kogutAn = not self.kogutAn;
           for i=1, self.kogutAnz do
             setVisibility(self.kogut[i].light, self.kogutAn);
           end;
         end;
      end;
    end;

-------------------HALOGENY PRZEDNIE--------------
    if isDown and sym == Input.KEY_4 then
		self.halogenysActive = not self.halogenysActive;
	end;
	
	
  -------------------HALOGENY TYLNE--------------	

	    if isDown and sym == Input.KEY_5 then
		self.travailsActive = not self.travailsActive;
	end;	
	
		 
	
---------------TYLNA SZYBYA------------------
	
	    if isDown and sym == Input.KEY_8 then 
		self.rotationMaxbackwindow = not self.rotationMaxbackwindow;
	end;
		    if isDown and sym == Input.KEY_8 then 
		self.rotationMaxtloczki = not self.rotationMaxtloczki;
	end;
	

	    ----------------POMOC---------------
	    if isDown and sym == 48 then -- Key: 0
		self.pomoc = not self.pomoc;
    end;
	
	
end;


function Ursus_1614:update(dt)
    if self.isEntered then
---------------KOGUT-------------------

  if self.isEntered then
    if self.kogutAnz > 0 then
      if self.kogutAn then
        for i=1, self.kogutAnz do
          rotate(self.kogut[i].rotNode, 0, dt*self.kogut[i].speed, 0);
        end;
      end;
    end;
  end;
  -------------------HALOGENY PRZEDNIE--------------
        if self.halogenysActive then
		   for i=1, self.numhalogenys do
			local halogeny = self.halogenys[i];
			setVisibility(halogeny, self.whalogenysActive);
		   end;
	       else
		   for i=1, self.numhalogenys do
			local halogeny = self.halogenys[i];
			setVisibility(halogeny, self.halogenysActive, false);
		   end;
	    end;
end;
  -------------------HALOGENY TYLNE--------------
        if self.travailsActive then
		   for i=1, self.numtravails do
			local travail = self.travails[i];
			setVisibility(travail, self.travailsActive);
		   end;
	       else
		   for i=1, self.numtravails do
			local travail = self.travails[i];
			setVisibility(travail, self.travailsActive, false);
		   end;
	    end;

	
---------------TYLNA SZYBYA------------------
if self.rotationPartbackwindow ~= nil then
		local x, y, z = getRotation(self.rotationPartbackwindow.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartbackwindow.maxRot, self.rotationPartbackwindow.minRot, 3, self.rotationPartbackwindow.rotTime, dt, not self.rotationMaxbackwindow);
		setRotation(self.rotationPartbackwindow.node, unpack(newRot));
   end;	
	
if self.rotationParttloczki ~= nil then
		local x, y, z = getRotation(self.rotationParttloczki.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationParttloczki.maxRot, self.rotationParttloczki.minRot, 3, self.rotationParttloczki.rotTime, dt, not self.rotationMaxtloczki);
		setRotation(self.rotationParttloczki.node, unpack(newRot));
   end;		



end;		
		
		


function Ursus_1614:draw()
if not self.pomoc then
		setTextColor(1,1,1,1);
		renderText(0.80, 0.74, 0.026, "0: Wlacz Pomoc");
	else
		setTextColor(1,1,1,1);
		renderText(0.80, 0.74, 0.026, "0: Wylacz Pomoc");
	end;
	
	if self.pomoc then
	
	
	if self.halogenysActive then
		renderText(0.72, 0.72, 0.021, "4: Wylacz Halogeny przednie");
	else
		renderText(0.72, 0.72, 0.021, "4: Wlacz Halogeny przednie");
	end;
	
	if self.travailsActive then
		renderText(0.72, 0.70, 0.021, "5: Wylacz Halogeny tylne");
	else
		renderText(0.72, 0.70, 0.021, "5: Wlacz Halogeny tylne");
	end;		

		if self.kogutAn then
		renderText(0.72, 0.68, 0.021, "7: Wylacz Kogut");
	else
		renderText(0.72, 0.68, 0.021, "7: Wlacz Kogut");
	end;	
	if self.rotationMaxbackwindow then
		renderText(0.72, 0.66, 0.021, "8: Zamknij Tylna szyba");
	else
		renderText(0.72, 0.66, 0.021, "8: Otworz Tylna szyba");
	end;	


end;
end;


function Ursus_1614:onEnter()
    
end;

function Ursus_1614:onLeave()

self.halogenysActive = false;
	self.kogutAn = false;
    for i=1, self.kogutAnz do
       setVisibility(self.kogut[i].light, self.kogutAn);
    end;

end;

function Ursus_1614:delete()
end;


function Ursus_1614:mouseEvent(posX, posY, isDown, isUp, button)
end;


