--
-- Specjalizacja na kola lampy belke i obciaznik
-- Autor: Lechu
-- Data: 16 Maj 2011
--

Lechu = {};

function Lechu.prerequisitesPresent(specializations)
    return true;
end;

function Lechu:load(xmlFile)
       
       self.halogenp = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.halogenp#index"))
       self.halogenl = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.halogenl#index"))
       self.oponapm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.oponapm#index"))
       self.oponalm = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.oponalm#index"))
       self.oponap = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.oponap#index"))
       self.oponal = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.oponal#index"))
       self.lampa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.lampa#index"))
       self.balast = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.balast#index"))
       self.halogenpActive = false;
       self.halogenlActive = false;
       self.oponapmActive = true;
       self.oponalmActive = true;
       self.oponapAcitve = false;
       self.oponalActive = false;
       self.lampaActive = false;
       self.balastActive = false;

end;

function Lechu:updateTick(dt)

        setVisibility(self.halogenp, self.halogenpActive);
        setVisibility(self.halogenl, self.halogenlActive);
        setVisibility(self.oponapm, self.oponapmActive);
        setVisibility(self.oponalm, self.oponalmActive);
        setVisibility(self.oponap, self.oponapActive);
        setVisibility(self.oponal, self.oponalActive);
        setVisibility(self.lampa, self.lampaActive);
        setVisibility(self.balast, self.balastActive);

end;

function Lechu:update(dt)
end;

function Lechu:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Lechu:keyEvent(unicode, sym, modifier, isDown)

    if isDown and sym == Input.KEY_o then
        self.halogenpActive = not self.halogenpActive;
    end;
    if isDown and sym == Input.KEY_o then
        self.halogenlActive = not self.halogenlActive;
    end;
    if isDown and sym == Input.KEY_n then
        self.oponapmActive = not self.oponapmActive;
    end;
    if isDown and sym == Input.KEY_m then
        self.oponalmActive = not self.oponalmActive;
    end;
    if isDown and sym == Input.KEY_7 then
        self.oponapActive = not self.oponapActive;
    end;
    if isDown and sym == Input.KEY_5 then
        self.oponalActive = not self.oponalActive;
    end;
    if isDown and sym == Input.KEY_9 then
        self.lampaActive = not self.lampaActive;
    end;
    if isDown and sym == Input.KEY_y then
        self.balastActive = not self.balastActive;
    end;
end;

function Lechu:draw()
    if self.bolec then
        g_currentMission:addExtraPrintText("Klawisz 9: wlacz lampe");
    else
        g_currentMission:addExtraPrintText("Klawisz 9: wylacz lampe");
    end;
    if self.balast then
        g_currentMission:addExtraPrintText("Klawisz y: zaloz Balast");
    else
        g_currentMission:addExtraPrintText("Klawisz y: Zdejmij Balast");
    end;
end;

function Lechu:onAttach()
end; 	

function Lechu:onDetach()
end;

function Lechu:onDeactivate()
end;

function Lechu:delete()
end;

function Lechu:onEnter()
end;

function Lechu:onLeave()
end;