--
-- Lexion580Cutter
-- This is the specialization for cutters
-- It reacts both to steerable and attachable events
--
-- @author  Stefan Geiger
-- @date  04/12/08
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

Lexion580Cutter = {};

function Lexion580Cutter.prerequisitesPresent(specializations)
    return true;
end;

function Lexion580Cutter:load(xmlFile)

   
	
	self.hydraulic = {};
	self.hydraulic.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zylinder#rotIndex"));
	self.hydraulic.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zylinder#transIndex"));
	self.hydraulic.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zylinder#translationPunch"));
	self.hydraulic.rotationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.zylinder#rotationPunch"));
	if self.hydraulic.punch and self.hydraulic.translationPunch ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic.punch);
		local bx, by, bz = getWorldTranslation(self.hydraulic.translationPunch);
		self.hydraulic.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
	end;
	
	self.earLifter = {};
	self.earLifter.left = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.earLifter#left"));
	self.earLifter.right = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.earLifter#right"));
	
	self.pto = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pto#index"));
	
    self.currentFruitType = FruitUtil.FRUITTYPE_UNKNOWN;
    self.reelStarted = false;
    self.forceLowSpeed = false;
    self.speedLimitLow = 20.2;
    self.speedLimit = 20.2; --old 17.5
    self.speedViolationMaxTime = 50;
    self.speedViolationTimer = self.speedViolationMaxTime;
    self.printRainWarning = false;
    self.lastArea = 0;
	self.percentArea = 0;

end;

function Lexion580Cutter:delete()
   
end;

function Lexion580Cutter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Lexion580Cutter:keyEvent(unicode, sym, modifier, isDown)
end;

function Lexion580Cutter:update(dt)

	if self.attacherVehicle ~= nil then
		setRotation(self.pto, 0, 0, 0-0.05);
		setRotation(self.earLifter.right, 0, 0, 0);
		setRotation(self.earLifter.left, 0, 0, 0);
	end;
	
  
    if self.reelStarted then

        rotate(self.rollNode, -dt*self.reelSpeed*10, 0, 0);
		if self.rollNodeLeft and self.rollNodeRight ~= nil then
			rotate(self.rollNodeLeft, -dt*self.reelSpeed*10, 0, 0);
			rotate(self.rollNodeRight, -dt*self.reelSpeed*10, 0, 0);
		end;

       
    end;
		
	if self.hydraulic.node and self.hydraulic.rotationPunch and self.hydraulic.punch ~= nil then
		local ax, ay, az = getWorldTranslation(self.hydraulic.node);
		local bx, by, bz = getWorldTranslation(self.hydraulic.rotationPunch);
		local x, y, z = worldDirectionToLocal(getParent(self.hydraulic.node), bx-ax, by-ay, bz-az);
		setDirection(self.hydraulic.node, x, y, z, 0, 0, 1);
		if self.hydraulic.punch ~= nil then
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.hydraulic.punch, 0, 0, (distance-self.hydraulic.punchDistance));
		end;
	end;
	
	if self.rapeTable ~= nil then
		if self.currentFruitType == FruitUtil.FRUITTYPE_RAPE then
	        setVisibility(self.rapeTable, true);
			setVisibility(self.wheatTable, false);
		else
	        setVisibility(self.rapeTable, false);
	        setVisibility(self.wheatTable, true);
		end;
	end;
	
	if self.attacherVehicle ~= nil then
		if self.attacherVehicle.isEntered then
			if self.sidearms.movable then
				local xRotHaspel, yRotHaspel, zRotHaspel = getRotation(self.sidearms.rot);
				local xTransHaspel, yTransHaspel, zTransHaspel = getTranslation(self.sidearms.trans);
				local move = 0.0065;

				if InputBinding.isPressed(InputBinding.HASPEL_UP) then
					if xRotHaspel <= Utils.degToRad(12) then
						xRotHaspel = xRotHaspel + move;
					else
						xRotHaspel = xRotHaspel;
					end;
				end;
				if InputBinding.isPressed(InputBinding.HASPEL_DOWN) then
					if xRotHaspel >= Utils.degToRad(-20) then
						xRotHaspel = xRotHaspel - move;
					else
						xRotHaspel = xRotHaspel;
					end;
				end;
				if InputBinding.isPressed(InputBinding.HASPEL_BACK) then
					if zTransHaspel <= -0.88 then
						zTransHaspel = zTransHaspel + move;
					else
						zTransHaspel = zTransHaspel;
					end;
				end;
				if InputBinding.isPressed(InputBinding.HASPEL_FORWARD) then
					if zTransHaspel >= -1.25 then
						zTransHaspel = zTransHaspel - move;
					else
						zTransHaspel = zTransHaspel;
					end;
				end;
				setRotation(self.sidearms.rot, xRotHaspel, yRotHaspel, zRotHaspel);
				setTranslation(self.sidearms.trans, xTransHaspel, yTransHaspel, zTransHaspel);
				end;
		end;
	end;
	
end;

function Lexion580Cutter:draw()


end;

function Lexion580Cutter:onDetach()

	local y = 8.2*3.1456/180.0;
	local z = 19*3.1456/180.0;
	setRotation(self.pto, 0, y, z);
	
	local yMaxLeft = 80;
	local yMaxRight = -80;
	setRotation(self.earLifter.right, 0, yMaxRight, 0);
	setRotation(self.earLifter.left, 0, yMaxLeft, 0);
	
end;

function Lexion580Cutter:onLeave()
   
end;

function Lexion580Cutter:onDeactivate()
   
end;
