--
-- Claas Lexion 580
-- Specialization for Lexion 580 Cutter
--
-- @author  MajsteR
-- @date  21/11/10
--
-- Copyright (C) MajsteR, All Rights Reserved.
-- 
-- www.majster-mod.xaa.pl

Lexion580C = {};

function Lexion580C.prerequisitesPresent(specializations)
    return true;
end;

function Lexion580C:load(xmlFile)

	---------------------------TLOKI-------------------------
	local tlok2Node = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tlok2#index"));
		if tlok2Node ~= nil then
        self.tlok2 = {};
        self.tlok2.node = tlok2Node;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tlok2#minRot"));
        self.tlok2.minRot = {};
        self.tlok2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tlok2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tlok2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tlok2#maxRot"));
        self.tlok2.maxRot = {};
        self.tlok2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tlok2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tlok2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tlok2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tlok2#rotTime"), 2)*1000;
        self.tlok2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tlok2#touchRotLimit"), 10));
    end;
	
			local tlokNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.tlok#index"));
		if tlokNode ~= nil then
        self.tlok = {};
        self.tlok.node = tlokNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tlok#minRot"));
        self.tlok.minRot = {};
        self.tlok.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tlok.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tlok.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.tlok#maxRot"));
        self.tlok.maxRot = {};
        self.tlok.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.tlok.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.tlok.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.tlok.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.tlok#rotTime"), 2)*1000;
        self.tlok.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.tlok#touchRotLimit"), 10));
    end;
--------------END----------------------
	--------RAMIONA---------------------
		local ramionaNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.ramiona#index"));
		if ramionaNode ~= nil then
        self.ramiona = {};
        self.ramiona.node = ramionaNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ramiona#minRot"));
        self.ramiona.minRot = {};
        self.ramiona.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ramiona.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ramiona.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.ramiona#maxRot"));
        self.ramiona.maxRot = {};
        self.ramiona.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.ramiona.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.ramiona.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.ramiona.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.ramiona#rotTime"), 2)*1000;
        self.ramiona.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.ramiona#touchRotLimit"), 10));
    end;
	-------END------------
------------KOSA-------------------
	local translationPartNode2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kosa#index"));
    if translationPartNode2 ~= nil then
        self.translationPart2 = {};
        self.translationPart2.node = translationPartNode2;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kosa#minTrans"));
        self.translationPart2.minTrans = {};
        self.translationPart2.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kosa#maxTrans"));
        self.translationPart2.maxTrans = {};
        self.translationPart2.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart2.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart2.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart2.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kosa2#transTime"), 2)*1000;
        self.translationPart2.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kosa2#touchTransLimit"), 10);
    end;
	local translationPartNode3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kosa2#index"));
    if translationPartNode3 ~= nil then
        self.translationPart3 = {};
        self.translationPart3.node = translationPartNode3;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kosa2#minTrans"));
        self.translationPart3.minTrans = {};
        self.translationPart3.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.kosa2#maxTrans"));
        self.translationPart3.maxTrans = {};
        self.translationPart3.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart3.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart3.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart3.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kosa2#transTime"), 2)*1000;
        self.translationPart3.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.kosa2#touchTransLimit"), 10);
    end;
-------------END--------------
-----------WYSUWNIE MOTOWIDEL----------------
	local translationPartNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.wysuwanie_motowidel#index"));
    if translationPartNode ~= nil then
        self.translationPart = {};
        self.translationPart.node = translationPartNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wysuwanie_motowidel#minTrans"));
        self.translationPart.minTrans = {};
        self.translationPart.minTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.minTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.minTrans[3] = Utils.getNoNil(z, 0);

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.wysuwanie_motowidel#maxTrans"));
        self.translationPart.maxTrans = {};
        self.translationPart.maxTrans[1] = Utils.getNoNil(x, 0);
        self.translationPart.maxTrans[2] = Utils.getNoNil(y, 0);
        self.translationPart.maxTrans[3] = Utils.getNoNil(z, 0);

        self.translationPart.transTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wysuwanie_motowidel#transTime"), 2)*1000;
        self.translationPart.touchTransLimit = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wysuwanie_motowidel#touchTransLimit"), 10);
    end;	
-------------END--------------	
	self.controlpath = Utils.getFilename("pomocH.png", self.baseDirectory);
    self.bshudWidth = 0.356;
    self.bshudHeight = 0.416;
	self.bshudPoxX = -0.045;
    self.bshudPoxY = 1-0.6;
    self.bshudOverlay = Overlay:new("bs2hudControl", self.controlpath, self.bshudPoxX, self.bshudPoxY, self.bshudWidth, self.bshudHeight);
	
	self.test = 80;

self.bodyActive = true;
self.body = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.body#index"));

self.stolvis = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kosa_vis#index"));
self.stolvisActive = false;

self.stol2vis = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.stol#index"));
self.stol2visActive = false;

end;

function Lexion580C:delete()
   
end;

function Lexion580C:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Lexion580C:keyEvent(unicode, sym, modifier, isDown)
----------RAMIONA------------
	if sym == Input.KEY_KP_2 then
		self.ramionaMax = isDown;
		self.tlokMax = isDown;
		self.tlok2Max = isDown;
	end;
	if sym == Input.KEY_KP_8 then
		self.ramionaMin = isDown;
		self.tlokMin = isDown;
		self.tlok2Min = isDown;
	end;	
---------------END---------------
----------WYSUWANIE MOTOWIDEL------------
	if sym == Input.KEY_KP_6 then
		self.translationMax = isDown;
	end;
	if sym == Input.KEY_KP_4 then
		self.translationMin = isDown;
	end;	
---------------END---------------
--------------END----------
   if isDown and sym == Input.KEY_KP_0 then
		self.bc2Active = not self.bc2Active;
	end;
--------------POMOC------------
----------REGULACJA PREDKOSCI MOTOWIDEL-------------------
	if sym == Input.KEY_KP_1 then 
		self.wolniej = isDown;
	end;
	if sym == Input.KEY_KP_3 then
		self.szybciej = isDown;
	end;
---------------END------------------
   if isDown and sym == Input.KEY_KP_5 then
		self.stol2visActive = not self.stol2visActive;
		self.stolvisActive = not self.stolvisActive;
		self.bodyActive = not self.bodyActive;
	end;
	
end;

function Lexion580C:update(dt)
------------RAMIONA------------
 local doRotate = self.ramionaMax or self.ramionaMin 
	if self.ramiona ~= nil and doRotate then
        	local x, y, z = getRotation(self.ramiona.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.ramiona.maxRot, self.ramiona.minRot, 3, self.ramiona.rotTime, dt, not self.ramionaMax);
        	setRotation(self.ramiona.node, unpack(newRot));
	end;  
------------END------------
-----------KOSA----------------
	if self.translationMax2 ~= nil then
		local x, y, z = getTranslation(self.translationPart2.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart2.maxTrans, self.translationPart2.minTrans, 3, self.translationPart2.transTime, dt, not self.translationMax2);
        setTranslation(self.translationPart2.node, unpack(newTrans));
	end;
	if self.translationMax3 ~= nil then
		local x, y, z = getTranslation(self.translationPart3.node);
        local trans = {x,y,z};
        local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart3.maxTrans, self.translationPart3.minTrans, 3, self.translationPart3.transTime, dt, not self.translationMax3);
        setTranslation(self.translationPart3.node, unpack(newTrans));
	end;
-------------END----------------
--------------RUCH KOSY-----------
	if self.reelStarted then
		self.test = self.test - dt;
		if self.test < 0 then
			self.translationMax2 = not self.translationMax2;
			self.translationMax3 = not self.translationMax3;
			self.test = 80;
		end;

	end;
----------END--------------
-----------WYSUWNIE MOTOWIDEL----------------
	local doTranslate = self.translationMax or self.translationMin
		if self.translationPart ~= nil and doTranslate then
			local x, y, z = getTranslation(self.translationPart.node);
			local trans = {x,y,z};
			local newTrans = Utils.getMovedLimitedValues(trans, self.translationPart.maxTrans, self.translationPart.minTrans, 3, self.translationPart.transTime, dt, not self.translationMax);
			setTranslation(self.translationPart.node, unpack(newTrans));
		end;
-------------END----------------	
-----------PREDKOSC MOTOWIDEL--------------------
if self.szybciej then		
	if self.reelSpeed < 0.005 then
			self.reelSpeed = self.reelSpeed + 0.00001;
		end;	
end;
if self.wolniej then
	if self.reelSpeed > 0.0015 then
			self.reelSpeed = self.reelSpeed - 0.00001;
	end;
end;
----------END--------------------	
---------------------TLOKI----------------
		---------------------------------tlok----------------------------------
 local doRotate = self.tlokMax or self.tlokMin 
	if self.tlok ~= nil and doRotate then
        	local x, y, z = getRotation(self.tlok.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.tlok.maxRot, self.tlok.minRot, 3, self.tlok.rotTime, dt, not self.tlokMax);
        	setRotation(self.tlok.node, unpack(newRot));
	end; 

 local doRotate = self.tlok2Max or self.tlok2Min 
	if self.tlok2 ~= nil and doRotate then
        	local x, y, z = getRotation(self.tlok2.node);
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.tlok2.maxRot, self.tlok2.minRot, 3, self.tlok2.rotTime, dt, not self.tlok2Max);
        	setRotation(self.tlok2.node, unpack(newRot));
	end; 
----------END-----------------

		setVisibility(self.stol2vis, self.stol2visActive);
		setVisibility(self.stolvis, self.stolvisActive);
		setVisibility(self.body, self.bodyActive);
end;

function Lexion580C:draw()
	   	if self.bshudOverlay ~= nil then
			if self.bc2Active then
			self.bshudOverlay:render();
			end;
		end;
	if self.bc2Active then
		setTextColor(1,1,1,1);
		renderText(0.8335, 0.20, 0.02, "NUM 0: Wylacz Pomoc");
	else
		setTextColor(1,1,1,1);
		renderText(0.8335, 0.20, 0.02, "NUM 0: Wlacz Pomoc");
	end;
	
	if self.bc2Active then
		
		renderText(0.08, 0.75, 0.027, " -->Heder<--");
		
		renderText(0.051, 0.725, 0.023, "Klawiatura numeryczna");
		
		renderText(0.0525, 0.69, 0.020, "Wsun motowidla: 4");
		renderText(0.0525, 0.67, 0.020, "Wysun motowidla: 6");
		renderText(0.0525, 0.65, 0.020, "Motowidla gora: 8");
		renderText(0.0525, 0.63, 0.020, "Motowidla dol: 2");
		renderText(0.0525, 0.61, 0.020, "- Predkosc motowidel: 1");
		renderText(0.0525, 0.59, 0.020, "+ Predkosc motowidel: 3");
		renderText(0.0525, 0.57, 0.020, "Stol do rzepaku: 5");

	
	end;
end;

function Lexion580C:onDetach()

end;

function Lexion580C:onLeave()

end;

function Lexion580C:onDeactivate()

end;

