--
-- Claas Lexion 580
-- Specialization for Lexion 580
--
-- @author  MajsteR
-- @date  21/11/10
--
-- Copyright (C) MajsteR, All Rights Reserved.
-- 
-- www.majster-mod.xaa.pl


--**********************************************************
C_lexion = {};
--**********************************************************
function C_lexion.prerequisitesPresent(specializations)
    Vehicle.registerJointType("cutter");
    Vehicle.registerJointType("trailerCombine");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;
--**********************************************************
function C_lexion:load(xmlFile)

--------------------------------SIECZKARNIA-----------------------------------------
	local rotationPartNodesieczkarnia = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.sieczkarnia#index"));
    if rotationPartNodesieczkarnia ~= nil then
        self.rotationPartsieczkarnia = {};
        self.rotationPartsieczkarnia.node = rotationPartNodesieczkarnia;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sieczkarnia#minRot"));
        self.rotationPartsieczkarnia.minRot = {};
        self.rotationPartsieczkarnia.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartsieczkarnia.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartsieczkarnia.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.sieczkarnia#maxRot"));
        self.rotationPartsieczkarnia.maxRot = {};
        self.rotationPartsieczkarnia.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartsieczkarnia.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartsieczkarnia.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartsieczkarnia.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.sieczkarnia2#rotTime"), 2)*1000;
        self.rotationPartsieczkarnia.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.sieczkarnia2#touchRotLimit"), 10));
    end

	self.controlpath = Utils.getFilename("pomocH.png", self.baseDirectory);
    self.ChudWidth = 0.356;
    self.ChudHeight = 0.416;
	self.ChudPoxX = -0.045;
    self.ChudPoxY = 1-0.86;
    self.ChudOverlay = Overlay:new("ChudControl", self.controlpath, self.ChudPoxX, self.ChudPoxY, self.ChudWidth, self.ChudHeight);

	self.halogenyP = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Halogeny#Przednie"));
	self.halogenyPActive = false;
	self.halogenyT = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Halogeny#Tylnie"));
	self.halogenyTActive = false;

	
	local rotationPartNodeklapa = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa#index"));
    if rotationPartNodeklapa ~= nil then
        self.rotationPartklapa = {};
        self.rotationPartklapa.node = rotationPartNodeklapa;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartklapa#minRot"));
        self.rotationPartklapa.minRot = {};
        self.rotationPartklapa.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklapa.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklapa.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klapa#maxRot"));
        self.rotationPartklapa.maxRot = {};
        self.rotationPartklapa.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklapa.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklapa.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartklapa.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.klapa#rotTime"), 2)*1000;
        self.rotationPartklapa.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.klapa#touchRotLimit"), 10));
    end;
	self.rotationMaxklapa = true;

	local rotationPartNodeklapa2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa2#index"));
    if rotationPartNodeklapa2 ~= nil then
        self.rotationPartklapa2 = {};
        self.rotationPartklapa2.node = rotationPartNodeklapa2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartklapa2#minRot"));
        self.rotationPartklapa2.minRot = {};
        self.rotationPartklapa2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklapa2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklapa2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klapa2#maxRot"));
        self.rotationPartklapa2.maxRot = {};
        self.rotationPartklapa2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklapa2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklapa2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartklapa2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.klapa2#rotTime"), 2)*1000;
        self.rotationPartklapa2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.klapa2#touchRotLimit"), 10));
    end;
	self.rotationMaxklapa2 = true;
	
	local rotationPartNodeklapa3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa3#index"));
    if rotationPartNodeklapa3 ~= nil then
        self.rotationPartklapa3 = {};
        self.rotationPartklapa3.node = rotationPartNodeklapa3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartklapa3#minRot"));
        self.rotationPartklapa3.minRot = {};
        self.rotationPartklapa3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklapa3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklapa3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klapa3#maxRot"));
        self.rotationPartklapa3.maxRot = {};
        self.rotationPartklapa3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklapa3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklapa3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartklapa3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.klapa3#rotTime"), 2)*1000;
        self.rotationPartklapa3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.klapa3#touchRotLimit"), 10));
    end;
	self.rotationMaxklapa3 = true;

	local rotationPartNodeklapa4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa4#index"));
    if rotationPartNodeklapa4 ~= nil then
        self.rotationPartklapa4 = {};
        self.rotationPartklapa4.node = rotationPartNodeklapa4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartklapa4#minRot"));
        self.rotationPartklapa4.minRot = {};
        self.rotationPartklapa4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklapa4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklapa4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.klapa4#maxRot"));
        self.rotationPartklapa4.maxRot = {};
        self.rotationPartklapa4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartklapa4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartklapa4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartklapa4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.klapa4#rotTime"), 2)*1000;
        self.rotationPartklapa4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.klapa4#touchRotLimit"), 10));
    end;
	self.rotationMaxklapa4 = true;
	
	local rotationPartNodeSchody = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Schody#index"));
    if rotationPartNodeSchody ~= nil then
        self.rotationPartSchody = {};
        self.rotationPartSchody.node = rotationPartNodeSchody;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSchody#minRot"));
        self.rotationPartSchody.minRot = {};
        self.rotationPartSchody.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSchody.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSchody.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Schody#maxRot"));
        self.rotationPartSchody.maxRot = {};
        self.rotationPartSchody.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSchody.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSchody.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSchody.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Schody#rotTime"), 2)*1000;
        self.rotationPartSchody.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Schody#touchRotLimit"), 10));
    end;
	self.rotationMaxSchody = true;
	
  	local rotationPartNodeSchody2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.Schody2#index"));
    if rotationPartNodeSchody2 ~= nil then
        self.rotationPartSchody2 = {};
        self.rotationPartSchody2.node = rotationPartNodeSchody2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartSchody2#minRot"));
        self.rotationPartSchody2.minRot = {};
        self.rotationPartSchody2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSchody2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSchody2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.Schody2#maxRot"));
        self.rotationPartSchody2.maxRot = {};
        self.rotationPartSchody2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartSchody2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartSchody2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartSchody2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.Schody2#rotTime"), 2)*1000;
        self.rotationPartSchody2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.Schody2#touchRotLimit"), 10));
    end;
	self.rotationMaxSchody2 = true;
	
	
	self.kogutAnz = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.kogut#count"),0);
    self.kogutKey = getXMLString(xmlFile, "vehicle.kogut#key");
    self.kogutAn = false;
    self.kogut = {};
    for i=1, self.kogutAnz do
        local objname = string.format("vehicle.kogut.light" .. "%d",i);
        self.kogut[i] = {};
        self.kogut[i].rotNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#rotNode"));
        self.kogut[i].light = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#light"));
        self.kogut[i].source = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, objname .. "#lightsource"));
        self.kogut[i].speed = Utils.getNoNil(getXMLInt(xmlFile,  objname .. "#rotSpeed"), 1)/1000;
        self.kogut[i].emit = Utils.getNoNil(getXMLBool(xmlFile, objname .. "#emitLight"), true);
        if not self.kogut[i].emit and self.kogut[i].source ~= nil then
           setVisibility(self.kogut[i].source, false);
        end;
    end;
	
	self.kierunek = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kierunek_lewy#index"));	
	self.kierunekActive = false;
	
    self.kierunek2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.kierunek_prawy#index"));	
	self.kierunek2Active = false;
	
	turn1SoundFile = Utils.getFilename("turn1.wav", self.baseDirectory);
    self.turn1 = createSample("turn1");
    loadSample(self.turn1, turn1SoundFile, false);
	
	turn2SoundFile = Utils.getFilename("turn2.wav", self.baseDirectory);
    self.turn2 = createSample("turn2");
    loadSample(self.turn2, turn2SoundFile, false);
end;
--**********************************************************
function C_lexion:delete()

   

end;
--**********************************************************
function C_lexion:mouseEvent(posX, posY, isDown, isUp, button)
end;
--**********************************************************
function C_lexion:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_5 then
		self.halogenyPActive = not self.halogenyPActive;
	end;
	if isDown and sym == Input.KEY_6 then
		self.halogenyTActive = not self.halogenyTActive;
	end;
	
	if self.isEntered then
      if self.kogutKey ~= nil then
         if isDown and sym == Input[self.kogutKey] then
           self.kogutAn = not self.kogutAn;
           for i=1, self.kogutAnz do
             setVisibility(self.kogut[i].light, self.kogutAn);
           end;
         end;
      end;
    end;

	 if isDown and sym == Input.KEY_0 then
		self.bcActive = not self.bcActive;
	end;
	---------------------------------KIERUNKI-----------------------	
	if isDown and sym == Input.KEY_n then
		self.flashLeft = not self.flashLeft;
		self.delayOnLeft = 10;
		self.flashRight = false;
		self.flash = false;
		self.flashlightsRightActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsRight2Active = false;
		self.kierunek2Active = false;
		self.flashWarner = false;
	end;
	
	if isDown and sym == Input.KEY_k then
		self.flash = not self.flash;
		self.flashRight = false;
		self.flashLeft = false;
		self.delayOn = 20;
		self.flashlightsRightActive = false;
		self.flashlightsLeftActive = false;
		self.flashWarner = not self.flashWarner;
	end;
	
	if isDown and sym == Input.KEY_m then
		self.flashRight = not self.flashRight;
		self.delayOnRight = 10;
		self.flashLeft = false;
		self.flash = false;
		self.flashlightsLeftActive = false;
		self.flashlightsWarnerActive = false;
		self.flashlightsLeft2Active = false;
		self.kierunekActive = false;
		self.flashWarner = false;
	end;
	if isDown and sym == Input.KEY_z then
		self.slomaActive = not self.slomaActive;
		self.rotationMaxsieczkarnia = not self.rotationMaxsieczkarnia;
	end;
end;
--**********************************************************
function C_lexion:update(dt)
	
	setVisibility(self.halogenyP, self.halogenyPActive);
	setVisibility(self.halogenyT, self.halogenyTActive);
	
	
	if self.rotationPartklapa ~= nil then
		local x, y, z = getRotation(self.rotationPartklapa.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartklapa.maxRot, self.rotationPartklapa.minRot, 3, self.rotationPartklapa.rotTime, dt, not self.rotationMaxklapa);
		setRotation(self.rotationPartklapa.node, unpack(newRot));
	end;
	
	if self.rotationPartklapa2 ~= nil then
		local x, y, z = getRotation(self.rotationPartklapa2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartklapa2.maxRot, self.rotationPartklapa2.minRot, 3, self.rotationPartklapa2.rotTime, dt, not self.rotationMaxklapa2);
		setRotation(self.rotationPartklapa2.node, unpack(newRot));
	end;
	
	if self.rotationPartklapa3 ~= nil then
		local x, y, z = getRotation(self.rotationPartklapa3.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartklapa3.maxRot, self.rotationPartklapa3.minRot, 3, self.rotationPartklapa3.rotTime, dt, not self.rotationMaxklapa3);
		setRotation(self.rotationPartklapa3.node, unpack(newRot));
	end;

	if self.rotationPartklapa4 ~= nil then
		local x, y, z = getRotation(self.rotationPartklapa4.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartklapa4.maxRot, self.rotationPartklapa4.minRot, 3, self.rotationPartklapa4.rotTime, dt, not self.rotationMaxklapa4);
		setRotation(self.rotationPartklapa4.node, unpack(newRot));
	end;
	
	if self.rotationPartSchody ~= nil then
		local x, y, z = getRotation(self.rotationPartSchody.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSchody.maxRot, self.rotationPartSchody.minRot, 3, self.rotationPartSchody.rotTime, dt, not self.rotationMaxSchody);
		setRotation(self.rotationPartSchody.node, unpack(newRot));
	end;
	
	if self.rotationPartSchody2 ~= nil then
		local x, y, z = getRotation(self.rotationPartSchody2.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartSchody2.maxRot, self.rotationPartSchody2.minRot, 3, self.rotationPartSchody2.rotTime, dt, not self.rotationMaxSchody2);
		setRotation(self.rotationPartSchody2.node, unpack(newRot));
	end;

	
	if self.kogutAnz > 0 then
		if self.kogutAn then
			for i=1, self.kogutAnz do
			rotate(self.kogut[i].rotNode, 0, dt*self.kogut[i].speed, 0);
			end;
		end;
	end;

	
	if self.flash then
		if self.delayOn >= 0 then
			self.delayOn = self.delayOn -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOn < 0 then
				self.delayOff = 500;
				self.flashlightsRightActive = true;
				self.flashlightsLeftActive = true;
				self.flashlightsWarnerActive = true;
				self.kierunek2Active = true;
				self.kierunekActive = true;
				playSample(self.turn1, 1, 0.7, 0);
			end;
		end;
		if self.delayOff >= 0 then
			self.delayOff = self.delayOff -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOff < 0 then
				self.delayOn = 500;
				self.flashlightsLeftActive = false;
				self.flashlightsRightActive = false;
				self.flashlightsWarnerActive = false;
				self.kierunek2Active = false;
				self.kierunekActive = false;
				playSample(self.turn2, 1, 0.7, 0);
			end;
		end;
	end;
	
	if self.flashRight then
		if self.delayOnRight >= 0 then
			self.delayOnRight = self.delayOnRight -dt;
		end;
		if not self.flashlightsRightActive then
			if self.delayOnRight < 0 then
				self.delayOffRight = 500;
				self.flashlightsRightActive = true;
				self.kierunek2Active = true;
				playSample(self.turn1,1,0.7,0);
			end;
		end;
		if self.delayOffRight >= 0 then
			self.delayOffRight = self.delayOffRight -dt;
		end;
		if self.flashlightsRightActive then
			if self.delayOffRight < 0 then
				self.delayOnRight = 500;
				self.flashlightsRightActive = false;
				self.kierunek2Active = false;
				playSample(self.turn2,1,0.7,0);
			end;
		end;
	else
		if not self.flashWarner then
			self.kierunek2Active = false;
		end;
	end;
	
	
		if self.flashLeft then
			if self.delayOnLeft >= -1 then
				self.delayOnLeft = self.delayOnLeft -dt;
			end;
			if not self.flashlightsLeftActive then
				if self.delayOnLeft < 0 then
					self.delayOffLeft = 500;
					self.flashlightsLeftActive = true;
					self.kierunekActive = true;
					playSample(self.turn1,1,0.7,0);
				end;
			end;
			if self.delayOffLeft >= 0 then
				self.delayOffLeft = self.delayOffLeft -dt;
			end;
			if self.flashlightsLeftActive then
				if self.delayOffLeft < 0 then
					self.delayOnLeft = 500;
					self.flashlightsLeftActive = false;
					self.kierunekActive = false;
					playSample(self.turn2,1,0.7,0);
				end;
			end;
		else
			if not self.flashWarner then
				self.kierunekActive = false;
			end;
		end;

setVisibility(self.kierunek, self.kierunekActive);
setVisibility(self.kierunek2, self.kierunek2Active); 
	

	if self:getIsActive() then


        if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
            if self.currentChopperParticleSystem ~= nil then
                Utils.setEmittingState(self.currentChopperParticleSystem, false);
            end;
            self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
            if self.currentChopperParticleSystem == nil then
                self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
            end;
            Utils.setEmittingState(self.currentChopperParticleSystem, true);
            self.chopperEnableTime = nil;
        end;
        if self.strawEnableTime ~= nil and self.strawEnableTime <= self.time then
            if self.currentStrawParticleSystem ~= nil then
                Utils.setEmittingState(self.currentStrawParticleSystem, false);
            end;
            self.currentStrawParticleSystem = self.strawParticleSystems[self.currentGrainTankFruitType];
            if self.currentStrawParticleSystem == nil then
                self.currentStrawParticleSystem = self.defaultStrawParticleSystem;
            end;
			Utils.setEmittingState(self.currentStrawParticleSystem, true);
            self.strawEnableTime = nil;
            self.strawEmitState = true;
        end;
        if self.strawEmitState then
            for k, strawArea in pairs(self.strawAreas) do
                local x,y,z = getWorldTranslation(strawArea.start);
                local x1,y1,z1 = getWorldTranslation(strawArea.width);
                local x2,y2,z2 = getWorldTranslation(strawArea.height);
                local old, total = Utils.getFruitWindrowArea(self.currentGrainTankFruitType, x, z, x1, z1, x2, z2);
                local value = 1+math.floor(old / total + 0.7); -- round, biased to the bigger value
                value = math.min(value, g_currentMission.maxWindrowValue);
                Utils.updateFruitWindrowArea(self.currentGrainTankFruitType, x, z, x1, z1, x2, z2, value, true);
            end;
        end;

    end;

    if self.chopperDisableTime ~= nil and self.chopperDisableTime <= self.time then
        if self.currentChopperParticleSystem ~= nil then
            Utils.setEmittingState(self.currentChopperParticleSystem, false);
        end;
        self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
        if self.currentChopperParticleSystem == nil then
            self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
        end;
        Utils.setEmittingState(self.currentChopperParticleSystem, false);
        self.chopperDisableTime = nil;
    end;
    if self.strawDisableTime ~= nil and self.strawDisableTime <= self.time then
        if self.currentStrawParticleSystem ~= nil then
            Utils.setEmittingState(self.currentStrawParticleSystem, false);
        end;
        self.currentStrawParticleSystem = self.strawParticleSystems[self.currentGrainTankFruitType];
        if self.currentStrawParticleSystem == nil then
            self.currentStrawParticleSystem = self.defaultStrawParticleSystem;
        end;
        Utils.setEmittingState(self.currentStrawParticleSystem, false);
        self.strawDisableTime = nil;
        self.strawEmitState = false;
    end;

    self.lastUnloadingTrailer = nil;
    self.pipeParticleActivated = false;
    if self.pipeOpen then
        if self.grainTankFillLevel > 0 then
            self.pipeParticleActivated = true;
            -- test if we should drain the grain tank
            self.trailerFound = 0;
            local x,y,z = getWorldTranslation(self.pipeRaycastNode);
            raycastAll(x, y, z, 0, -1, 0, "findTrailerRaycastCallback", 10, self);

            local trailer = g_currentMission.objectToTrailer[self.trailerFound];
            self.lastUnloadingTrailer = trailer;
            if self.trailerFound == 0 or trailer == nil or not trailer:allowFillType(self.currentGrainTankFruitType, true) or not trailer.allowFillFromAir then
                self.pipeParticleActivated = false;
            else
                local deltaLevel = self.grainTankUnloadingCapacity*dt/1000.0;
                deltaLevel = math.min(deltaLevel, trailer.capacity - trailer.fillLevel);

                self.grainTankFillLevel = self.grainTankFillLevel-deltaLevel;
                if self.grainTankFillLevel <= 0.0 then
                    deltaLevel = deltaLevel+self.grainTankFillLevel;
                    self.grainTankFillLevel = 0.0;
                    self.pipeParticleActivated = false;
                end;
                if deltaLevel == 0 then
                    self.pipeParticleActivated = false;
                end;
                self:setGrainTankFillLevel(self.grainTankFillLevel, self.currentGrainTankFruitType);
                trailer:setFillLevel(trailer.fillLevel+deltaLevel, self.currentGrainTankFruitType);
            end;
        end;
    end;

    if self.currentGrainTankFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN then
        if self.currentPipeParticleSystem ~= nil then
            Utils.setEmittingState(self.currentPipeParticleSystem, false);
        end;
        if self.pipeParticleActivated then
            self.currentPipeParticleSystem = self.pipeParticleSystems[self.currentGrainTankFruitType];
            if self.currentPipeParticleSystem == nil then
                self.currentPipeParticleSystem = self.defaultPipeParticleSystem;
            end;
            Utils.setEmittingState(self.currentPipeParticleSystem, true);
        end;
    end;
------------------------------SIECZKARNIA------------------------------------
 
	if self:getIsActive() then
		if not self.slomaActive then
		    self.strawEmitState = false;
			self.strawEnableTime = nil;
			self.chopperActivated = true;
		if self.lastArea > 0 then
		    if self.chopperActivated then
                if self.chopperEnableTime == nil then
                       self.chopperEnableTime = self.time + self.chopperToggleTime;
                  else
                    self.chopperDisableTime = nil;
				end;
                  self.disableChopperEmit = false;
			    end;
				if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
					self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
					if self.currentChopperParticleSystem == nil then
						self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
					end;
				end;
			end;	
	  		if not self.isThreshing then
				Utils.setEmittingState(self.currentChopperParticleSystem, false);
			end;
		end;
    end;


	------------------------------SIECZKARNIA------------------------------------
	-------------------------------OBRACANIE----------------------------------
	if self.rotationPartsieczkarnia ~= nil then
		local x, y, z = getRotation(self.rotationPartsieczkarnia.node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartsieczkarnia.maxRot, self.rotationPartsieczkarnia.minRot, 3, self.rotationPartsieczkarnia.rotTime, dt, not self.rotationMaxsieczkarnia);
		setRotation(self.rotationPartsieczkarnia.node, unpack(newRot));
	end;
	
	
end;	
--**********************************************************
function C_lexion:draw()
   	
   	if self.ChudOverlay ~= nil then
		if self.bcActive then
		self.ChudOverlay:render();
	end;
		end;
   if self.bcActive then
		setTextColor(1,1,1,1);
		renderText(0.8335, 0.165, 0.02, "0: Wylacz Pomoc");
	else
		setTextColor(1,1,1,1);
		renderText(0.8335, 0.165, 0.02, "0: Wlacz Pomoc");
	end;

	if self.bcActive then
		renderText(0.055, 0.49, 0.027, " --->Kombajn<---");
	
	if self.slomaActive then
		renderText(0.0515, 0.46, 0.020, "Wlacz sieczkarnie: z");
	else
		renderText(0.0515, 0.46, 0.020, "Wylacz sieczkarnie: z");
	end;

	if self.kogutAn  then
		renderText(0.0515, 0.44, 0.020, "Wylacz kogut: r");
	else
		renderText(0.0515, 0.44, 0.020, "Wlacz kogut: r");
	end;
	if self.halogenyPActive  then
		renderText(0.0515, 0.42, 0.020, "Wylacz halogeny przednie: 5");
	else
		renderText(0.0515, 0.42, 0.020, "Wlacz halogeny przednie: 5");
	end;
	if self.halogenyTActive  then
		renderText(0.0515, 0.40, 0.020, "Wylacz halogeny tylnie: 6");
	else
		renderText(0.0515, 0.40, 0.020, "Wlacz halogeny tylnie: 6");
	end;
	if self.flashLeft  then
		renderText(0.0515, 0.38, 0.020, "Wylacz kierunek lewy: n");
	else
		renderText(0.0515, 0.38, 0.020, "Wlacz kierunek lewy: n");
	end;
	if self.flash  then
		renderText(0.0515, 0.36, 0.020, "Wylacz awaryjne: k");
	else
		renderText(0.0515, 0.36, 0.020, "Wlacz awaryjne: k");
	end;
	if self.flashRight  then
		renderText(0.0515, 0.34, 0.020, "Wylacz kierunek prawy: m");
	else
		renderText(0.0515, 0.34, 0.020, "Wlacz kierunek prawy: m");
	end;
	
	end;
end;
--**********************************************************
function C_lexion:onEnter()
	
end;
--**********************************************************
function C_lexion:onLeave()
  
end;
--**********************************************************
function C_lexion:onDeactivate()
  
end;
--**********************************************************
function C_lexion:onDeactivateSounds()
   
end;
--**********************************************************
function C_lexion:attachImplement(implement)
   	local object = implement.object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
        self.attachedCutters[object] = implement;
        self.numAttachedCutters = self.numAttachedCutters+1;
       
        object:setFruitType(self.currentGrainTankFruitType);
		self.rotationMaxklapa = false;
		self.rotationMaxklapa2 = false;
		self.rotationMaxklapa3 = false;
		self.rotationMaxklapa4 = false;
		self.rotationMaxSchody = false;
		self.rotationMaxSchody2 = false;
	end;
		

end;
--**********************************************************
function C_lexion:detachImplement(implementIndex)
   	local object = self.attachedImplements[implementIndex].object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
        self.numAttachedCutters = self.numAttachedCutters-1;
        if self.numAttachedCutters == 0 then
            self:stopThreshing()
			self.rotationMaxklapa = true;
			self.rotationMaxklapa2 = true;
			self.rotationMaxklapa3 = true;
			self.rotationMaxklapa4 = true;
			self.rotationMaxSchody = true;
			self.rotationMaxSchody2 = true;
		end;
        self.attachedCutters[object] = nil;
		
   end;
		
		


end;
--**********************************************************
function C_lexion:startThreshing()
	

	
end;
--**********************************************************
function C_lexion:stopThreshing()

 
end;
--**********************************************************
function C_lexion:openPipe()
  
end;



