--
-- TerraTrac
-- Specialization for TerraTrac
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		26/09/11
-- @history:	v1.0 - Initial version
--

TerraTrac = {};

function TerraTrac.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cylindered, specializations);
end;

function TerraTrac:load(xmlFile)

	self.terraTracs = {};
	local i=0;
    while true do
        local tracKey = string.format("vehicle.terraTracs.trac(%d)", i);
        if not hasXMLProperty(xmlFile, tracKey .. "#index") then
            break;
        end;
		local trac = {};
		
		trac.node = Utils.indexToObject(self.components, getXMLString(xmlFile, tracKey .. "#index"));
		trac.nodeOffset = 0;
		local tracMovingPartIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, tracKey .. "#tracMovingPartIndex"));
		trac.movingPart = nil;
		for _, part in pairs(self.movingParts) do
			if part.node == tracMovingPartIndex then
				trac.movingPart = part;
			end;
		end;
		trac.wheel1 = self.wheels[getXMLInt(xmlFile, tracKey .. "#wheel1")].repr;
		trac.wheel2 = self.wheels[getXMLInt(xmlFile, tracKey .. "#wheel2")].repr;
		trac.wheel1DistNode = Utils.indexToObject(self.components, getXMLString(xmlFile, tracKey .. "#wheel1DistNode"));
		trac.wheel2DistNode = Utils.indexToObject(self.components, getXMLString(xmlFile, tracKey .. "#wheel2DistNode"));
		local x,y,z = getWorldTranslation(trac.wheel1);
		local xd,yd,zd = getWorldTranslation(trac.wheel1DistNode);
		trac.wheel1Distance = Utils.vector3Length(x-xd, y-yd, z-zd); --math.abs(y - yd);
		x,y,z = getWorldTranslation(trac.wheel2);
		xd,yd,zd = getWorldTranslation(trac.wheel2DistNode);
		trac.wheel2Distance = Utils.vector3Length(x-xd, y-yd, z-zd);
		
		trac.speed = Utils.getNoNil(getXMLFloat(xmlFile, tracKey .. "#speed"), 10);
		trac.wheels = {};
		local j=0;
		while true do
			local wheelKey = string.format(tracKey .. ".wheel(%d)", j);
			if not hasXMLProperty(xmlFile, wheelKey .. "#index") then
				break;
			end;
			local wheel = {};
			wheel.node = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelKey .. "#index"));
			wheel.lastRotation = {getRotation(wheel.node)};
			if hasXMLProperty(xmlFile, wheelKey .. "#rotAlignIndex") then
				wheel.rotAlignNode = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelKey .. "#rotAlignIndex"));
			end;
			if hasXMLProperty(xmlFile, wheelKey .. "#transAlignIndex") then
				wheel.transAlignNode = Utils.indexToObject(self.components, getXMLString(xmlFile, wheelKey .. "#transAlignIndex"));
			end;
			table.insert(trac.wheels, wheel);
			j = j + 1;
		end;
		
		table.insert(self.terraTracs, trac);
		i = i + 1;
	end;
	
	self.updateTerraTrac = 200;
end;

function TerraTrac:delete()
end;

function TerraTrac:readStream(streamId, connection)
end;

function TerraTrac:writeStream(streamId, connection)
end;

function TerraTrac:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TerraTrac:keyEvent(unicode, sym, modifier, isDown)
end;

function TerraTrac:update(dt)
	if self:getIsActive() then
		self.updateTerraTrac = 200;		
	end;
	
	if self.updateTerraTrac > 0 then
		for _, trac in pairs(self.terraTracs) do
			if trac.movingPart ~= nil then
				Cylindered.updateMovingPart(self, trac.movingPart);	
			end;			
			local dif = nil;
			for _, wheel in pairs(trac.wheels) do
				if wheel.rotAlignNode ~= nil then
					local currentRotation = {getRotation(wheel.rotAlignNode)};
					if dif == nil then
						dif = currentRotation[1] - wheel.lastRotation[1];
					end;
					wheel.lastRotation = currentRotation;
					setRotation(wheel.node, unpack(wheel.lastRotation));
				end;
				if wheel.transAlignNode ~= nil then					
					local x,y,z = getWorldTranslation(wheel.transAlignNode);
					Utils.setWorldTranslation(wheel.node, x,y,z);
				end;
			end;
			trac.nodeOffset = trac.nodeOffset + trac.speed * dif;
			setShaderParameter(trac.node, "Offset", trac.nodeOffset, 0,0,0, false);
			
			local x,y,z = getWorldTranslation(trac.wheel1);
			local xd,yd,zd = getWorldTranslation(trac.wheel1DistNode);
			local wheel1Offset = Utils.vector3Length(x-xd, y-yd, z-zd) - trac.wheel1Distance;			
			x,y,z = getWorldTranslation(trac.wheel2);
			xd,yd,zd = getWorldTranslation(trac.wheel2DistNode);
			local wheel2Offset = Utils.vector3Length(x-xd, y-yd, z-zd) - trac.wheel2Distance;
			
			local _,_,z1 = worldToLocal(trac.node, getWorldTranslation(trac.wheel1));
			local _,_,z2 = worldToLocal(trac.node, getWorldTranslation(trac.wheel2));

			setShaderParameter(trac.node, "Wheels", wheel1Offset, wheel2Offset, z1, z2, false);
		end;
		self.updateTerraTrac = self.updateTerraTrac - 1;
	end;	
end;

function TerraTrac:updateTick(dt)
end;

function TerraTrac:draw()	
end;