--
-- CustomForces
-- Specialization for CustomForces
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		02/11/11
-- @history:	v1.0 - Initial version
--

CustomForces = {};

function CustomForces.prerequisitesPresent(specializations)
    return true;
end;

function CustomForces:load(xmlFile)
	
	if self.isServer then
		self.customForces = {};
		local i=0;
		while true do
			local forceKey = string.format("vehicle.customForces.customForce(%d)", i);
			if not hasXMLProperty(xmlFile, forceKey .. "#node") then
				break;
			end;
			local force = {};
			
			local node = getXMLInt(xmlFile, forceKey .. "#node");
			force.node = self.components[node].node;
			local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, forceKey .. "#position"));
			force.pos = {};
			force.pos.x = x;
			force.pos.y = y;
			force.pos.z = z;
			x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, forceKey .. "#positionRev"));
			if x ~= nil then
				force.revPos = {};
				force.revPos.x = x;
				force.revPos.y = y;
				force.revPos.z = z;
			end;
			force.force = Utils.getNoNil(getXMLFloat(xmlFile, forceKey .. "#force"), 25);
			force.forceRev = Utils.getNoNil(getXMLFloat(xmlFile, forceKey .. "#forceRev"), 25);
			
			local wheelIndex = getXMLInt(xmlFile, forceKey .. "#wheel");
			if wheelIndex ~= nil then
				force.wheel = self.wheels[wheelIndex];	
				force.onMinAngle = Utils.getNoNil(getXMLBool(xmlFile, forceKey .. "#onMinAngle"), false);
			end;
			
			local speed = getXMLFloat(xmlFile, forceKey .. "#maxSpeed");
			local speedRev = getXMLFloat(xmlFile, forceKey .. "#maxSpeedRev");
			if speed ~= nil then
				force.speed = speed;
				force.speedRev = speedRev;
			end;
			
			table.insert(self.customForces, force);
			i = i + 1;
		end;
	end;
end;

function CustomForces:delete()
end;

function CustomForces:readStream(streamId, connection)
end;

function CustomForces:writeStream(streamId, connection)
end;

function CustomForces:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CustomForces:keyEvent(unicode, sym, modifier, isDown)
end;

function CustomForces:update(dt)
	if self.isServer then
		if self:getIsActive() then
			for _, customForce in pairs(self.customForces) do	
				local forcing = customForce.force;
				local speed = customForce.speed;
				local pos = customForce.pos;
				if self.movingDirection < 0 then
					if customForce.revPos ~= nil then
						pos = customForce.revPos;
					end;
					if customForce.speedRev ~= nil then
						speed = customForce.speedRev;
					end;
					if customForce.forceRev ~= nil then
						forcing = customForce.forceRev;
					end;
				end;
				
				if customForce.wheel ~= nil then
					local wheel = customForce.wheel;
					local force = customForce.force;
					local maxAngle = wheel.rotMax;
					if customForce.onMinAngle then
						maxAngle = wheel.rotMin;
						if wheel.steeringAngle > 0 then
							force = 0;
						end;
					else
						if wheel.steeringAngle < 0 then
							force = 0;
						end;
					end;					
					forcing = force * (wheel.steeringAngle / maxAngle);
				end;
				
				if speed ~= nil then
					forcing = forcing * math.abs(math.min((self.lastSpeed*3600 / speed), 1));
				end;
				
				local worldX,worldY,worldZ = localDirectionToWorld(customForce.node, 0, -forcing*dt/1000, 0);
				if Vehicle.debugRendering then
					local x,y,z = localToWorld(customForce.node, pos.x, pos.y, pos.z);
					drawDebugPoint(x, y, z, 1,0,0,1);
					drawDebugLine(x, y, z, 1,0,0, x+(worldX*2), y+(worldY*2), z+(worldZ*2), 1,0,0);
				end;
				
				addForce(customForce.node, worldX, worldY, worldZ, pos.x, pos.y, pos.z, true);	
			end;
		end;
	end;
end;

function CustomForces:updateTick(dt)
end;

function CustomForces:draw()	
end;