
Roboczy = {};

function Roboczy.prerequisitesPresent(specializations)
    return true;
	end;

function Roboczy:load(xmlFile)
    local rotationPartNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart#index"));
    if rotationPartNode ~= nil then
        self.rotationPart = {};
        self.rotationPart.node = rotationPartNode;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#minRot"));
        self.rotationPart.minRot = {};
        self.rotationPart.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart#maxRot"));
        self.rotationPart.maxRot = {};
        self.rotationPart.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#rotTime"), 2)*1000;
        self.rotationPart.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart#touchRotLimit"), 10));
     end;
     
     
     local rotationPartNode2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart2#index"));
     if rotationPartNode2 ~= nil then
        self.rotationPart2 = {};
        self.rotationPart2.node = rotationPartNode2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#minRot"));
        self.rotationPart2.minRot = {};
        self.rotationPart2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart2#maxRot"));
        self.rotationPart2.maxRot = {};
        self.rotationPart2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#rotTime"), 2)*1000;
        self.rotationPart2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart2#touchRotLimit"), 10));
     end;
     
     
     local rotationPartNode3 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart3#index"));
     if rotationPartNode3 ~= nil then
        self.rotationPart3 = {};
        self.rotationPart3.node = rotationPartNode3;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#minRot"));
        self.rotationPart3.minRot = {};
        self.rotationPart3.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart3#maxRot"));
        self.rotationPart3.maxRot = {};
        self.rotationPart3.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart3.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart3.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart3.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#rotTime"), 2)*1000;
        self.rotationPart3.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart3#touchRotLimit"), 10));
     end;
     
     
     local rotationPartNode4 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart4#index"));
     if rotationPartNode4 ~= nil then
        self.rotationPart4 = {};
        self.rotationPart4.node = rotationPartNode4;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#minRot"));
        self.rotationPart4.minRot = {};
        self.rotationPart4.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart4#maxRot"));
        self.rotationPart4.maxRot = {};
        self.rotationPart4.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart4.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart4.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart4.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#rotTime"), 2)*1000;
        self.rotationPart4.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart4#touchRotLimit"), 10));
     end;
     
     
     local rotationPartNode5 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPart5#index"));
     if rotationPartNode5 ~= nil then
        self.rotationPart5 = {};
        self.rotationPart5.node = rotationPartNode5;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#minRot"));
        self.rotationPart5.minRot = {};
        self.rotationPart5.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPart5#maxRot"));
        self.rotationPart5.maxRot = {};
        self.rotationPart5.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPart5.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPart5.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPart5.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#rotTime"), 2)*1000;
        self.rotationPart5.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPart5#touchRotLimit"), 10));
     end;

end;
	
	
function Roboczy:draw()	
	if self:getIsActiveForInput()then
            g_currentMission:addExtraPrintText("Work Mode K");
	end;
end;
		
		
function Roboczy:update(dt)
	if self:getIsActiveForInput()then

		if InputBinding.hasEvent(InputBinding.Roboczy) then 
			self.robocza = not self.robocza;
		end;
		
		if self.robocza then
			self.rotationMax = true;
			self.rotationMax2 = true;
			self.rotationMax3 = true;
			self.rotationMax4 = true;
			self.rotationMax5 = true;
		else
			self.rotationMax = false;
			self.rotationMax2 = false;
			self.rotationMax3 = false;
			self.rotationMax4 = false;
			self.rotationMax5 = false;		
		end;
		
		
        if self.rotationPart ~= nil then
          local x, y, z = getRotation(self.rotationPart.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart.maxRot, self.rotationPart.minRot, 3, self.rotationPart.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart.node, unpack(newRot));
        end;
        
        if self.rotationPart2 ~= nil then
          local x, y, z = getRotation(self.rotationPart2.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart2.maxRot, self.rotationPart2.minRot, 3, self.rotationPart2.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart2.node, unpack(newRot));
        end;
        
        if self.rotationPart3 ~= nil then
          local x, y, z = getRotation(self.rotationPart3.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart3.maxRot, self.rotationPart3.minRot, 3, self.rotationPart3.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart3.node, unpack(newRot));
        end;
        
        if self.rotationPart4 ~= nil then
          local x, y, z = getRotation(self.rotationPart4.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart4.maxRot, self.rotationPart4.minRot, 3, self.rotationPart4.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart4.node, unpack(newRot));
        end;
        
        if self.rotationPart5 ~= nil then
          local x, y, z = getRotation(self.rotationPart5.node);
           local rot = {x,y,z};
            local newRot = Utils.getMovedLimitedValues(rot, self.rotationPart5.maxRot, self.rotationPart5.minRot, 3, self.rotationPart5.rotTime, dt, not self.rotationMax);
              setRotation(self.rotationPart5.node, unpack(newRot));
        end;
		
	end;

end;

function Roboczy:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)  
  if not resetVehicles then
	local robocza = getXMLBool(xmlFile, key.."#robocza");
	if robocza then
	   self.robocza = true;
	end;
  end;
end;

function Roboczy:getSaveAttributesAndNodes(nodeIdent)
   local attributes = 'robocza="'..tostring(self.robocza)..'"';
   return attributes, nil;
end;

function Roboczy:delete()
end;	

function Roboczy:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Roboczy:keyEvent(unicode, sym, modifier, isDown)
end;	
