SetToggleLeftFlapEvent = {};
SetToggleLeftFlapEvent_mt = Class(SetToggleLeftFlapEvent, Event);

InitEventClass(SetToggleLeftFlapEvent, "SetToggleLeftFlapEvent");

function SetToggleLeftFlapEvent:emptyNew()
    local self = Event:new(SetToggleLeftFlapEvent_mt);
    self.className="SetToggleLeftFlapEvent";
    return self;
end;

function SetToggleLeftFlapEvent:new(vehicle, leftFlapState)
    local self = SetToggleLeftFlapEvent:emptyNew()
    self.vehicle = vehicle;
	self.leftFlapState = leftFlapState;
    return self;
end;

function SetToggleLeftFlapEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.leftFlapState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetToggleLeftFlapEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.leftFlapState);
end;

function SetToggleLeftFlapEvent:run(connection)   
	self.vehicle:setToggleLeftFlap(self.leftFlapState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetToggleLeftFlapEvent:new(self.vehicle, self.leftFlapState), nil, connection, self.vehicle);
    end;
end;

function SetToggleLeftFlapEvent.sendEvent(vehicle, leftFlapState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetToggleLeftFlapEvent:new(vehicle, leftFlapState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetToggleLeftFlapEvent:new(vehicle, leftFlapState));
		end;
	end;
end;