SetToggleAdapterEvent = {};
SetToggleAdapterEvent_mt = Class(SetToggleAdapterEvent, Event);

InitEventClass(SetToggleAdapterEvent, "SetToggleAdapterEvent");

function SetToggleAdapterEvent:emptyNew()
    local self = Event:new(SetToggleAdapterEvent_mt);
    self.className="SetToggleAdapterEvent";
    return self;
end;

function SetToggleAdapterEvent:new(vehicle, adapterState)
    local self = SetToggleAdapterEvent:emptyNew()
    self.vehicle = vehicle;
	self.adapterState = adapterState;
    return self;
end;

function SetToggleAdapterEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.adapterState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetToggleAdapterEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.adapterState);
end;

function SetToggleAdapterEvent:run(connection)   
	self.vehicle:setToggleAdapter(self.adapterState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetToggleAdapterEvent:new(self.vehicle, self.adapterState), nil, connection, self.vehicle);
    end;
end;

function SetToggleAdapterEvent.sendEvent(vehicle, adapterState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetToggleAdapterEvent:new(vehicle, adapterState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetToggleAdapterEvent:new(vehicle, adapterState));
		end;
	end;
end;