ManureSpreaderMulti = {};

function ManureSpreaderMulti.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function ManureSpreaderMulti:load(xmlFile)
	self.setIsTurnedOn = SpecializationUtil.callSpecializationsFunction("setIsTurnedOn");
	self.setToggleGrid = SpecializationUtil.callSpecializationsFunction("setToggleGrid");
	self.setToggleCover = SpecializationUtil.callSpecializationsFunction("setToggleCover");
	self.setToggleAdapter = SpecializationUtil.callSpecializationsFunction("setToggleAdapter");
	
	self.setToggleLeftFlap = SpecializationUtil.callSpecializationsFunction("setToggleLeftFlap");
	self.setToggleRightFlap = SpecializationUtil.callSpecializationsFunction("setToggleRightFlap");
	
	self.leftFlapAnimation = getXMLString(xmlFile, "vehicle.leftFlap#animationName");
	self.rightFlapAnimation = getXMLString(xmlFile, "vehicle.rightFlap#animationName");
	self.leftFlapActive = true;
	self.rightFlapActive = true;

	self.grid = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.grid#index"));
    self.gridActive = true;
	
	self.cover = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cover#index"));
    self.coverActive = false;
	
	self.adapter = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.adapter#index"));
	self.backFlap = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.backFlap#index"));
    self.adapterActive = true;
	
    self.UVScrollParts = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.UVScrollParts.UVScrollPart(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speed = Utils.getVectorNFromString(getXMLString(xmlFile, key.."#speed"), 2);
        if node ~= nil and speed then
            table.insert(self.UVScrollParts, {node=node, speed=speed});
        end;
        i = i +1;
    end;
end;

function ManureSpreaderMulti:delete()
end;

function ManureSpreaderMulti:readStream(streamId, connection)
	self:setToggleGrid(streamReadBool(streamId), true);
	self:setToggleCover(streamReadBool(streamId), true);
	self:setToggleAdapter(streamReadBool(streamId), true);
	self:setToggleLeftFlap(streamReadBool(streamId), true);
	self:setToggleRightFlap(streamReadBool(streamId), true);
end;

function ManureSpreaderMulti:writeStream(streamId, connection)
	streamWriteBool(streamId, self.gridActive);
	streamWriteBool(streamId, self.coverActive);
	streamWriteBool(streamId, self.adapterActive);
	streamWriteBool(streamId, self.leftFlapActive);
	streamWriteBool(streamId, self.rightFlapActive);
end;

function ManureSpreaderMulti:readUpdateStream(streamId, timestamp, connection)
end;

function ManureSpreaderMulti:writeUpdateStream(streamId, connection, dirtyMask)
end;

function ManureSpreaderMulti:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ManureSpreaderMulti:keyEvent(unicode, sym, modifier, isDown)
end;

function ManureSpreaderMulti:update(dt)
    if self:getIsActiveForInput() then
        if InputBinding.hasEvent(InputBinding.ManureSpreaderMulti_TOGGLEGRID) then
            self:setToggleGrid(not self.gridActive);
        end;
		if InputBinding.hasEvent(InputBinding.ManureSpreaderMulti_TOGGLELEFTFLAP) then
            self:setToggleLeftFlap(not self.leftFlapActive);
        end;
		if InputBinding.hasEvent(InputBinding.ManureSpreaderMulti_TOGGLERIGHTFLAP) then
            self:setToggleRightFlap(not self.rightFlapActive);
        end;
		if self.currentFillType ~= Fillable.FILLTYPE_MANURE then
			if InputBinding.hasEvent(InputBinding.ManureSpreaderMulti_TOGGLECOVER) then
				self:setToggleCover(not self.coverActive);
			end;
			if InputBinding.hasEvent(InputBinding.ManureSpreaderMulti_TOGGLEADAPTER) then
				self:setToggleAdapter(not self.adapterActive);
			end;
		end;
    end;
	
	if self.currentFillType ~= Fillable.FILLTYPE_MANURE then
		if self.isTurnedOn then
			self:setIsTurnedOn(false);
		end;
	elseif self.currentFillType == Fillable.FILLTYPE_MANURE then
		if self.adapterActive == false then
			self:setToggleAdapter(true);
		end;
		if self.coverActive == true then
			self:setToggleCover(false);
		end;
	end;
end;

function ManureSpreaderMulti:updateTick(dt)
end;

function ManureSpreaderMulti:draw()
	if self.gridActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("ManureSpreaderMulti_hideGrid"),  InputBinding.ManureSpreaderMulti_TOGGLEGRID);
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("ManureSpreaderMulti_showGrid"),  InputBinding.ManureSpreaderMulti_TOGGLEGRID);
	end;
	if self.currentFillType ~= Fillable.FILLTYPE_MANURE then
		if self.coverActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("ManureSpreaderMulti_hideCover"),  InputBinding.ManureSpreaderMulti_TOGGLECOVER);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ManureSpreaderMulti_showCover"),  InputBinding.ManureSpreaderMulti_TOGGLECOVER);
		end;
		if self.adapterActive then
			g_currentMission:addHelpButtonText(g_i18n:getText("ManureSpreaderMulti_hideAdapter"),  InputBinding.ManureSpreaderMulti_TOGGLEADAPTER);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("ManureSpreaderMulti_showAdapter"),  InputBinding.ManureSpreaderMulti_TOGGLEADAPTER);
		end;
	end;
end;

function ManureSpreaderMulti:onDetach()
    for _, part in pairs(self.UVScrollParts) do
        setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
    end;
end;

function ManureSpreaderMulti:onLeave()
    for _, part in pairs(self.UVScrollParts) do
        setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
    end;
end;

function ManureSpreaderMulti:onDeactivate()
    for _, part in pairs(self.UVScrollParts) do
        setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
    end;
end;

function ManureSpreaderMulti:setToggleGrid(gridState, noEventSend)
	SetToggleGridEvent.sendEvent(self, gridState, noEventSend);
    self.gridActive = gridState;
    setVisibility(self.grid, gridState);	
end;

function ManureSpreaderMulti:setToggleCover(coverState, noEventSend)
	SetToggleCoverEvent.sendEvent(self, coverState, noEventSend);
    self.coverActive = coverState;
    setVisibility(self.cover, coverState);	
end;

function ManureSpreaderMulti:setToggleAdapter(adapterState, noEventSend)
	SetToggleAdapterEvent.sendEvent(self, adapterState, noEventSend);
    self.adapterActive = adapterState;
    setVisibility(self.adapter, adapterState);
	setVisibility(self.backFlap, not adapterState);	
end;

function ManureSpreaderMulti:setToggleLeftFlap(leftFlapState,noEventSend)
	SetToggleLeftFlapEvent.sendEvent(self, leftFlapState, noEventSend);
	if leftFlapState then
		if self.leftFlapAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.leftFlapAnimation, -1, nil, true);
			self.leftFlapActive = true;
		end;
	else
		if self.leftFlapAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.leftFlapAnimation, 1, nil, true);
			self.leftFlapActive = false;
		end;
	end;
end;

function ManureSpreaderMulti:setToggleRightFlap(rightFlapState,noEventSend)
	SetToggleRightFlapEvent.sendEvent(self, rightFlapState, noEventSend);
	if rightFlapState then
		if self.rightFlapAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rightFlapAnimation, -1, nil, true);
			self.rightFlapActive = true;
		end;
	else
		if self.rightFlapAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.rightFlapAnimation, 1, nil, true);
			self.rightFlapActive = false;
		end;
	end;
end;

function ManureSpreaderMulti:setIsTurnedOn(turnedOn, noEventSend)
    SetTurnedOnEvent.sendEvent(self, turnedOn, noEventSend)
    self.isTurnedOn = turnedOn;
	for _, part in pairs(self.UVScrollParts) do
		if self.isTurnedOn then
			setShaderParameter(part.node, "uvScrollSpeed", part.speed[1], part.speed[2], 0, 0, false);
		else
			setShaderParameter(part.node, "uvScrollSpeed", 0, 0, 0, 0, false);
		end;
    end;
end;