--
-- Allrad V2.1
-- Specialization for Tractor
-- Edit Fumski
-- Www.LS-Modteam.pl
-- MP Ready!

AllradV21 = {};

function AllradV21.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function AllradV21:load(xmlFile)

    self.allradState = AllradV21.allradState;
    self.AllradV21Active = false;
	self.wellenCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.Allradwellen.Wellen#count"), 0);	 
	self.Wellen = {}
	if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	    for i=1, self.wellenCount do
	        local Welle = string.format("vehicle.Allradwellen.Welle%d", i)
		    self.Wellen[i] = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, Welle .. "#index"));
	    end;
	end;
	self.hudAllradPosX = 0.65;
    self.hudAllradWidth = 0.1;
    self.hudAllradPosY = 0;
    self.hudAllradHeight = 0.15;
	self.infoPanelAllradPath = Utils.getFilename("tex/4x4.png", self.baseDirectory);
	self.hudAllradOverlay = Overlay:new("hudAllradOverlay", self.infoPanelAllradPath, self.hudAllradPosX, self.hudAllradPosY, self.hudAllradWidth, self.hudAllradHeight);
	self.showhudAllrad = false;

end;

function AllradV21:delete()
    if self.hudAllradOverlay ~= nil then
		self.hudAllradOverlay:delete();
	end;
end;

function AllradV21:readStream(streamId, connection)  
    self:allradState(streamReadBool(streamId), true);  
end;

function AllradV21:writeStream(streamId, connection)  
    streamWriteBool(streamId, self.AllradV21Active);  
end;

function AllradV21:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AllradV21:keyEvent(unicode, sym, modifier, isDown)
end;

function AllradV21:allradState(state, noEventSend)  
    AllradStateEvent.sendEvent(self, state, noEventSend);	
    self.AllradV21Active = state;
end;

function AllradV21:update(dt)
    if self:getIsActiveForInput() then  
		if InputBinding.hasEvent(InputBinding.AllradV21) then
		   	self.AllradV21Active = not self.AllradV21Active;
		end;
    end;	
	if self:getIsActive() then	
   		if self.AllradV21Active == true then
			self.showhudAllrad = true;		
			self.wheels[1].driveMode =2
		 	self.wheels[2].driveMode =2
		 	self.wheels[3].driveMode =2
		 	self.wheels[4].driveMode =2			
		else
			self.showhudAllrad = false;
		 	self.wheels[1].driveMode =0
			self.wheels[2].driveMode =0
			self.wheels[3].driveMode =2
			self.wheels[4].driveMode =2			
		end; 
	    if self.wellenCount ~= 0 and self.wellenCount ~= nil then
	    local getRx, getRy, getRz = getRotation(self.wheels[3].repr);
			for i=1, self.wellenCount do
				setRotation(self.Wellen[i], 0, 0, getRx);
			end;
	    end;		
    end; 
end;

function AllradV21:draw()
   	if self.AllradV21Active then
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("NAPEDOFF"), self.typeDesc), InputBinding.AllradV21);
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("NAPEDON"), self.typeDesc), InputBinding.AllradV21);
	end;
    if self.showhudAllrad == true then
		self.hudAllradOverlay:render();
    end;
end;

AllradStateEvent = {};
AllradStateEvent_mt = Class(AllradStateEvent, Event);

InitEventClass(AllradStateEvent, "AllradStateEvent");

function AllradStateEvent:emptyNew() 
    local self = Event:new(AllradStateEvent_mt );
    self.className="AllradStateEvent";
    return self;
end;

function AllradStateEvent:new(vehicle, state) 
    self.vehicle = vehicle;
    self.state = state;
    return self;
end;

function AllradStateEvent:readStream(streamId, connection)  
    local id = streamReadInt32(streamId); 
    self.state = streamReadBool(streamId); 
    self.vehicle = networkGetObject(id); 
    self:run(connection);  
end;

function AllradStateEvent:writeStream(streamId, connection)   
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
    streamWriteBool(streamId, self.state );   
end;

function AllradStateEvent:run(connection)  
    self.vehicle:allradState(self.state, true);
	if not connection:getIsServer() then  
		g_server:broadcastEvent(AllradStateEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function AllradStateEvent.sendEvent(vehicle, state, noEventSend)  
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then  
			g_server:broadcastEvent(AllradStateEvent:new(vehicle, state), nil, nil, vehicle);
		else 
			g_client:getServerConnection():sendEvent(AllradStateEvent:new(vehicle, state));
		end;
	end;
end;
