OPV2000 = {};

function OPV2000.prerequisitesPresent(specializations)
    return true;
end;

function OPV2000:load(xmlFile)

	self.getIsAreaActive = Utils.overwrittenFunction(self.getIsAreaActive, OPV2000.getIsAreaActive);	
	
	self.shaderParts = {};
	local i=0;
	while true do
		local partName = string.format("vehicle.shaderParts.shaderPart(%d)", i);
		local part = {};
		local nodeString = getXMLString(xmlFile, partName .. "#index");
		if nodeString == nil then
			break;
		else
			part.index = Utils.indexToObject(self.components, nodeString);
			part.offSpeed = Utils.getNoNil(getXMLFloat(xmlFile, partName .. "#offSpeed"), 90000000000);
			part.onSpeed = Utils.getNoNil(getXMLFloat(xmlFile, partName .. "#onSpeed"), 1.0);
			setShaderParameter(part.index, "partScale", part.offSpeed, 1, 0, 0, false);
			local isVisibility = getXMLString(xmlFile, partName .. "#setVisibilityTurnOn");
			if isVisibility ~= "" and isVisibility == "true" then
				part.visibility = false;
				setVisibility(part.index, part.visibility);
			end;
			table.insert(self.shaderParts, part);
		end;
		i = i+1;
	end;
	
	if self.isClient then
		self.extraParticleSystems = {};
		local i=0;
		while true do
			local key = string.format("vehicle.extraParticleSystems.extraParticleSystem(%d)", i);
			local node = getXMLString(xmlFile, key.. "#node");
			if node == nil then
				break;
			end;
			node = Utils.indexToObject(self.components, node);
			if node ~= nil then
				local psFile = getXMLString(xmlFile, key.. "#file");
				local extraParticleSystem = {};
				extraParticleSystem.particleSystem = {};
				StaticParticleSystem.loadParticleSystem(xmlFile, extraParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
				table.insert(self.extraParticleSystems, extraParticleSystem);
			end;
			i = i+1;
		end;
	end;
	
	self.saveSprayLitersPerSecond = nil;
end;

function OPV2000:delete()
	for k, extraParticleSystem in pairs(self.extraParticleSystems) do
		Utils.deleteParticleSystem(extraParticleSystem);
	end;
end;

function OPV2000:readStream(streamId, connection)
end;

function OPV2000:writeStream(streamId, connection)
end;

function OPV2000:mouseEvent(posX, posY, isDown, isUp, button)
end;

function OPV2000:keyEvent(unicode, sym, modifier, isDown)
end;

function OPV2000:update(dt)
	if self.isServer then
		if self.attacherVehicle ~= nil then
			if self.attacherVehicle:getIsHired() and self.attacherVehicle.isEntered then
				local sprayType = Sprayer.fillTypeToSprayType[self.currentFillType];
				if sprayType ~= nil then
					local litersPerSecond = self.sprayLitersPerSecond[self.currentFillType];
					if litersPerSecond == nil then
						litersPerSecond = self.defaultSprayLitersPerSecond;
					end;
					local usage = litersPerSecond * dt*0.001;
					local sprayTypeDesc = Sprayer.sprayTypeIndexToDesc[sprayType];
					local delta = usage*sprayTypeDesc.pricePerLiter;
					g_currentMission:addSharedMoney(delta);
					if self.fillLevel > 0 then
						self:setFillLevel(self.fillLevel - usage, self.currentFillType);
					end;
				end;
			end;
			if self.fillLevel <= 0 then
				self.attacherVehicle:stopAITractor();
			end;
		end;
	end;
end;

function OPV2000:updateTick(dt)
	if self.isTurnedOn then
		self:setAnimationTime(2, 1);
		self:setAnimationTime(3, self.animationParts[3].animDuration);
		for k, part in pairs(self.shaderParts) do
			setShaderParameter(part.index, "partScale", part.onSpeed, 1, 0, 0, false);
		end;
		if self.animationParts[3].clipEndTime then
			for k, part in pairs(self.shaderParts) do
				if part.visibility ~= nil then
					part.visibility = true;
					setVisibility(part.index, part.visibility);
				end;
			end;
			if self.currentFillType ~= 0 then
				if self.saveSprayLitersPerSecond == nil then
					self.saveSprayLitersPerSecond = self.sprayLitersPerSecond[self.currentFillType];
				else
					self.sprayLitersPerSecond[self.currentFillType] = math.max(self.saveSprayLitersPerSecond,((self.saveSprayLitersPerSecond*dt*0.001)*(self.lastSpeed*3600)));
				end;
			elseif self.fillLevel == 0 then
				self.saveSprayLitersPerSecond = 0;
			end;
			for k, extraParticleSystem in pairs(self.extraParticleSystems) do
				Utils.setEmittingState(extraParticleSystem.particleSystem, true);
			end;
		end;
	else
		self:setAnimationTime(3, self.animationParts[3].offSet);
		if self.animationParts[3].clipStartTime then
			for k, part in pairs(self.shaderParts) do
				setShaderParameter(part.index, "partScale", part.offSpeed, 1, 0, 0, false);
				if part.visibility ~= nil then
					part.visibility = false;
					setVisibility(part.index, part.visibility);
				end;
			end;
			self:setAnimationTime(2, 0);
			for k, extraParticleSystem in pairs(self.extraParticleSystems) do
				Utils.setEmittingState(extraParticleSystem.particleSystem, false);
			end;
		end;
	end;	
end;

function OPV2000:getIsAreaActive(superFunc, area)
	local isActive = false;
	if (self.isTurnedOn and self.animationParts[3].clipEndTime) or (not self.isTurnedOn and self.animationParts[3].clipStartTime) then
		isActive = true;
	end;
    if superFunc ~= nil then
        return superFunc(self, area) and isActive;
    end;
	return isActive;	
end;

function OPV2000:draw()
end;

function OPV2000:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	self:setAnimationTime(1, self.animationParts[1].animDuration);
end;

function OPV2000:onDetach()
	self:setAnimationTime(1, self.animationParts[1].startPosition);
end;

function OPV2000:aiTurnOn()
	self:setIsTurnedOn(true);
end;

function OPV2000:aiTurnOff()
	self:setIsTurnedOn(false);
end;

function OPV2000:aiLower()
	self:setIsTurnedOn(true);
end;

function OPV2000:aiRaise()
	self:setIsTurnedOn(false);
end;