--
-- Poznaniak dxl Seeder
-- author: Burner
-- date: 20.02.2012
--

Poznaniak = {};

function Poznaniak.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(SowingMachine, specializations);
end;

function Poznaniak:load(xmlFile)
	self.objectInRange = Poznaniak.objectInRange;
	self.setTramlinesOn = SpecializationUtil.callSpecializationsFunction("setTramlinesOn");
	
	self.numMarkerAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.markerAreas#count"), 0);
    self.markerAreas = {}
    for i=1, self.numMarkerAreas do
        self.markerAreas[i] = {};
        local areanamei = string.format("vehicle.markerAreas.markerArea%d", i);
        self.markerAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
        self.markerAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.markerAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
    end;
	
	self.aiFieldDetectArea = {};
    self.aiFieldDetectArea.start = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiFieldDetectArea#startIndex"));
    self.aiFieldDetectArea.width = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiFieldDetectArea#widthIndex"));
    self.aiFieldDetectArea.height = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.aiFieldDetectArea#heightIndex"));
	
	self.leftMarkerSpeedRotatingParts = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.leftMarkerSpeedRotatingParts.leftMarkerSpeedRotatingPart(%d)", i);
		local index = getXMLString(xmlFile, baseName.. "#index");
		if index == nil then
			break;
		end;
		local node = Utils.indexToObject(self.components, index);
		if node ~= nil then
			local entry = {};
			entry.node = node;
			entry.rotationSpeedScale = getXMLFloat(xmlFile, baseName.."#rotationSpeedScale");
			if entry.rotationSpeedScale == nil then
				entry.rotationSpeedScale = 1.0/Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#radius"), 1);
			end;
			entry.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMinLimit"), 0);
			entry.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMaxLimit"), 1);
			table.insert(self.leftMarkerSpeedRotatingParts, entry);
		end;
		i = i+1;
	end;
	
	self.rightMarkerSpeedRotatingParts = {};
	local i=0;
	while true do
		local baseName = string.format("vehicle.rightMarkerSpeedRotatingParts.rightMarkerSpeedRotatingPart(%d)", i);
		local index = getXMLString(xmlFile, baseName.. "#index");
		if index == nil then
			break;
		end;
		local node = Utils.indexToObject(self.components, index);
		if node ~= nil then
			local entry = {};
			entry.node = node;
			entry.rotationSpeedScale = getXMLFloat(xmlFile, baseName.."#rotationSpeedScale");
			if entry.rotationSpeedScale == nil then
				entry.rotationSpeedScale = 1.0/Utils.getNoNil(getXMLFloat(xmlFile, baseName.."#radius"), 1);
			end;
			entry.foldMinLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMinLimit"), 0);
			entry.foldMaxLimit = Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#foldMaxLimit"), 1);
			table.insert(self.rightMarkerSpeedRotatingParts, entry);
		end;
		i = i+1;
	end;
	
	self.leftMarkerParticleSystems = {};
	local psName = "vehicle.leftMarkerParticleSystem";
	Utils.loadParticleSystem(xmlFile, self.leftMarkerParticleSystems, psName, self.components, false, nil, self.baseDirectory);
	self.rightMarkerParticleSystems = {};
	local psName = "vehicle.rightMarkerParticleSystem";
	Utils.loadParticleSystem(xmlFile, self.rightMarkerParticleSystems, psName, self.components, false, nil, self.baseDirectory);
	
	self.tramlines = false;
end;

function Poznaniak:readStream(streamId, connection)
	self:setTramlinesOn(streamReadBool(streamId), true);
end;

function Poznaniak:writeStream(streamId, connection)
	streamWriteBool(streamId, self.tramlines);
end;
function Poznaniak:delete()
	Utils.deleteParticleSystem(self.leftMarkerParticleSystems);
	Utils.deleteParticleSystem(self.rightMarkerParticleSystems);
end;

function Poznaniak:update(dt)
	if self.isClient then
		-- left marker in range
		if self:objectInRange(self.animationParts[1].rootNode) then
			-- change marker width
			if InputBinding.isPressed(InputBinding.PoznaniakDXL_MarkerLong) then
				self:setAnimationTime(3, self.animationParts[3].currentPosition+(self.animationParts[3].offSet+dt), false);
			elseif InputBinding.isPressed(InputBinding.PoznaniakDXL_MarkerShort) then
				self:setAnimationTime(3, self.animationParts[3].currentPosition-(self.animationParts[3].offSet+dt), false);
			end;
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PoznaniakDXL_MarkerLong")), InputBinding.PoznaniakDXL_MarkerLong);
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PoznaniakDXL_MarkerShort")), InputBinding.PoznaniakDXL_MarkerShort);
		end;
		
		-- right marker in range
		if self:objectInRange(self.animationParts[2].rootNode) then
			-- change marker width
			if InputBinding.isPressed(InputBinding.PoznaniakDXL_MarkerLong) then
				self:setAnimationTime(4, self.animationParts[4].currentPosition+(self.animationParts[4].offSet+dt), false);
			elseif InputBinding.isPressed(InputBinding.PoznaniakDXL_MarkerShort) then
				self:setAnimationTime(4, self.animationParts[4].currentPosition-(self.animationParts[4].offSet+dt), false);
			end;
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PoznaniakDXL_MarkerLong")), InputBinding.PoznaniakDXL_MarkerLong);
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PoznaniakDXL_MarkerShort")), InputBinding.PoznaniakDXL_MarkerShort);
		end;
		
		-- cover in range
		if self:objectInRange(self.animationParts[5].rootNode) then
			if InputBinding.hasEvent(InputBinding.PoznaniakDXL_ToggleTankCover) then
				if self.animationParts[5].clipEndTime then
					self:setAnimationTime(5, self.animationParts[5].startPosition);
				elseif self.animationParts[5].clipStartTime then
					self:setAnimationTime(5, self.animationParts[5].animDuration);
				end;
			end;
			if self.animationParts[5].clipEndTime then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PoznaniakDXL_CloseGrainTaknCover")), InputBinding.PoznaniakDXL_ToggleTankCover);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PoznaniakDXL_OpenGrainTaknCover")), InputBinding.PoznaniakDXL_ToggleTankCover);
			end;
		end;
	end;
	
	if self:isLowered(false) then
		-- tramlines
		if self.tramlines then
			for i=3, 4 do
				if self.markerAreas[i] ~= nil then
					local x,y,z = getWorldTranslation(self.markerAreas[i].start);
					local x1,y1,z1 = getWorldTranslation(self.markerAreas[i].width);
					local x2,y2,z2 = getWorldTranslation(self.markerAreas[i].height);
					Utils.updateCultivatorArea(x, z, x1, z1, x2, z2, false);
				end;
			end;
		end;
		
		-- update left marker area
		if self.animationParts[1].clipEndTime then
			if self.markerAreas[1] ~= nil then
				local x,y,z = getWorldTranslation(self.markerAreas[1].start);
				local x1,y1,z1 = getWorldTranslation(self.markerAreas[1].width);
				local x2,y2,z2 = getWorldTranslation(self.markerAreas[1].height);
				Utils.updatePloughArea(x, z, x1, z1, x2, z2, false);
			end;
			for k,v in pairs(self.leftMarkerSpeedRotatingParts) do
				rotate(v.node, v.rotationSpeedScale * self.lastSpeedReal * self.movingDirection * dt, 0, 0);
			end;
			if self.lastSpeed*3600 > 3 then
				Utils.setEmittingState(self.leftMarkerParticleSystems, true);
			else
				Utils.setEmittingState(self.leftMarkerParticleSystems, false);
			end;
		else
			Utils.setEmittingState(self.leftMarkerParticleSystems, false);
		end;
				
		-- update right marker area
		if self.animationParts[2].clipEndTime then
			if self.markerAreas[2] ~= nil then
				local x,y,z = getWorldTranslation(self.markerAreas[2].start);
				local x1,y1,z1 = getWorldTranslation(self.markerAreas[2].width);
				local x2,y2,z2 = getWorldTranslation(self.markerAreas[2].height);
				Utils.updatePloughArea(x, z, x1, z1, x2, z2, false);
			end;
			for k,v in pairs(self.rightMarkerSpeedRotatingParts) do
				rotate(v.node, v.rotationSpeedScale * self.lastSpeedReal * self.movingDirection * dt, 0, 0);
			end;
			if self.lastSpeed*3600 > 3 then
				Utils.setEmittingState(self.rightMarkerParticleSystems, true);
			else
				Utils.setEmittingState(self.rightMarkerParticleSystems, false);
			end;
		else
			Utils.setEmittingState(self.rightMarkerParticleSystems, false);
		end;
	else
		Utils.setEmittingState(self.leftMarkerParticleSystems, false);
		Utils.setEmittingState(self.rightMarkerParticleSystems, false);
	end;

	if self:getIsActiveForInput() then	
		-- switch markers positions
		if InputBinding.hasEvent(InputBinding.PoznaniakDXL_ToggleMarkers) then
			if self.animationParts[1].clipEndTime then
				self:setAnimationTime(1, 1000);
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			else
				self:setAnimationTime(1, self.animationParts[1].animDuration);
				self:setAnimationTime(2, 1000);
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.PoznaniakDXL_FoldRightMarker) then
			if self.animationParts[2].clipStartTime then
				self:setAnimationTime(2, self.animationParts[2].animDuration);
			else
				self:setAnimationTime(2, self.animationParts[2].startPosition);
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.PoznaniakDXL_FoldLeftMarker) then
			if self.animationParts[1].clipStartTime then
				self:setAnimationTime(1, self.animationParts[1].animDuration);
			else
				self:setAnimationTime(1, self.animationParts[1].startPosition);
			end;
		end;
		
		if InputBinding.hasEvent(InputBinding.PoznaniakDXL_ToggleTramlines) then
			self:setTramlinesOn(not self.tramlines);
		end;
	end;
end;

function Poznaniak:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Poznaniak:keyEvent(unicode, sym, modifier, isDown)
end;

function Poznaniak:draw()
	if self.isClient then
		g_currentMission:addHelpButtonText(g_i18n:getText("PoznaniakDXL_ToggleMarkers"), InputBinding.PoznaniakDXL_ToggleMarkers);
		if self.animationParts[1].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PoznaniakDXL_UnfoldLeftMarker")), InputBinding.PoznaniakDXL_FoldLeftMarker);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PoznaniakDXL_FoldLeftMarker")), InputBinding.PoznaniakDXL_FoldLeftMarker);
		end;
		if self.animationParts[2].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PoznaniakDXL_UnfoldRightMarker")), InputBinding.PoznaniakDXL_FoldRightMarker);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("PoznaniakDXL_FoldRightMarker")), InputBinding.PoznaniakDXL_FoldRightMarker);
		end;
		if self.tramlines then
			g_currentMission:addHelpButtonText(g_i18n:getText("PoznaniakDXL_TramlinesOff"), InputBinding.PoznaniakDXL_ToggleTramlines);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("PoznaniakDXL_TramlinesOn"), InputBinding.PoznaniakDXL_ToggleTramlines);
		end;
	end;
end;

function Poznaniak:objectInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance = 2;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;

function Poznaniak:onAttach(attacherVehicle)
end;

function Poznaniak:onDetach()
end;

function Poznaniak:onDeactivate()
	Utils.setEmittingState(self.leftMarkerParticleSystems, false);
	Utils.setEmittingState(self.rightMarkerParticleSystems, false);
end;

function Poznaniak:setTramlinesOn(tramlinesOn, noEventSend)
	SetTramlinesOnEvent.sendEvent(self, tramlinesOn, noEventSend)
	self.tramlines = tramlinesOn;
end;

function Poznaniak:aiTurnOn()
	local x,y,z = getWorldTranslation(self.aiFieldDetectArea.start);
	local x1,y1,z1 = getWorldTranslation(self.aiFieldDetectArea.width);
	local x2,y2,z2 = getWorldTranslation(self.aiFieldDetectArea.height);
	local densLeft = 0;
	local densLeft = Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.ploughChannel, x, z, x1, z1, x2, z2);
	densLeft = densLeft + Utils.getDensity(g_currentMission.terrainDetailId, g_currentMission.cultivatorChannel, x, z, x1, z1, x2, z2);
	if densLeft > 0 then
		self:setAnimationTime(1, self.animationParts[1].animDuration);
		self:setAnimationTime(2, 1000);
	else
		self:setAnimationTime(1, 1000);
		self:setAnimationTime(2, self.animationParts[2].animDuration);
	end;
end;

function Poznaniak:aiRotateLeft()
	self:setAnimationTime(1, 1000);
	self:setAnimationTime(2, self.animationParts[2].animDuration);
end;

function Poznaniak:aiRotateRight()
	self:setAnimationTime(1, self.animationParts[1].animDuration);
	self:setAnimationTime(2, 1000);
end;

-- events
SetTramlinesOnEvent = {};
SetTramlinesOnEvent_mt = Class(SetTramlinesOnEvent, Event);

InitEventClass(SetTramlinesOnEvent, "SetTramlinesOnEvent");

function SetTramlinesOnEvent:emptyNew()
    local self = Event:new(SetTramlinesOnEvent_mt);
    self.className="SetTramlinesOnEvent";
    return self;
end;

function SetTramlinesOnEvent:new(vehicle, tramlinesState)
    local self = SetTramlinesOnEvent:emptyNew()
    self.vehicle = vehicle;
	self.tramlinesState = tramlinesState;
    return self;
end;

function SetTramlinesOnEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.tramlinesState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetTramlinesOnEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.tramlinesState);
end;

function SetTramlinesOnEvent:run(connection)   
	self.vehicle:setTramlinesOn(self.tramlinesState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetTramlinesOnEvent:new(self.vehicle, self.tramlinesState), nil, connection, self.vehicle);
    end;
end;

function SetTramlinesOnEvent.sendEvent(vehicle, tramlinesState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetTramlinesOnEvent:new(vehicle, tramlinesState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetTramlinesOnEvent:new(vehicle, tramlinesState));
		end;
	end;
end;